<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTIO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTIO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                          </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module><implements><A HREF="RTIO.i3">RTIO</A></implements></module>;

IMPORT <A HREF="../../../text/src/TextF.i3">TextF</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="RT0.i3">RT0</A>, <A HREF="RTOS.i3">RTOS</A>;

VAR
  len : INTEGER := 0;
  buf : ARRAY [0..1023] OF CHAR;

PROCEDURE <A NAME="PutChar"><procedure>PutChar</procedure></A> (c: CHAR) =
  BEGIN
    IF (len &gt; LAST (buf)) THEN Flush (); END;
    buf [len] := c;
    INC (len);
  END PutChar;

PROCEDURE <A NAME="PutChars"><procedure>PutChars</procedure></A> (a: ADDRESS;  n: INTEGER) =
  VAR p : RT0.String := a;
  BEGIN
    WHILE (n &gt; 0) DO
      PutChar (p^);
      INC (p, BYTESIZE (p^));
      DEC (n);
    END;
  END PutChars;

PROCEDURE <A NAME="PutString"><procedure>PutString</procedure></A> (s: ADDRESS) =
  VAR p : RT0.String := s;
  BEGIN
    IF (p = NIL) THEN RETURN; END;
    WHILE (p^ # '\000') DO
      PutChar (p^);
      INC (p, BYTESIZE (p^));
    END;
  END PutString;

PROCEDURE <A NAME="PutInt"><procedure>PutInt</procedure></A> (i: INTEGER;  width: INTEGER) =
  VAR
    num : ARRAY [0..30] OF CHAR;
    len := FromInt (ADR (num[0]), i, 10);
  BEGIN
    FOR i := 1 TO width - len DO PutChar (' ') END;
    PutChars (ADR (num[0]), len);
  END PutInt;

PROCEDURE <A NAME="PutHex"><procedure>PutHex</procedure></A> (i: INTEGER;  width: INTEGER) =
  VAR
    num : ARRAY [0..30] OF CHAR;
    len := FromUnsigned (ADR (num[2]), i, 16) + 2;
  BEGIN
    FOR i := 1 TO width - len DO PutChar (' ') END;
    num[0] := '0';
    num[1] := 'x';
    PutChars (ADR (num[0]), len);
  END PutHex;

PROCEDURE <A NAME="PutAddr"><procedure>PutAddr</procedure></A> (a: ADDRESS;  width: INTEGER) =
  BEGIN
    PutHex (LOOPHOLE (a, INTEGER), width);
  END PutAddr;

PROCEDURE <A NAME="PutText"><procedure>PutText</procedure></A> (t: TEXT) =
  BEGIN
    PutChars (ADR (t[0]), NUMBER (t^) - 1);
  END PutText;

PROCEDURE <A NAME="Flush"><procedure>Flush</procedure></A> () =
  BEGIN
    IF (len &gt; 0) THEN
      RTOS.Write (ADR (buf[0]), len);
      len := 0;
    END;
  END Flush;
</PRE>----------------------------------------------------- internal routines ---

<P>
<P><PRE>TYPE  Base = [2..16];
CONST Digits = ARRAY [0..15] OF CHAR {
                   '0', '1', '2', '3', '4', '5', '6', '7',
                   '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

PROCEDURE <A NAME="FromInt"><procedure>FromInt</procedure></A> (buf    : UNTRACED REF CHAR;
                   value  : INTEGER;
                   base   : Base := 10): INTEGER =
  VAR
    nDigits : INTEGER := 0;
    minus   : BOOLEAN := FALSE;
    bump    : BOOLEAN := FALSE;
    i, j    : INTEGER;
    c       : CHAR;
    result  : ARRAY [0..BITSIZE (INTEGER)] OF CHAR;

  BEGIN
    IF (value = 0) THEN
      result[0] := '0';
      nDigits := 1;
    ELSE (* handle a non-zero number *)
      (* get rid of negative numbers *)
      IF (value &lt; 0) THEN
        IF (value = FIRST (INTEGER)) THEN
          (* 2's complement makes FIRST(INTEGER) a special case *)
          bump := TRUE;
	  INC (value);
        END;
        minus := TRUE;
        value := -value;
        &lt;* ASSERT value &gt; 0 *&gt;
      END;

      (* convert the bulk of the digits *)
      WHILE (value &gt; 0) DO
        result [nDigits] := Digits [value MOD base];
        value := value DIV base;
        INC (nDigits);
      END;

      (* fixup FIRST (INTEGER) *)
      IF (bump) THEN
        result [nDigits] := '0';
        j := 0;
        LOOP
          c := result [j];
          IF (c &lt;= '9')
            THEN i := ORD (c) - ORD ('0');
            ELSE i := ORD (c) - ORD ('a') + 10;
          END;
          INC (i);
	  IF (i &lt; base) THEN  result [j] := Digits [i];  EXIT END;
	  result [j] := '0';
	  INC (j);
        END;
        nDigits := MAX (nDigits, j+1);
      END;
    END;

    (* build the result buffer *)
    j := 0;
    IF (minus)  THEN buf^ := '-';  j := 1; INC (buf, BYTESIZE (buf^)); END;
    FOR k := nDigits-1 TO 0 BY -1 DO
      buf^ := result [k];  INC (j); INC (buf, BYTESIZE (buf^));
    END;

    RETURN j;
  END FromInt;

PROCEDURE <A NAME="FromUnsigned"><procedure>FromUnsigned</procedure></A> (buf    : UNTRACED REF CHAR;
                        value  : INTEGER;
                        base   : Base := 10): INTEGER =
  VAR
    nDigits : INTEGER := 0;
    j       : INTEGER;
    result  : ARRAY [0..BITSIZE (INTEGER)] OF CHAR;
  BEGIN
    IF (value = 0) THEN
      result[0] := '0';
      nDigits := 1;
    ELSE
      (* convert the bulk of the digits *)
      WHILE (value # 0) DO
        result [nDigits] := Digits [Word.Mod (value, base)];
        value := Word.Divide (value, base);
        INC (nDigits);
      END;
    END;

    (* build the result buffer *)
    j := 0;
    FOR k := nDigits-1 TO 0 BY -1 DO
      buf^ := result [k];  INC (j); INC (buf, BYTESIZE (buf^));
    END;

    RETURN j;
  END FromUnsigned;

BEGIN
END RTIO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
