<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTLinker.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTLinker.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> The linker generates an inital direct call to this module's
   main body.  All Modula-3 code reached from here. 

<P><PRE>UNSAFE MODULE <module><implements><A HREF="RTLinker.i3">RTLinker</A></implements></module>;

IMPORT <A HREF="RT0.i3">RT0</A>, <A HREF="#x1">RT0u</A>, <A HREF="RTParams.i3">RTParams</A>, <A HREF="RTProcess.i3">RTProcess</A>, <A HREF="RTHeapRep.i3">RTHeapRep</A>, <A HREF="RTMisc.i3">RTMisc</A>;
IMPORT <A HREF="RTTypeSRC.i3">RTTypeSRC</A>, <A HREF="RTSignal.i3">RTSignal</A>, <A HREF="RTHooks.i3">RTHooks</A>, <A HREF="RTThreadInit.i3">RTThreadInit</A>, <A HREF="RTHeapInfo.i3">RTHeapInfo</A>;

VAR init_done := FALSE;

PROCEDURE <A NAME="ExportProcs"><procedure>ExportProcs</procedure></A> () =
  VAR
    n: RT0.ModulePtr;
    m: UNTRACED REF RT0.ModulePtr := info.modules;
    p: RT0.ProcPtr;
    v: UNTRACED REF ADDRESS;
  BEGIN
    (* initialize the interface records with the exported procedures *)
    FOR i := 0 TO info.n_modules - 1 DO
      n := m^;
      IF (n # NIL) AND (n.proc_info # NIL) THEN
        p := n.proc_info;
        WHILE (p.proc # NIL) DO
          v := p.export;
          IF (v # NIL) THEN v^ := p.proc; END;
          INC (p, ADRSIZE (p^));
        END;
      END;
      INC (m, ADRSIZE (m^));
    END;

    (* finally, patch up any &quot;static&quot; procedure constants *)
    m := info.modules;
    FOR i := 0 TO info.n_modules - 1 DO
      n := m^;
      IF (n = NIL) THEN
        RTMisc.FatalErrorI (&quot;empty slot in module table &quot;, i);
      END;
      IF (n.link # NIL) THEN n.link () END;
      INC (m, ADRSIZE (m^));
    END;
  END ExportProcs;

PROCEDURE <A NAME="RunMainBodies"><procedure>RunMainBodies</procedure></A> () =
  VAR
    n: RT0.ModulePtr;
    m: UNTRACED REF RT0.ModulePtr := info.modules;
  BEGIN
    FOR i := 0 TO info.n_modules - 1 DO
      n := m^;
      IF (n # NIL) AND (n.main # NIL) THEN n.main () END;
      INC (m, ADRSIZE (m^));
    END;
  END RunMainBodies;

BEGIN
  IF NOT init_done THEN
    init_done := TRUE;

    (* spread the linker variables around where they're needed *)
    RT0u.nModules    := info.n_modules;
    RT0u.modules     := info.modules;

    RTHooks.bottom_of_stack := info.bottom_of_stack;
    RTHooks.top_of_stack    := info.top_of_stack;

    (* run each of the init procs to initialize the interface records *)
    ExportProcs ();

    (* fix the runtime type structures *)
    RTTypeSRC.Init ();

    (* initialize the runtime *)
    RTSignal.InstallHandlers ();
    RTParams.Init ();
    RTHeapRep.Init ();
    RTThreadInit.Init ();
    RTHeapInfo.Init ();

    (* run the module main bodies *)
    RunMainBodies ();

    (* and be done *)
    RTProcess.Exit (0);
  END;
END RTLinker.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface RT0u is in:
</A><UL>
<LI><A HREF="../POSIX/RT0u.i3#0TOP0">runtime/src/POSIX/RT0u.i3</A>
<LI><A HREF="../WIN32/RT0u.i3#0TOP0">runtime/src/WIN32/RT0u.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
