<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTOS.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTOS.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>RTOS</CODE> is a private interface that provides the low-level,
   OS-specific memory allocation and shutdown routines. 

<P><PRE>INTERFACE <interface><A HREF="#x1">RTOS</A></interface>;

PROCEDURE <A HREF="#x2">Exit</A> (n: INTEGER);
</PRE><BLOCKQUOTE><EM> Terminate current process with return code <CODE>n</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x3">Crash</A> ();
</PRE><BLOCKQUOTE><EM> Terminate current process with a crash </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x4">GetMemory</A> (size: INTEGER): ADDRESS;
</PRE><BLOCKQUOTE><EM> Return the address of <CODE>size</CODE> bytes of unused storage </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x5">LockHeap</A> ();
</PRE><BLOCKQUOTE><EM> Enters an allocator/collector critical section; the same thread may
   enter the critical section multiple times.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x6">UnlockHeap</A> ();
</PRE><BLOCKQUOTE><EM> Leaves the critical section.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x7">Write</A> (a: ADDRESS;  n: INTEGER);
</PRE><BLOCKQUOTE><EM> Write the <CODE>n</CODE> bytes beginning at address <CODE>a</CODE> to the standard
   error output file or console. </EM></BLOCKQUOTE><PRE>

END RTOS.
</PRE>
</inInterface>
<HR>
<A NAME="x1">RTOS's implementation  is in:
</A><UL>
<LI><A HREF="../POSIX/RTOS.m3#0TOP0">runtime/src/POSIX/RTOS.m3</A>
<LI><A HREF="../WIN32/RTOS.m3#0TOP0">runtime/src/WIN32/RTOS.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure RTOS.Exit is in:
</A><UL>
<LI><A HREF="../POSIX/RTOS.m3#Exit">runtime/src/POSIX/RTOS.m3</A>
<LI><A HREF="../WIN32/RTOS.m3#Exit">runtime/src/WIN32/RTOS.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure RTOS.Crash is in:
</A><UL>
<LI><A HREF="../POSIX/RTOS.m3#Crash">runtime/src/POSIX/RTOS.m3</A>
<LI><A HREF="../WIN32/RTOS.m3#Crash">runtime/src/WIN32/RTOS.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure RTOS.GetMemory is in:
</A><UL>
<LI><A HREF="../POSIX/RTOS.m3#GetMemory">runtime/src/POSIX/RTOS.m3</A>
<LI><A HREF="../WIN32/RTOS.m3#GetMemory">runtime/src/WIN32/RTOS.m3</A>
</UL>
<P>
<HR>
<A NAME="x5">procedure RTOS.LockHeap is in:
</A><UL>
<LI><A HREF="../POSIX/RTOS.m3#LockHeap">runtime/src/POSIX/RTOS.m3</A>
<LI><A HREF="../WIN32/RTOS.m3#LockHeap">runtime/src/WIN32/RTOS.m3</A>
</UL>
<P>
<HR>
<A NAME="x6">procedure RTOS.UnlockHeap is in:
</A><UL>
<LI><A HREF="../POSIX/RTOS.m3#UnlockHeap">runtime/src/POSIX/RTOS.m3</A>
<LI><A HREF="../WIN32/RTOS.m3#UnlockHeap">runtime/src/WIN32/RTOS.m3</A>
</UL>
<P>
<HR>
<A NAME="x7">procedure RTOS.Write is in:
</A><UL>
<LI><A HREF="../POSIX/RTOS.m3#Write">runtime/src/POSIX/RTOS.m3</A>
<LI><A HREF="../WIN32/RTOS.m3#Write">runtime/src/WIN32/RTOS.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
