<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTPacking.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTPacking.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module><implements><A HREF="RTPacking.i3">RTPacking</A></implements></module>;

IMPORT <A HREF="#x1">FloatMode</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

CONST
  Bits = ARRAY [0..3] OF INTEGER { 8, 16, 32, 64 };

VAR
  init_done := FALSE;
  local     : T;

PROCEDURE <A NAME="Local"><procedure>Local</procedure></A> (): T =
  VAR
    a: RECORD ch: CHAR;  x: EXTENDED; END;
    b: RECORD ch: CHAR;  x: RECORD ch: CHAR; END; END;
    i: INTEGER := 1;
    x: ADDRESS := ADR (i);
    p: UNTRACED REF CHAR := x;
  BEGIN
    IF NOT init_done THEN
      local.word_size     := SizeOf (ADRSIZE (INTEGER));
      local.max_align     := SizeOf (ADR (a.x) - ADR (a.ch));
      local.struct_align  := SizeOf (ADR (b.x) - ADR (b.ch));
      local.little_endian := (p^ = VAL (1, CHAR));
      local.float         := FloatKind.IEEE;
      IF NOT FloatMode.IEEE THEN local.float := FloatKind.VAX; END;
      init_done := TRUE;
    END;
    RETURN local;
  END Local;

PROCEDURE <A NAME="SizeOf"><procedure>SizeOf</procedure></A> (n: INTEGER): CARDINAL =
  BEGIN
    (* convert address units to bits *)
    n := n DIV ADRSIZE(CHAR) * BITSIZE(CHAR);

    (* look for a known size *)
    FOR i := FIRST (Bits) TO LAST (Bits) DO
      IF (Bits[i] = n) THEN RETURN n; END;
    END;
    &lt;*ASSERT FALSE*&gt;
  END SizeOf;

PROCEDURE <A NAME="Encode"><procedure>Encode</procedure></A> (READONLY t: T): INTEGER =
  VAR n := 0;
  BEGIN
    n := Word.Or (Word.Shift (n, 2), BitSize (t.word_size));
    n := Word.Or (Word.Shift (n, 2), BitSize (t.max_align));
    n := Word.Or (Word.Shift (n, 2), BitSize (t.struct_align));
    n := Word.Or (Word.Shift (n, 1), ORD (t.little_endian));
    n := Word.Or (Word.Shift (n, 2), ORD (t.float));
    RETURN n;
  END Encode;

PROCEDURE <A NAME="Decode"><procedure>Decode</procedure></A> (i: INTEGER): T =
  VAR t: T;
  BEGIN
    t.float := VAL (Word.And (i, 3), FloatKind); i := Word.Shift (i, -2);
    t.little_endian := VAL (Word.And (i, 1), BOOLEAN); i := Word.Shift (i, -1);
    t.struct_align  := Bits[Word.And (i, 3)];    i := Word.Shift (i, -2);
    t.max_align     := Bits[Word.And (i, 3)];    i := Word.Shift (i, -2);
    t.word_size     := Bits[Word.And (i, 3)];    i := Word.Shift (i, -2);
    &lt;*ASSERT i = 0*&gt;
    RETURN t;
  END Decode;

PROCEDURE <A NAME="BitSize"><procedure>BitSize</procedure></A> (n: CARDINAL): CARDINAL =
  BEGIN
    FOR i := FIRST (Bits) TO LAST (Bits) DO
      IF (Bits[i] = n) THEN RETURN i; END;
    END;
    &lt;*ASSERT FALSE*&gt;
  END BitSize;

BEGIN
END RTPacking.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
