<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTParams.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTParams.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>RTParams</CODE> is a private interface. 

<P><PRE>INTERFACE <interface><A HREF="RTParams.m3">RTParams</A></interface>;
</PRE> This interface provides access to the <CODE>runtime</CODE> arguments from the
   command line.  Command line arguments that begin <CODE>@M3</CODE> are considered
   <CODE>runtime</CODE> arguments.  They are removed from the usual (argc, argv) list
   of arguments very early in initialization.  A runtime argument has the
   form <CODE>@M3x</CODE> or <CODE>@M3x=y</CODE>.  <CODE>x</CODE> is the <CODE>name</CODE> of the argument, <CODE>y</CODE> is its
   <CODE>value</CODE>, and <CODE>x=y</CODE> is the <CODE>full</CODE> argument.  If <CODE>=y</CODE> is missing, <CODE></CODE> is
   the argument's value. 

<P><PRE>VAR (*READONLY*) NumParameters: CARDINAL;
</PRE><BLOCKQUOTE><EM> Parameters are indexed from <CODE>0</CODE> to <CODE>NumParameters-1</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTParams.m3#Nth">Nth</A> (n: INTEGER): TEXT;
</PRE><BLOCKQUOTE><EM> returns the <CODE>n</CODE>-th <CODE>full</CODE> argument. If <CODE>n</CODE> is not in <CODE>[0..NumParameters-1]</CODE>,
   <CODE>NIL</CODE> is returned. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTParams.m3#IsPresent">IsPresent</A> (n: TEXT): BOOLEAN;
</PRE><BLOCKQUOTE><EM> returns <CODE>TRUE</CODE> iff <CODE>n</CODE> is the name of a defined runtime argument. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTParams.m3#Value">Value</A> (n: TEXT): TEXT;
</PRE><BLOCKQUOTE><EM> returns the value of the runtime argument with name <CODE>n</CODE>.  If <CODE>n</CODE> is not
   the name of a runtime argument, NIL is returned.  If <CODE>n</CODE> is the name of
   an argument that was specified as <CODE>@M3n</CODE>, the empty string <CODE></CODE> is
   returned. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTParams.m3#RawValue">RawValue</A> (n: TEXT): ADDRESS;
</PRE><BLOCKQUOTE><EM> returns the C <CODE>char*</CODE> that corresponds to the value. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTParams.m3#Init">Init</A> ();
</PRE><BLOCKQUOTE><EM> called by the runtime initialization code </EM></BLOCKQUOTE><PRE>

END RTParams.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
