<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTProcedure.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTProcedure.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><P>
  <CODE>RTProcedure</CODE> provides runtime access to the fingerprints of procedures.
<P>
  A procedure's fingerprint is a 64-bit checksum computed from its name
  and signature.  The probability of distinct procedures having the same
  fingerprint is very small.  See the <CODE>Fingerprint</CODE> interface for more details.


<P><PRE>INTERFACE <interface><A HREF="RTProcedure.m3">RTProcedure</A></interface>;

IMPORT <A HREF="../../../fingerprint/src/Fingerprint.i3">Fingerprint</A>;

TYPE Proc = ADDRESS;
</PRE><BLOCKQUOTE><EM> Representing a procedure by its address seems to be the best Modula-3
   approximation we can give for the supertype of all procedure types. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTProcedure.m3#ToFingerprint">ToFingerprint</A>(p: Proc): Fingerprint.T;
</PRE><BLOCKQUOTE><EM> Return the fingerprint of the top-level procedure <CODE>p</CODE>.  It is a
   checked runtime error if <CODE>p</CODE> is not a top-level procedure. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTProcedure.m3#FromFingerprint">FromFingerprint</A>(READONLY fp: Fingerprint.T): Proc;
</PRE><BLOCKQUOTE><EM> Return the address of the top-level procedure with fingerprint <CODE>fp</CODE>.
   If no such procedure exists, returns <CODE>NIL</CODE>. </EM></BLOCKQUOTE><PRE>

END RTProcedure.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
