<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTProcedure.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTProcedure.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module>RTProcedure</module> EXPORTS <A HREF="RTProcedure.i3"><implements>RTProcedure</A></implements>, <A HREF="RTProcedureSRC.i3"><implements>RTProcedureSRC</A></implements>;

IMPORT <A HREF="RT0.i3">RT0</A>, <A HREF="RTMisc.i3">RTMisc</A>, <A HREF="RTModule.i3">RTModule</A>, <A HREF="../../../fingerprint/src/Fingerprint.i3">Fingerprint</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

CONST
  Max_procedure_length = 20000; (* more than 99% of procedures are shorter
                                   than this. *)

TYPE
  Info     = RT0.ProcPtr;
  InfoList = UNTRACED REF ARRAY OF Info;
  NameList = UNTRACED REF ARRAY OF Name;
</PRE> NOTE: since this module may be invoked during a startup
   crash, we don't use a mutex to protect writes to the
   global variables.  Instead, we assume that assigning a
   REF is an atomic operation.  It's possible that a thread
   race duing Init() will cause some garbage memory to be
   permanently allocated.  

<P><PRE>VAR
 nProcs : INTEGER  := 0;
 info   : InfoList := NIL;
 units  : NameList := NIL;
 min_pc : ADDRESS  := NIL;
 max_pc : ADDRESS  := NIL;
</PRE>----------------------------------------------------------- RTProcedure ---

<P><PRE>PROCEDURE <A NAME="ToFingerprint"><procedure>ToFingerprint</procedure></A> (&lt;*UNUSED*&gt; p: Proc): Fingerprint.T =
  BEGIN
    RTMisc.FatalError (NIL, 0, &quot;RTProcedure.ToFingerprint is not supported&quot;);
    RETURN Fingerprint.Zero;
  END ToFingerprint;

PROCEDURE <A NAME="FromFingerprint"><procedure>FromFingerprint</procedure></A> (&lt;*UNUSED*&gt; READONLY fp: Fingerprint.T): Proc =
  BEGIN
    RTMisc.FatalError (NIL, 0, &quot;RTProcedure.FromFingerprint is not supported&quot;);
    RETURN NIL;
  END FromFingerprint;
</PRE>-------------------------------------------------------- RTProcedureSRC ---

<P><PRE>PROCEDURE <A NAME="NumProcedures"><procedure>NumProcedures</procedure></A> (): CARDINAL =
  BEGIN
    IF (nProcs = 0) THEN CountProcs () END;
    RETURN nProcs;
  END NumProcedures;

PROCEDURE <A NAME="FromPC"><procedure>FromPC</procedure></A> (pc: ADDRESS;  VAR p: Proc;  VAR file, name: Name) =
  VAR x: Info;  best, best_diff, diff: INTEGER;
  BEGIN
    IF (info = NIL) THEN Init () END;
    p    := NIL;
    name := NIL;
    file := NIL;

    IF (pc &lt; min_pc) OR (max_pc &lt;= pc) THEN (*don't bother*) RETURN; END;

    best := Locate (pc);  (* try the hash table for an exact match *)

    IF (best &lt; 0) THEN    (* resort to linear search *)
      best_diff := LAST (INTEGER);
      FOR i := 0 TO LAST (info^) DO
        x := info[i];
        IF (x # NIL) THEN
          diff := (pc - x.proc);
          IF (0 &lt;= diff) AND (diff &lt; best_diff) THEN
            best := i;
            best_diff := diff;
          END;
        END;
      END;
    END;

    IF (best &gt;= 0) THEN
      x    := info[best];
      p    := x.proc;
      name := x.name;
      file := units[best];
    END;
  END FromPC;
</PRE>-------------------------------------------------------------- internal ---

<P><PRE>PROCEDURE <A NAME="CountProcs"><procedure>CountProcs</procedure></A> () =
  VAR j, n: INTEGER;  p: RT0.ProcPtr;
  BEGIN
    n := 0;
    FOR i := 0 TO RTModule.Count() - 1 DO
      p := RTModule.Get (i).proc_info;
      IF (p # NIL) THEN
        j := 0;
        WHILE (p^.proc # NIL) DO INC (p, ADRSIZE (p^)); INC (j) END;
        INC (n, j);
      END;
    END;
    nProcs := n; (* ... we'll assume that this update is atomic ... *)
  END CountProcs;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> () =
  VAR
    p: RT0.ProcPtr;
    m: RT0.ModulePtr;
    my_info: InfoList;
    my_units: NameList;
  BEGIN
    IF (nProcs = 0) THEN CountProcs () END;
    min_pc := LOOPHOLE (LAST (INTEGER), ADDRESS);
    max_pc := NIL;

    (* allocate the an array of Info pointers *)
    my_info  := NEW (InfoList, 3 * nProcs);
    my_units := NEW (NameList, 3 * nProcs);

    (* for each procedure, insert its info entry into the array *)
    FOR i := 0 TO RTModule.Count () - 1 DO
      m := RTModule.Get (i);
      p := m.proc_info;
      IF (p # NIL) THEN
        WHILE (p.proc # NIL) DO
          Insert (m, p^, my_info, my_units);
          IF (p.proc &lt; min_pc) THEN min_pc := p.proc; END;
          IF (p.proc &gt; max_pc) THEN max_pc := p.proc; END;
          INC (p, ADRSIZE (p^));
        END;
      END;
    END;

    (* update the globals to record the new info *)
    IF (info = NIL) THEN
      max_pc := max_pc + Max_procedure_length;
      units := my_units;
      info := my_info;
      (* ... we'll assume that this update is atomic ... *)
    END;
  END Init;
</PRE>* CONST Multiplier = 1052824; *
<PRE>CONST Multiplier = 2 * 2 * 3 * 5 * 7 * 11 * 13 * 17 * 19 * 23 + 1;
</PRE><BLOCKQUOTE><EM> See Knuth Vol. 2, Theorem A, page 16. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (m: RT0.ModulePtr;  VAR xx: RT0.ProcInfo;
                  info: InfoList;  units: NameList) =
  (* called while 'mu' is held *)
  VAR x: Info;  hash, index: INTEGER;
  BEGIN
    hash := LOOPHOLE (xx.proc, INTEGER);
    LOOP
      index := Word.Mod (hash, NUMBER (info^));
      x := info [index];
      IF (x = NIL) THEN
        info [index] := ADR (xx);
        units [index] := m.file;
        RETURN;
      END;
      IF (x.proc = xx.proc) THEN  RETURN  END;
      hash := Word.Plus (1, Word.Times (hash, Multiplier));
    END;
  END Insert;

PROCEDURE <A NAME="Locate"><procedure>Locate</procedure></A> (proc: Proc): INTEGER =
  (* called while 'mu' is held *)
  VAR x: Info;  hash, index: INTEGER;
  BEGIN
    hash := LOOPHOLE (proc, INTEGER);
    LOOP
      index := Word.Mod (hash, NUMBER (info^));
      x := info [index];
      IF (x = NIL)       THEN RETURN -1 END;
      IF (x.proc = proc) THEN RETURN index   END;
      hash := Word.Plus (1, Word.Times (hash, Multiplier));
    END;
  END Locate;

BEGIN
END RTProcedure.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
