<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTProcess.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTProcess.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="RTProcess.i3">RTProcess</A></implements></module>;

IMPORT <A HREF="RTHeapRep.i3">RTHeapRep</A>, <A HREF="RTException.i3">RTException</A>, <A HREF="RTIO.i3">RTIO</A>, <A HREF="RTOS.i3">RTOS</A>;
</PRE>-------------------------------- program startup/shutdown -----------------

<P><PRE>TYPE
  Exitor = UNTRACED BRANDED &quot;RTProcess.Exitor&quot; REF RECORD
             proc: PROCEDURE ();
             next: Exitor;
           END;
</PRE> Exitors are untraced because we don't want to depend on the
   collector during a crash.  Since they're never disposed, we
   have a small memory leak, probably about (3 * 16 bytes)/process. 

<P><PRE>VAR
  exitors: Exitor := NIL;

PROCEDURE <A NAME="RegisterExitor"><procedure>RegisterExitor</procedure></A> (p: PROCEDURE ()) =
  BEGIN
    exitors := NEW (Exitor, proc := p, next := exitors);
  END RegisterExitor;

PROCEDURE <A NAME="InvokeExitors"><procedure>InvokeExitors</procedure></A> () =
  VAR tmp: Exitor;
  BEGIN
    (* run the registered &quot;exit&quot; routines *)
    WHILE exitors # NIL DO
      (* to ensure progress, remove an element from the list before
         invoking it *)
      tmp := exitors;
      exitors := exitors.next;
      tmp.proc ();
    END;
  END InvokeExitors;

PROCEDURE <A NAME="Exit"><procedure>Exit</procedure></A> (n: INTEGER) =
  BEGIN
    InvokeExitors ();
    RTOS.Exit (n);
  END Exit;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A> (msg: TEXT) =
  BEGIN
    IF (msg # NIL) THEN
      RTIO.PutText (&quot;\n*** &quot;);
      RTIO.PutText (msg);
      RTIO.PutText (&quot;\n&quot;);
    END;
    RTException.DumpStack ();
    RTIO.Flush ();

    (* run the registered &quot;exit&quot; routines *)
    InvokeExitors ();

    (* crash *)
    EVAL RTHeapRep.Crash ();
    RTOS.Crash ();
  END Crash;
</PRE>------------------------------------------------------ Ctl-C interrupts ---

<P><PRE>VAR cur_handler: InterruptHandler := NIL;

PROCEDURE <A NAME="OnInterrupt"><procedure>OnInterrupt</procedure></A> (p: InterruptHandler): InterruptHandler =
  (* This procedure should be atomic... but I doubt anyone cares. *)
  VAR old := cur_handler;
  BEGIN
    cur_handler := p;
    RETURN old;
  END OnInterrupt;

BEGIN
END RTProcess.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
