<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTTipe.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTTipe.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="RTTipe.m3">RTTipe</A></interface>;

IMPORT <A HREF="RT0.i3">RT0</A>, <A HREF="RTPacking.i3">RTPacking</A>;

TYPE
  T = OBJECT kind: Kind;  size, align: INTEGER := 0; END;

TYPE
  Kind = {
    Address, Array, Boolean, Cardinal, Char, Enum, Extended,
    Integer, Longreal, Null, Object, OpenArray, Packed, Proc, Real,
    Record, Ref, Refany, Set, Subrange, UntracedRef };

CONST
  BuiltinKinds = SET OF Kind {
    Kind.Address, Kind.Boolean, Kind.Cardinal, Kind.Char, Kind.Extended,
    Kind.Integer, Kind.Longreal, Kind.Null, Kind.Proc, Kind.Real, Kind.Refany
  };

TYPE
  Builtin   = T OBJECT END;
  Array     = T OBJECT n_elts: INTEGER; element: T; elt_pack: INTEGER; END;
  Enum      = T OBJECT n_elts: INTEGER; END;
  Object    = T OBJECT super: RT0.TypeDefn;  fields: Field;
                       field_size, field_align: INTEGER; END;
  OpenArray = T OBJECT n_dimensions: INTEGER; element: T; elt_pack:INTEGER END;
  Packed    = T OBJECT n_bits: INTEGER; base: T; END;
  Record    = T OBJECT fields: Field;  END;
  Ref       = T OBJECT traced: BOOLEAN; uid: INTEGER; self: RT0.TypeDefn; END;
  Set       = T OBJECT n_elts: INTEGER; END;
  Subrange  = T OBJECT min, max: INTEGER; END;

  Field = REF RECORD type: T;  next: Field;  offset: INTEGER := 0; END;

PROCEDURE <A HREF="RTTipe.m3#Get">Get</A> (typecode: INTEGER;  READONLY packing: RTPacking.T): T;
</PRE><BLOCKQUOTE><EM> Returns the type bound to 'typecode' if it is traced.
   Otherwise, returns NIL.  Sets the size, alignment and offset
   fields of the returned value to correspond to the specified
   packing.  The sizes, alignments and field offsets are
   specified in bits. </EM></BLOCKQUOTE><PRE>

END RTTipe.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
