<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTType.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTType.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM><PRE>
                                                                  
</EM></BLOCKQUOTE><PRE>
</PRE><P>
  <CODE>RTType</CODE> provides access to the runtime type system.
  \index{runtime type}
  \index{type!runtime}
<P>
  Each reference type is assigned a unique typecode.  A typecode is
  ``proper'' if it lies in the range <CODE>[0..MaxTypecode()]</CODE>.  The proper
  typecodes include all those that correspond to actual types in the
  running Modula-3 program.  Other typecodes, proper and improper, may
  be used internally by the runtime system and garbage collector.
<P>
  Although the language requires that typecodes exist only for object
  types and for traced reference types (including <CODE>NULL</CODE>), the
  implementation of <CODE>RTType</CODE> also provides typecodes for untraced
  reference types.
<P>
  The values returned by the builtin operation <CODE>TYPECODE</CODE> correspond
  to (a subset of) the proper typecodes.


<P><PRE>INTERFACE <interface><A HREF="RTType.m3">RTType</A></interface>;

IMPORT <A HREF="RT0.i3">RT0</A>;

TYPE Typecode = RT0.Typecode;

CONST NoSuchType: Typecode = LAST(Typecode);
</PRE><BLOCKQUOTE><EM> A reserved typecode that represents unknown types. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTType.m3#MaxTypecode">MaxTypecode</A>(): Typecode;
</PRE><BLOCKQUOTE><EM> Return the largest proper typecode. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTType.m3#IsSubtype">IsSubtype</A>(a, b: Typecode): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> iff the type corresponding to <CODE>a</CODE> is a subtype of the
   type corresponding to <CODE>b</CODE>.  It is a checked runtime error if either
   <CODE>a</CODE> or <CODE>b</CODE> is not a proper typecode. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTType.m3#Supertype">Supertype</A>(tc: Typecode): Typecode;
</PRE><BLOCKQUOTE><EM> Return the typecode of the declared supertype of the object type
   corresponding to <CODE>tc</CODE>.  If <CODE>tc</CODE> corresponds to <CODE>ROOT</CODE>, <CODE>UNTRACED
   ROOT</CODE> or a non-object reference type, return <CODE>NoSuchType</CODE>.  It is a
   checked runtime error if <CODE>tc</CODE> is not a proper typecode. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTType.m3#IsTraced">IsTraced</A>(tc: Typecode): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> iff the type corresponding to <CODE>tc</CODE> is traced. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTType.m3#Get">Get</A>(tc: Typecode): RT0.TypeDefn;
</PRE><BLOCKQUOTE><EM> Return a pointer to the typecell with typecode <CODE>tc</CODE>.  It is a
   checked runtime error to pass an improper typecode. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTType.m3#GetNDimensions">GetNDimensions</A>(tc: Typecode): CARDINAL;
</PRE><BLOCKQUOTE><EM> Return the number of open dimensions of the open array type that
   corresponds to <CODE>tc</CODE>'s referent.  If <CODE>tc</CODE>'s referent is not an open
   array, return <CODE>0</CODE>. </EM></BLOCKQUOTE><PRE>

END RTType.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
