<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTTypeFP.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTTypeFP.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><P>
  <CODE>RTTypeFP</CODE> provides runtime access to type fingerprints.
  \index{fingerprint!of type}
  \index{type!fingerprint of}
<P>
  A type's fingerprint is a 64-bit checksum computed from its declaration.
  The probability of distinct types having the same fingerprint is very
  small.  See the <CODE>Fingerprint</CODE> interface for more details.
<P>
  Typecodes may vary between executions of a program but fingerprints
  do not.  Fingerprints are portable across multiple runs of a single
  program and across all programs compiled by the same compiler.


<P><PRE>INTERFACE <interface><A HREF="RTTypeFP.m3">RTTypeFP</A></interface>;

IMPORT <A HREF="../../../fingerprint/src/Fingerprint.i3">Fingerprint</A>;
FROM <A HREF="RTType.i3">RTType</A> IMPORT Typecode;

PROCEDURE <A HREF="RTTypeFP.m3#ToFingerprint">ToFingerprint</A>(tc: Typecode): Fingerprint.T;
</PRE><BLOCKQUOTE><EM> Return the fingerprint corresponding to <CODE>tc</CODE>.  It is a checked
   runtime error if <CODE>tc</CODE> is not proper or does not name a traced
   reference type. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RTTypeFP.m3#FromFingerprint">FromFingerprint</A>(READONLY fp: Fingerprint.T)
  : Typecode;
</PRE><BLOCKQUOTE><EM> Return the typecode that corresponds to <CODE>fp</CODE>.  If no such typecode
   exists, returns <CODE>RTType.NoSuchType</CODE>. </EM></BLOCKQUOTE><PRE>

END RTTypeFP.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
