<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTTypeFP.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTTypeFP.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module><implements><A HREF="RTTypeFP.i3">RTTypeFP</A></implements></module>;

IMPORT <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../../../fingerprint/src/Fingerprint.i3">Fingerprint</A>;
IMPORT <A HREF="RT0.i3">RT0</A>, <A HREF="#x1">RT0u</A>, <A HREF="RTType.i3">RTType</A>;
FROM <A HREF="RTType.i3">RTType</A> IMPORT Typecode;

VAR map : UNTRACED REF ARRAY OF INTEGER := NIL;

PROCEDURE <A NAME="ToFingerprint"><procedure>ToFingerprint</procedure></A> (tc: Typecode): Fingerprint.T =
  VAR t := RTType.Get (tc);  fp: Fingerprint.T;
  BEGIN
    LOOPHOLE (fp, RT0.Fingerprint) := t.fp;
    RETURN fp;
  END ToFingerprint;

PROCEDURE <A NAME="FromFingerprint"><procedure>FromFingerprint</procedure></A> (READONLY fp_in: Fingerprint.T): Typecode =
  VAR n, x, y : INTEGER;  t: RT0.TypeDefn;  fp: RT0.Fingerprint;
  BEGIN
    fp := LOOPHOLE (fp_in, RT0.Fingerprint);
    IF (map = NIL) THEN BuildFPMap () END;
    n := NUMBER (map^);
    x := FPHash (fp, n);
    LOOP
      y := map[x];
      IF (y = RTType.NoSuchType) THEN  RETURN RTType.NoSuchType;  END;
      t := RTType.Get (y);
      IF (t.fp = fp) THEN  RETURN t.typecode;  END;
      INC (x);  IF (x &gt;= n) THEN x := 0 END;
    END;
  END FromFingerprint;

PROCEDURE <A NAME="BuildFPMap"><procedure>BuildFPMap</procedure></A> () =
  VAR
    n   := RT0u.nTypes;
    n_m := 3 * n;
    m   := NEW (UNTRACED REF ARRAY OF INTEGER, n_m);
    t   : RT0.TypeDefn;
    x   : INTEGER;
  BEGIN
    FOR i := FIRST (m^) TO LAST (m^) DO
      m[i] := RTType.NoSuchType;
    END;
    FOR i := 0 TO n-1 DO
      t := RTType.Get (i);
      IF (t.traced # 0) OR (t.typecode = RT0.NilTypecode) THEN
        x := FPHash (t.fp, n_m);
        WHILE (m[x] # RTType.NoSuchType) DO
          INC (x);
          IF (x &gt;= n_m) THEN x := 0 END;
        END;
        m[x] := t.typecode;
      END;
    END;
    map := m;
  END BuildFPMap;

PROCEDURE <A NAME="FPHash"><procedure>FPHash</procedure></A> (READONLY fp: RT0.Fingerprint;  x: INTEGER): INTEGER =
  BEGIN
    RETURN Word.Xor (fp[0], fp[1]) MOD x;
  END FPHash;

BEGIN
END RTTypeFP.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface RT0u is in:
</A><UL>
<LI><A HREF="../POSIX/RT0u.i3#0TOP0">runtime/src/POSIX/RT0u.i3</A>
<LI><A HREF="../WIN32/RT0u.i3#0TOP0">runtime/src/WIN32/RT0u.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
