<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTTypeMap.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTTypeMap.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="RTTypeMap.m3">RTTypeMap</A></interface>;
</PRE> An RTTypeMap.T, type map, defines the layout of runtime values. Type
   maps are provided by the compiler.
<P>
   A type map is a pointer to a byte stream that defines a program
   for a simple virtual machine.  By executing that program each
   scalar field of a runtime value can be located.  See RTMapOp for
   a detailed description of the virtual instructions.


<P><PRE>TYPE
  T    = ADDRESS;
  Mask = SET OF Kind;
  Kind = {
    Ref, UntracedRef, Proc,         (* traced ref, untraced ref, procedure *)
    Real, Longreal, Extended,       (* floating point value *)
    Int_1, Int_2, Int_4, Int_8,     (* 1, 2, 4, or 8 byte signed integer *)
    Word_1, Word_2, Word_4, Word_8, (* 1, 2, 4, or 8 byte unsigned integer *)
    Int_Field, Word_Field,          (* signed or unsigned bit field *)
    Set                             (* bit set *)
  };

TYPE <A HREF="RTTypeMap.m3#Visitor">Visitor</A> &lt;: V_;
     V_ = OBJECT METHODS apply (field: ADDRESS;  k: Kind) RAISES ANY END;

PROCEDURE <A HREF="RTTypeMap.m3#WalkRef">WalkRef</A> (r: REFANY;  m: Mask;  v: Visitor) RAISES ANY;
</PRE><BLOCKQUOTE><EM> Locate each scalar field of the referent <CODE>r^</CODE>.  For each field with
   kind 'k' in 'm' that's found at address 'x', call 'v.apply(x, k)'.
   The only exceptions raised are those raised by 'v's apply method. </EM></BLOCKQUOTE><PRE>

END RTTypeMap.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
