<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/common/RTutils.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/common/RTutils.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module><implements><A HREF="RTutils.i3">RTutils</A></implements></module>;

IMPORT <A HREF="RTHeapRep.i3">RTHeapRep</A>, <A HREF="RTType.i3">RTType</A>, <A HREF="RTTypeSRC.i3">RTTypeSRC</A>, <A HREF="RTIO.i3">RTIO</A>;

TYPE
  TypeDesc = RECORD
    count : INTEGER := 0;
    size  : INTEGER := 0;
  END;

TYPE
  R = REF ARRAY OF TypeDesc;
  Map = REF ARRAY OF INTEGER;

  Visitor = RTHeapRep.RefVisitor OBJECT
              r         : R;
              countSum  := 0;
              sizeSum   := 0
            OVERRIDES
              visit := Walk
            END;

VAR v := NewVisitor ();

PROCEDURE <A NAME="NewVisitor"><procedure>NewVisitor</procedure></A> (): Visitor =
  BEGIN
    RETURN NEW (Visitor, r := NEW (R, RTType.MaxTypecode() + 1));
  END NewVisitor;

PROCEDURE <A NAME="Heap"><procedure>Heap</procedure></A> (suppressZeros := FALSE;
                presentation := HeapPresentation.ByTypecode;
                window := LAST(INTEGER)) =
  BEGIN
    Compute ();
    Report (v, suppressZeros, presentation, window)
  END Heap;

PROCEDURE <A NAME="NewHeap"><procedure>NewHeap</procedure></A> (suppressZeros := FALSE;
                   presentation := HeapPresentation.ByTypecode;
                   window := LAST(INTEGER)) =
  VAR oldv := v;
  BEGIN
    Compute ();
    Report (Delta (v, oldv), suppressZeros, presentation, window)
  END NewHeap;

PROCEDURE <A NAME="Compute"><procedure>Compute</procedure></A> () =
  BEGIN
    v := NewVisitor ();
    RTHeapRep.VisitAllRefs (v)
  END Compute;

PROCEDURE <A NAME="Delta"><procedure>Delta</procedure></A> (v1, v2: Visitor): Visitor =
  VAR v := NewVisitor ();
  BEGIN
    v.countSum := v1.countSum - v2.countSum;
    v.sizeSum := v1.sizeSum - v2.sizeSum;
    FOR i := 0 TO LAST (v.r^) DO
      v.r [i].count := v1.r [i].count - v2.r [i].count;
      v.r [i].size := v1.r [i].size - v2.r [i].size
    END;
    RETURN v
  END Delta;

PROCEDURE <A NAME="Report"><procedure>Report</procedure></A> (v: Visitor;
                  suppressZeros: BOOLEAN;
                  presentation: HeapPresentation;
                  window: INTEGER) =
  VAR
    nPrinted := 0;
    map := NEW (Map, NUMBER (v.r^));
  BEGIN
    FOR i := 0 TO LAST (map^) DO map[i] := i; END;
    CASE presentation OF
    | HeapPresentation.ByTypecode  =&gt; (*SKIP*)
    | HeapPresentation.ByNumber    =&gt; Sort (map, v.r, CompareCount)
    | HeapPresentation.ByByteCount =&gt; Sort (map, v.r, CompareSize)
    END;
    RTIO.PutText (
      (* 012345678901234567890123456789012345678901234567890 *)
        &quot;Code   Count   TotalSize  AvgSize  Name\n&quot;
      &amp; &quot;---- --------- --------- --------- --------------------------\n&quot;);
    FOR i := 0 TO LAST (v.r^) DO
      IF (nPrinted &gt;= window) THEN EXIT; END;
      WITH tc = map[i], zz =v.r[tc] DO
        IF (zz.count &gt; 0) OR (NOT suppressZeros) THEN
          RTIO.PutInt (tc, 4);
          RTIO.PutInt (zz.count, 10);
          RTIO.PutInt (zz.size, 10);
          IF (zz.count = 0)
            THEN RTIO.PutText (&quot;         0&quot;);
            ELSE RTIO.PutInt  (zz.size DIV zz.count, 10);
          END;
          RTIO.PutChar (' ');
          RTIO.PutText (RTTypeSRC.TypecodeName (tc));
          RTIO.PutChar ('\n');
          INC(nPrinted);
        END
      END;
    END;
    RTIO.PutText (&quot;     --------- ---------\n    &quot;);
    RTIO.PutInt  (v.countSum, 10);
    RTIO.PutInt  (v.sizeSum, 10);
    RTIO.PutChar ('\n');
    RTIO.Flush ();
    map := NIL;
  END Report;

PROCEDURE <A NAME="Walk"><procedure>Walk</procedure></A> (v    : Visitor;
                tc   : RTType.Typecode;
   &lt;* UNUSED *&gt; r    : REFANY;
                size : CARDINAL): BOOLEAN =
  BEGIN
    INC (v.r [tc].count);
    INC (v.r [tc].size, size);
    INC (v.countSum);
    INC (v.sizeSum, size);
    RETURN TRUE
  END Walk;
</PRE>--------------------------------------------------------------- sorting ---

<P><PRE>PROCEDURE <A NAME="Sort"><procedure>Sort</procedure></A> (map: Map;  r: R;  cmp := CompareCount) =
  (* insertion sort such that:  i &lt;= j =&gt;  cmp (r[map[i]], r[map[j]]) &lt;= 0 *)
  VAR n := NUMBER (map^);  j: INTEGER;
  BEGIN
    FOR i := 1 TO n-2 DO
      WITH key = r[map[i]] DO
        j := i-1;
        WHILE (j &gt;= 0) AND cmp (key, r[map[j]]) &lt; 0 DO
          map[j+1] := map[j];
          DEC (j);
        END;
        map[j+1] := i;
      END;
    END;
  END Sort;

PROCEDURE <A NAME="CompareCount"><procedure>CompareCount</procedure></A> (READONLY x, y: TypeDesc): INTEGER =
  BEGIN
    RETURN y.count - x.count;
  END CompareCount;

PROCEDURE <A NAME="CompareSize"><procedure>CompareSize</procedure></A> (READONLY x, y: TypeDesc): INTEGER =
  BEGIN
    RETURN y.size - x.size;
  END CompareSize;

BEGIN
END RTutils.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
