<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/ex_stack/RTExRep.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/ex_stack/RTExRep.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

UNSAFE INTERFACE <interface><A HREF="#x1">RTExRep</A></interface>;

IMPORT <A HREF="#x2">RTMachine</A>;
</PRE> This interface defines the low-level routines and data structures
   used by the exception runtime's stack walker.


<P>--------------------------------------------------------- runtime hooks ---
 Each machine must define <CODE>Frame</CODE>, <CODE>CurrentFrame</CODE>, <CODE>PreviousFrame</CODE>,
   <CODE>Unwind</CODE>, and <CODE>ProcName</CODE>.  The <CODE>Frame</CODE> type must minimally include fields
   named <CODE>pc</CODE> and <CODE>sp</CODE>.  It is ok for <CODE>ProcName</CODE> to always return NIL.


<P><PRE>TYPE Frame = RTMachine.FrameInfo;

&lt;*EXTERNAL &quot;RTException__CurFrame&quot; *&gt;
PROCEDURE CurrentFrame (VAR(*OUT*) f: Frame);
</PRE><BLOCKQUOTE><EM> Return in <CODE>f</CODE> the frame of its caller.  Returns with pc = NIL on failure. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL &quot;RTException__PrevFrame&quot; *&gt;
PROCEDURE PreviousFrame (READONLY callee: Frame;  VAR(*OUT*)caller: Frame);
</PRE><BLOCKQUOTE><EM> Return in <CODE>caller</CODE> the stack frame that called <CODE>callee</CODE>.
   Returns with pc = NIL if  <CODE>callee</CODE> is the first frame on
   the stack or its predecessor is ill-formed. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL &quot;RTException__Unwind&quot; *&gt;
PROCEDURE Unwind (READONLY f: Frame);
</PRE><BLOCKQUOTE><EM> Restore the machine state back to the frame <CODE>f</CODE>.  All callee-saved
   registers must be restored to the state they were in when frame <CODE>f</CODE>
   made its last call.  Note that if the unwind operation encounters a
   signal handler frame, it must also restore the caller-saved registers. </EM></BLOCKQUOTE><PRE>

&lt;*EXTERNAL &quot;RTException__ProcName&quot; *&gt;
PROCEDURE ProcName (READONLY f: Frame): ADDRESS;
</PRE><BLOCKQUOTE><EM> Return the null-terminated constant string that names the procedure
   corresponding to the stack frame <CODE>f</CODE>.  Returns NIL if no name is
   known. </EM></BLOCKQUOTE><PRE>
</PRE>----------------------------------------- compiler generated descriptors --

<P><PRE>TYPE
  ScopeKind = { Except, ExceptElse,
                Finally, FinallyProc,
                Raises, RaisesNone,
                Lock };

TYPE
  Scope = UNTRACED REF RECORD
    kind        : CHAR;    (* ScopeKind *)
    outermost   : CHAR;    (* BOOLEAN =&gt; last scope that covers [start..stop]*)
    end_of_list : CHAR;    (* BOOLEAN =&gt; last scope in module list *)
    pad         : CHAR;
    start       : ADDRESS; (* first PC of the handled scope *)
    stop        : ADDRESS; (* last PC of the handled scope *)
    excepts     : ADDRESS; (* NIL-terminated list of handled exceptions *)
    offset      : INTEGER; (* frame offset of ExceptionInfo *)
  END;

TYPE
  ExceptionInfo = RECORD
    exception : ADDRESS;
    arg       : ADDRESS;
  END;

END RTExRep.
</PRE>
</inInterface>
<HR>
<A NAME="x1">RTExRep's implementation  is in:
</A><UL>
<LI><A HREF="../ex_frame/RTException.m3#0TOP0">runtime/src/ex_frame/RTException.m3</A>
<LI><A HREF="RTException.m3#0TOP0">runtime/src/ex_stack/RTException.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface RTMachine is in:
</A><UL>
<LI><A HREF="../AIX386/RTMachine.i3#0TOP0">runtime/src/AIX386/RTMachine.i3</A>
<LI><A HREF="../ALPHA_OSF/RTMachine.i3#0TOP0">runtime/src/ALPHA_OSF/RTMachine.i3</A>
<LI><A HREF="../AP3000/RTMachine.i3#0TOP0">runtime/src/AP3000/RTMachine.i3</A>
<LI><A HREF="../ARM/RTMachine.i3#0TOP0">runtime/src/ARM/RTMachine.i3</A>
<LI><A HREF="../DS3100/RTMachine.i3#0TOP0">runtime/src/DS3100/RTMachine.i3</A>
<LI><A HREF="../FreeBSD/RTMachine.i3#0TOP0">runtime/src/FreeBSD/RTMachine.i3</A>
<LI><A HREF="../FreeBSD2/RTMachine.i3#0TOP0">runtime/src/FreeBSD2/RTMachine.i3</A>
<LI><A HREF="../HP300/RTMachine.i3#0TOP0">runtime/src/HP300/RTMachine.i3</A>
<LI><A HREF="../HPPA/RTMachine.i3#0TOP0">runtime/src/HPPA/RTMachine.i3</A>
<LI><A HREF="../IBMR2/RTMachine.i3#0TOP0">runtime/src/IBMR2/RTMachine.i3</A>
<LI><A HREF="../IBMRT/RTMachine.i3#0TOP0">runtime/src/IBMRT/RTMachine.i3</A>
<LI><A HREF="../IRIX5/RTMachine.i3#0TOP0">runtime/src/IRIX5/RTMachine.i3</A>
<LI><A HREF="../LINUX/RTMachine.i3#0TOP0">runtime/src/LINUX/RTMachine.i3</A>
<LI><A HREF="../LINUXELF/RTMachine.i3#0TOP0">runtime/src/LINUXELF/RTMachine.i3</A>
<LI><A HREF="../NEXT/RTMachine.i3#0TOP0">runtime/src/NEXT/RTMachine.i3</A>
<LI><A HREF="../NT386/RTMachine.i3#0TOP0">runtime/src/NT386/RTMachine.i3</A>
<LI><A HREF="../OKI/RTMachine.i3#0TOP0">runtime/src/OKI/RTMachine.i3</A>
<LI><A HREF="../SEQUENT/RTMachine.i3#0TOP0">runtime/src/SEQUENT/RTMachine.i3</A>
<LI><A HREF="../SOLgnu/RTMachine.i3#0TOP0">runtime/src/SOLgnu/RTMachine.i3</A>
<LI><A HREF="../SOLsun/RTMachine.i3#0TOP0">runtime/src/SOLsun/RTMachine.i3</A>
<LI><A HREF="../SPARC/RTMachine.i3#0TOP0">runtime/src/SPARC/RTMachine.i3</A>
<LI><A HREF="../SUN3/RTMachine.i3#0TOP0">runtime/src/SUN3/RTMachine.i3</A>
<LI><A HREF="../SUN386/RTMachine.i3#0TOP0">runtime/src/SUN386/RTMachine.i3</A>
<LI><A HREF="../UMAX/RTMachine.i3#0TOP0">runtime/src/UMAX/RTMachine.i3</A>
<LI><A HREF="../VAX/RTMachine.i3#0TOP0">runtime/src/VAX/RTMachine.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
