<HTML>
<HEAD>
<TITLE>SRC Modula-3: runtime/src/ex_stack/RTException.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>runtime/src/ex_stack/RTException.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module>RTException</module> EXPORTS <A HREF="../common/RTException.i3"><implements>RTException</A></implements>, <A HREF="#x1"><implements>RTExRep</A></implements>;

IMPORT <A HREF="../common/RT0.i3">RT0</A>, <A HREF="../common/RTMisc.i3">RTMisc</A>, <A HREF="../common/RTProcedureSRC.i3">RTProcedureSRC</A>, <A HREF="../common/RTIO.i3">RTIO</A>, <A HREF="../common/RTModule.i3">RTModule</A>, <A HREF="../common/RTOS.i3">RTOS</A>;
IMPORT <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="#x2">Cstring</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../common/RTProcedure.i3">RTProcedure</A>, <A HREF="../common/RTParams.i3">RTParams</A>;

VAR
  DEBUG := FALSE;
  dump_enabled := FALSE;

EXCEPTION
  OUCH; (* to keep the compiler from complaining *)

PROCEDURE <A NAME="Raise"><procedure>Raise</procedure></A> (en: ExceptionName;  arg: ExceptionArg) RAISES ANY =
  VAR
    here, f: Frame;
    s: Scope;
    ex: ExceptionList;
  BEGIN

    IF DEBUG THEN
      RTIO.PutText (&quot;---&gt; RAISE:&quot;);
      RTIO.PutText (&quot;  en=&quot;);   RTIO.PutAddr (en);
      RTIO.PutText (&quot; &quot;);       RTIO.PutString (en^);
      RTIO.PutText (&quot;  arg=&quot;);  RTIO.PutAddr (arg);
      RTIO.PutText (&quot;\n&quot;);
      DumpStack ();
    END;

    CurrentFrame (here);
    PreviousFrame (here, f); (* skip self *)
    LOOP
      IF (f.pc = NIL) THEN
        (* we're at the end of the stack (or we got lost along the way!) *)
        NoHandler (en, raises := FALSE);
      END;

      s := FindScope (f.pc);
      IF (s # NIL) THEN
        LOOP
          IF (s.start &lt;= f.pc) AND (f.pc &lt;= s.stop) THEN
            CASE ORD (s.kind) OF
            | ORD (ScopeKind.Except) =&gt;
                ex := s.excepts;
                WHILE (ex^ # NIL) DO
                  IF (ex^ = en) THEN ResumeRaise (en, arg) END;
                  INC (ex, ADRSIZE (ex^));
                END;
            | ORD (ScopeKind.ExceptElse) =&gt;
                (* 's' is a TRY-EXCEPT-ELSE frame =&gt; go for it *)
                ResumeRaise (en, arg);
            | ORD (ScopeKind.Finally),
              ORD (ScopeKind.FinallyProc),
              ORD (ScopeKind.Lock) =&gt;
                (* ignore for this pass *)
            | ORD (ScopeKind.RaisesNone) =&gt;
                NoHandler (en);
            | ORD (ScopeKind.Raises) =&gt;
                (* check that this procedure does indeed raise 'en' *)
                ex := s.excepts;
                IF ex = NIL THEN NoHandler (en); END;
                LOOP
                  IF (ex^ = NIL) THEN  NoHandler (en) END;
                  IF (ex^ = en)  THEN  (* ok, it passes *) EXIT  END;
                  INC (ex, ADRSIZE (ex^));
                END;
            ELSE &lt;*ASSERT FALSE*&gt;
            END;

            IF (s.outermost # '\000') THEN EXIT END;
          END;

          IF (s.end_of_list # '\000') THEN EXIT END;

          (* try the next scope in the list *)
          INC (s, ADRSIZE (s^));
        END;
      END;

      (* try the previous frame *)
      PreviousFrame (f, f);
    END;
  END Raise;

PROCEDURE <A NAME="ResumeRaise"><procedure>ResumeRaise</procedure></A> (en: ExceptionName;  arg: ExceptionArg) RAISES ANY =
  VAR
    here, f: Frame;
    s: Scope;
    ex: ExceptionList;
  BEGIN

    IF DEBUG THEN
      RTIO.PutText (&quot;---&gt; RERAISE:&quot;);
      RTIO.PutText (&quot;  en=&quot;);   RTIO.PutAddr (en);
      RTIO.PutText (&quot; &quot;);       RTIO.PutString (en^);
      RTIO.PutText (&quot;  arg=&quot;);  RTIO.PutAddr (arg);
      RTIO.PutText (&quot;\n&quot;);
      DumpStack ();
    END;

    CurrentFrame (here);
    PreviousFrame (here, f); (* skip self *)
    LOOP
      IF (f.pc = NIL) THEN
        (* we're at the end of the stack (or we got lost along the way!) *)
        NoHandler (en, raises := FALSE);
      END;

      s := FindScope (f.pc);
      IF (s # NIL) THEN
        LOOP
          IF (s.start &lt;= f.pc) AND (f.pc &lt;= s.stop) THEN
            CASE ORD (s.kind) OF
            | ORD (ScopeKind.Except) =&gt;
                ex := s.excepts;
                WHILE (ex^ # NIL) DO
                  IF (ex^ = en) THEN InvokeHandler (s, f, en, arg) END;
                  INC (ex, ADRSIZE (ex^));
                END;
                MarkHandler (s, f, en, arg);
                (* we need to mark every frame so that no matter where
                   we unwind to, it sees a marked frame =&gt; exception *)
            | ORD (ScopeKind.ExceptElse) =&gt;
                (* 's' is a TRY-EXCEPT-ELSE frame =&gt; go for it *)
                InvokeHandler (s, f, en, arg);
            | ORD (ScopeKind.Finally),
              ORD (ScopeKind.FinallyProc) =&gt;
                InvokeHandler (s, f, en, arg);
            | ORD (ScopeKind.Lock) =&gt;
                ReleaseLock (s, f);
            | ORD (ScopeKind.Raises) =&gt;
                (* already checked during the first pass *)
            ELSE &lt;*ASSERT FALSE *&gt;
            END;

            IF (s.outermost # '\000') THEN EXIT END;
          END;

          IF (s.end_of_list # '\000') THEN EXIT END;

          (* try the next scope in the list *)
          INC (s, ADRSIZE (s^));
        END;
      END;

      (* try the previous frame *)
      PreviousFrame (f, f);
    END;
  END ResumeRaise;

PROCEDURE <A NAME="InvokeHandler"><procedure>InvokeHandler</procedure></A> (s: Scope;  READONLY f: Frame;
                         en: ExceptionName;  arg: ExceptionArg) RAISES ANY =
  VAR p : UNTRACED REF ExceptionInfo := f.sp + s.offset;
  BEGIN
    IF DEBUG THEN
      RTIO.PutText (&quot;--&gt; INVOKE HANDLER:&quot;);
      RTIO.PutText (&quot;  en=&quot;);    RTIO.PutAddr (en);
      RTIO.PutText (&quot; &quot;);        RTIO.PutString (en^);
      RTIO.PutText (&quot;  arg=&quot;);   RTIO.PutAddr (arg);
      RTIO.PutText (&quot;  pc=&quot;);    RTIO.PutAddr (f.pc);
      RTIO.PutText (&quot;  sp=&quot;);    RTIO.PutAddr (f.sp);
      RTIO.PutText (&quot;  info=&quot;);  RTIO.PutAddr (p);
      RTIO.PutText (&quot;\n&quot;);
      RTIO.Flush ();
    END;
    p.exception := en;
    p.arg := arg;
    Unwind (f);
    RTMisc.FatalErrorPC (LOOPHOLE (f.pc, INTEGER), &quot;Unwind returned!&quot;);
    RAISE OUCH;
  END InvokeHandler;

PROCEDURE <A NAME="MarkHandler"><procedure>MarkHandler</procedure></A> (s: Scope;  READONLY f: Frame;
                         en: ExceptionName;  arg: ExceptionArg) =
  VAR p : UNTRACED REF ExceptionInfo := f.sp + s.offset;
  BEGIN
    IF DEBUG THEN
      RTIO.PutText (&quot;--&gt; MARK HANDLER:&quot;);
      RTIO.PutText (&quot;  en=&quot;);    RTIO.PutAddr (en);
      RTIO.PutText (&quot; &quot;);        RTIO.PutString (en^);
      RTIO.PutText (&quot;  arg=&quot;);   RTIO.PutAddr (arg);
      RTIO.PutText (&quot;  pc=&quot;);    RTIO.PutAddr (f.pc);
      RTIO.PutText (&quot;  sp=&quot;);    RTIO.PutAddr (f.sp);
      RTIO.PutText (&quot;  info=&quot;);  RTIO.PutAddr (p);
      RTIO.PutText (&quot;\n&quot;);
      RTIO.Flush ();
    END;
    p.exception := en;
    p.arg := arg;
  END MarkHandler;

PROCEDURE <A NAME="ReleaseLock"><procedure>ReleaseLock</procedure></A> (s: Scope;  READONLY f: Frame) =
  VAR p : UNTRACED REF MUTEX := f.sp + s.offset;
  BEGIN
    IF DEBUG THEN
      RTIO.PutText (&quot;--&gt; UNLOCK:&quot;);
      RTIO.PutText (&quot;  pc=&quot;);     RTIO.PutAddr (f.pc);
      RTIO.PutText (&quot;  sp=&quot;);     RTIO.PutAddr (f.sp);
      RTIO.PutText (&quot;  info=&quot;);   RTIO.PutAddr (p);
      RTIO.PutText (&quot;  mutex=&quot;);  RTIO.PutAddr (LOOPHOLE (p^, ADDRESS));
      RTIO.PutText (&quot;\n&quot;);
      RTIO.Flush ();
    END;
    &lt;*ASSERT p^ # NIL *&gt;
    Thread.Release (p^);
  END ReleaseLock;

PROCEDURE <A NAME="NoHandler"><procedure>NoHandler</procedure></A> (en: ExceptionName;  raises := TRUE) =
  VAR nm := EName (en);
  BEGIN
    IF (raises) THEN
      RTMisc.FatalError (NIL, 0, &quot;Exception \&quot;&quot;, nm, &quot;\&quot; not in RAISES list&quot;);
    ELSE
      RTMisc.FatalError (NIL, 0, &quot;Unhandled exception \&quot;&quot;, nm, &quot;\&quot;&quot;);
    END;
  END NoHandler;
</PRE>------------------------------------------------------- scope searching ---
 Note: we assume that the text of a single compilation unit is contiguous
   (i.e. the linker doesn't split and shuffle compilation units in little
    pieces). 

<P><PRE>TYPE
  PCMap = UNTRACED REF ARRAY OF MapEntry;
  MapEntry = RECORD
    base   : ADDRESS;
    module : RT0.ModulePtr;
  END;

VAR pc_map: PCMap := NIL;

PROCEDURE <A NAME="FindScope"><procedure>FindScope</procedure></A> (pc: ADDRESS): Scope =
  VAR
    base: ADDRESS;
    lo, hi, mid, limit: CARDINAL;
    p: UNTRACED REF MapEntry;
    s: Scope;
  BEGIN
    IF (pc_map = NIL) THEN
      RTOS.LockHeap ();
        BuildPCMap ();
      RTOS.UnlockHeap ();
    END;

    (* binary search of the sorted table *)
    limit:= NUMBER (pc_map^);
    base := ADR (pc_map[0]);
    lo   := 0;
    hi   := limit;
    WHILE (lo &lt; hi) DO
      mid := (lo + hi) DIV 2;
      p := base + mid * ADRSIZE (p^);
      IF (pc &lt; p.base)
        THEN hi := mid;
        ELSE lo := mid + 1;
      END;
    END;
    IF (lo &gt; 0) THEN DEC (lo) END;

    (* linear search of the modules that might contain pc *)
    LOOP
      IF (lo &gt;= limit) THEN RETURN NIL END;
      p := base + lo * ADRSIZE (p^);
      IF (p.base &gt; pc) THEN RETURN NIL END;
      IF FindScopeInModule (pc, p.module.try_scopes, s) THEN RETURN s END;
      INC (lo);
    END;
  END FindScope;

PROCEDURE <A NAME="FindScopeInModule"><procedure>FindScopeInModule</procedure></A> (pc: ADDRESS;  s: Scope;  VAR x: Scope): BOOLEAN =
  VAR above, below: BOOLEAN := FALSE;
  BEGIN
    x := NIL;
    IF (s = NIL) THEN RETURN FALSE END;
    LOOP
      IF (s.start &lt;= pc) AND (pc &lt;= s.stop) THEN  x := s; RETURN TRUE;  END;
      IF (s.start &lt;= pc) THEN below := TRUE END;
      IF (s.stop &gt;= pc) THEN above := TRUE END;
      IF (s.end_of_list # '\000') THEN RETURN (above AND below) END;
      INC (s, ADRSIZE (s^));
    END;
  END FindScopeInModule;
</PRE>----------------------------------------------------- sorted module map ---

<P><PRE>PROCEDURE <A NAME="BuildPCMap"><procedure>BuildPCMap</procedure></A> () =
  VAR n: INTEGER;  map: PCMap;  m: RT0.ModulePtr;
  BEGIN
    (* first, count the modules with exception scopes *)
    n := 0;
    FOR i := 0 TO RTModule.Count () - 1 DO
      m := RTModule.Get (i);
      IF (m # NIL) AND (m.try_scopes # NIL) THEN INC (n); END;
    END;

    (* allocate space for the map *)
    map := NEW (PCMap, n);

    (* install the modules with exception scopes into the map *)
    n := 0;
    FOR i := 0 TO RTModule.Count () - 1  DO
      m := RTModule.Get (i);
      IF (m # NIL) AND (m.try_scopes # NIL) THEN
        map[n].base := MinPC (m);
        map[n].module := m;
        INC (n);
      END;
    END;

    (* sort the maps *)
    QuickSort (map^, 0, n);
    InsertionSort (map^, 0, n);

    (* and finally, install them *)
    pc_map := map;
  END BuildPCMap;

PROCEDURE <A NAME="MinPC"><procedure>MinPC</procedure></A> (m: RT0.ModulePtr): ADDRESS =
  VAR
    s   := LOOPHOLE (m.try_scopes, Scope);
    min := s.start;
  BEGIN
    LOOP
      IF (s.start &lt; min) THEN min := s.start; END;
      IF (s.end_of_list # '\000') THEN EXIT; END;
      INC (s, ADRSIZE (s^));
    END;
    RETURN min;
  END MinPC;

PROCEDURE <A NAME="QuickSort"><procedure>QuickSort</procedure></A> (VAR a: ARRAY OF MapEntry;  lo, hi: INTEGER) =
  CONST CutOff = 9;
  VAR i, j: INTEGER;  key, tmp, t_lo, t_hi, t_i: MapEntry;
  BEGIN
    WHILE (hi - lo &gt; CutOff) DO (* sort a[lo..hi) *)

      (* use median-of-3 to select a key *)
      i := (hi + lo) DIV 2;
      t_lo := a [lo];
      t_hi := a [hi-1];
      t_i  := a [i];
      IF (t_lo.base &lt; t_i.base) THEN
        IF (t_i.base &lt; t_hi.base) THEN
          key := t_i;
        ELSIF (t_lo.base &lt; t_hi.base) THEN
          key := t_hi;
          a[hi-1] := t_i;
          a[i] := key;
        ELSE
          key := t_lo;
          a[lo] := t_hi;
          a[hi-1] := t_i;
          a[i] := key;
        END;
      ELSE
        IF (t_hi.base &lt; t_i.base) THEN
          key := t_i;
          a[hi-1] := t_lo;
          a[lo] := t_hi;
        ELSIF (t_lo.base &lt; t_hi.base) THEN
          key := t_lo;
          a[lo] := t_i;
          a[i] := t_lo;
        ELSE
          key := t_hi;
          a[hi-1] := t_lo;
          a[lo] := t_i;
          a[i] := t_hi;
        END;
      END;

      (* partition the array *)

      i := lo+1;  j := hi-2;

      (* find the first hole *)
      WHILE (a [j].base &gt; key.base) DO DEC (j) END;
      tmp := a [j];
      DEC (j);

      LOOP
        IF (i &gt; j) THEN EXIT END;

        WHILE (a [i].base &lt; key.base) DO INC (i) END;
        IF (i &gt; j) THEN EXIT END;
        a[j+1] := a [i];
        INC (i);

        WHILE (a [j].base &gt; key.base) DO DEC (j) END;
        IF (i &gt; j) THEN  IF (j = i-1) THEN  DEC (j)  END;  EXIT  END;
        a[i-1] := a [j];
        DEC (j);
      END;

      (* fill in the last hole *)
      a[j+1] := tmp;
      i := j+2;

      (* then, recursively sort the smaller subfile *)
      IF (i - lo &lt; hi - i)
        THEN  QuickSort (a, lo, i-1);   lo := i;
        ELSE  QuickSort (a, i, hi);     hi := i-1;
      END;

    END; (* WHILE (hi-lo &gt; CutOff) *)
  END QuickSort;

PROCEDURE <A NAME="InsertionSort"><procedure>InsertionSort</procedure></A> (VAR a: ARRAY OF MapEntry;  lo, hi: INTEGER) =
  VAR j: INTEGER;  key: MapEntry;
  BEGIN
    FOR i := lo+1 TO hi-1 DO
      key := a [i];
      j := i-1;
      WHILE (j &gt;= lo) AND (key.base &lt; a [j].base) DO
        a[j+1] := a [j];
        DEC (j);
      END;
      a[j+1] := key;
    END;
  END InsertionSort;
</PRE>----------------------------------------------------------- diagnostics ---

<P><PRE>VAR NoName := ARRAY [0..15] OF CHAR {'s','t','a','t','i','c',' ',
                                     'p','r','o','c','e','d','u','r','e'};
PROCEDURE <A NAME="DumpStack"><procedure>DumpStack</procedure></A> () =
  CONST CallInstructionSize = 4;
  VAR
    here, f: Frame;
    s: Scope;
    ex: ExceptionList;
    name: RTProcedureSRC.Name;
    file: RTProcedureSRC.Name;
    proc: RTProcedure.Proc;
    offset: INTEGER;
    info: ADDRESS;
  BEGIN
    IF NOT DEBUG AND NOT dump_enabled THEN RETURN; END;

    RTOS.LockHeap (); (* disable thread switching... (you wish!) *)

    RTIO.PutText (&quot;------------------------- STACK DUMP ---------------------------\n&quot;);
    RTIO.PutText (&quot;----PC----  ----SP----  \n&quot;);
    CurrentFrame (here);
    PreviousFrame (here, f); (* skip self *)

    WHILE (f.pc # NIL) DO

      (* print the active scopes *)
      s := FindScope (f.pc);
      IF (s # NIL) THEN
        LOOP
          IF (s.start &lt;= f.pc) AND (f.pc &lt;= s.stop) THEN
            RTIO.PutText (&quot;   [&quot;);
            RTIO.PutAddr (s.start);
            RTIO.PutText (&quot;..&quot;);
            RTIO.PutAddr (s.stop);
            RTIO.PutText (&quot;]  &quot;);
            info := f.sp + s.offset;
            CASE ORD (s.kind) OF
            | ORD (ScopeKind.Finally),
              ORD (ScopeKind.FinallyProc) =&gt;
                RTIO.PutText (&quot;TRY-FINALLY&quot;);
                DumpInfo (info);
            | ORD (ScopeKind.Lock) =&gt;
                RTIO.PutText (&quot;LOCK&quot;);
                DumpInfo (info);
                RTIO.PutText (&quot;  mutex = &quot;);
                RTIO.PutAddr (LOOPHOLE (info, UNTRACED REF ADDRESS)^);
            | ORD (ScopeKind.Except) =&gt;
                ex := s.excepts;
                RTIO.PutText (&quot;TRY-EXCEPT&quot;);  DumpHandles (ex);
                DumpInfo (info);
            | ORD (ScopeKind.ExceptElse) =&gt;
                RTIO.PutText (&quot;TRY-EXCEPT-ELSE&quot;);
                DumpInfo (info);
            | ORD (ScopeKind.Raises),
              ORD (ScopeKind.RaisesNone) =&gt;
                RTIO.PutText (&quot;RAISES&quot;);
                DumpHandles (s.excepts);
            ELSE
                (* we found a mysterious scope!? *)
                RTIO.PutText (&quot;??? BAD EXCEPTION SCOPE, kind = &quot;);
                RTIO.PutInt (ORD (s.kind));
                RTIO.PutText (&quot; ???\n&quot;);
                EXIT;
            END;
            RTIO.PutText (&quot;\n&quot;);

            IF (s.outermost # '\000') THEN EXIT END;
          END;

          IF (s.end_of_list # '\000') THEN EXIT END;

          (* try the next scope in the list *)
          INC (s, ADRSIZE (s^));
        END;
      END;

      (* print the procedure's frame *)
      RTIO.PutAddr (f.pc-CallInstructionSize, 10);
      RTIO.PutText (&quot;  &quot;);
      RTIO.PutAddr (f.sp, 10);
      RTProcedureSRC.FromPC (f.pc, proc, file, name);
      IF (name # NIL) THEN
        offset := f.pc - proc;
        IF (0 &lt;= offset) AND (offset &lt; 2048) THEN
          RTIO.PutText (&quot;  &quot;);  RTIO.PutString (name);
          IF (offset # 0) THEN RTIO.PutText (&quot; + &quot;); RTIO.PutHex (offset); END;
          IF (file # NIL) THEN RTIO.PutText(&quot; in &quot;); RTIO.PutString(file); END;
        END;
      END;
      name := ProcName (f);
      IF (name # NIL)
        AND Cstring.memcmp (name, ADR(NoName), NUMBER(NoName)) # 0 THEN
        RTIO.PutText (&quot;  [&quot;);  RTIO.PutString (name);  RTIO.PutText (&quot;]&quot;);
      END;
      RTIO.PutText (&quot;\n&quot;);

      (* try the previous frame *)
      PreviousFrame (f, f);
    END;
    RTIO.PutText (&quot;----------------------------------------------------------------\n&quot;);
    RTIO.Flush ();

    RTOS.UnlockHeap (); (* re-enable thread switching *)
  END DumpStack;

PROCEDURE <A NAME="DumpHandles"><procedure>DumpHandles</procedure></A> (x: ExceptionList) =
  VAR first := TRUE;  en: ExceptionName;
  BEGIN
    RTIO.PutText (&quot; {&quot;);
    IF (x # NIL) THEN
      WHILE (x^ # NIL) DO
        IF (NOT first) THEN RTIO.PutText (&quot;, &quot;);  END;
        first := FALSE;
        en := x^;
        RTIO.PutString (en^);
        INC (x, ADRSIZE (x^));
      END;
    END;
    RTIO.PutText (&quot;}&quot;);
  END DumpHandles;

PROCEDURE <A NAME="DumpInfo"><procedure>DumpInfo</procedure></A> (a: ADDRESS) =
  BEGIN
    IF DEBUG THEN
      RTIO.PutText (&quot;  info=&quot;);
      RTIO.PutAddr (a);
    END;
  END DumpInfo;

PROCEDURE <A NAME="EName"><procedure>EName</procedure></A> (en: ExceptionName): TEXT =
  BEGIN
    RETURN M3toC.StoT (LOOPHOLE (en^, Ctypes.char_star));
  END EName;

BEGIN
  dump_enabled := RTParams.IsPresent (&quot;stackdump&quot;);
END RTException.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface RTExRep is in:
</A><UL>
<LI><A HREF="../ex_frame/RTExRep.i3#0TOP0">runtime/src/ex_frame/RTExRep.i3</A>
<LI><A HREF="RTExRep.i3#0TOP0">runtime/src/ex_stack/RTExRep.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Cstring is in:
</A><UL>
<LI><A HREF="../../../C/src/AIX386/Cstring.i3#0TOP0">C/src/AIX386/Cstring.i3</A>
<LI><A HREF="../../../C/src/ALPHA_OSF/Cstring.i3#0TOP0">C/src/ALPHA_OSF/Cstring.i3</A>
<LI><A HREF="../../../C/src/AP3000/Cstring.i3#0TOP0">C/src/AP3000/Cstring.i3</A>
<LI><A HREF="../../../C/src/ARM/Cstring.i3#0TOP0">C/src/ARM/Cstring.i3</A>
<LI><A HREF="../../../C/src/DS3100/Cstring.i3#0TOP0">C/src/DS3100/Cstring.i3</A>
<LI><A HREF="../../../C/src/FreeBSD/Cstring.i3#0TOP0">C/src/FreeBSD/Cstring.i3</A>
<LI><A HREF="../../../C/src/FreeBSD2/Cstring.i3#0TOP0">C/src/FreeBSD2/Cstring.i3</A>
<LI><A HREF="../../../C/src/HP300/Cstring.i3#0TOP0">C/src/HP300/Cstring.i3</A>
<LI><A HREF="../../../C/src/HPPA/Cstring.i3#0TOP0">C/src/HPPA/Cstring.i3</A>
<LI><A HREF="../../../C/src/IBMR2/Cstring.i3#0TOP0">C/src/IBMR2/Cstring.i3</A>
<LI><A HREF="../../../C/src/IBMRT/Cstring.i3#0TOP0">C/src/IBMRT/Cstring.i3</A>
<LI><A HREF="../../../C/src/IRIX5/Cstring.i3#0TOP0">C/src/IRIX5/Cstring.i3</A>
<LI><A HREF="../../../C/src/LINUX/Cstring.i3#0TOP0">C/src/LINUX/Cstring.i3</A>
<LI><A HREF="../../../C/src/LINUXELF/Cstring.i3#0TOP0">C/src/LINUXELF/Cstring.i3</A>
<LI><A HREF="../../../C/src/NEXT/Cstring.i3#0TOP0">C/src/NEXT/Cstring.i3</A>
<LI><A HREF="../../../C/src/NT386/Cstring.i3#0TOP0">C/src/NT386/Cstring.i3</A>
<LI><A HREF="../../../C/src/OKI/Cstring.i3#0TOP0">C/src/OKI/Cstring.i3</A>
<LI><A HREF="../../../C/src/SEQUENT/Cstring.i3#0TOP0">C/src/SEQUENT/Cstring.i3</A>
<LI><A HREF="../../../C/src/SOLgnu/Cstring.i3#0TOP0">C/src/SOLgnu/Cstring.i3</A>
<LI><A HREF="../../../C/src/SOLsun/Cstring.i3#0TOP0">C/src/SOLsun/Cstring.i3</A>
<LI><A HREF="../../../C/src/SPARC/Cstring.i3#0TOP0">C/src/SPARC/Cstring.i3</A>
<LI><A HREF="../../../C/src/SUN3/Cstring.i3#0TOP0">C/src/SUN3/Cstring.i3</A>
<LI><A HREF="../../../C/src/SUN386/Cstring.i3#0TOP0">C/src/SUN386/Cstring.i3</A>
<LI><A HREF="../../../C/src/UMAX/Cstring.i3#0TOP0">C/src/UMAX/Cstring.i3</A>
<LI><A HREF="../../../C/src/VAX/Cstring.i3#0TOP0">C/src/VAX/Cstring.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
