<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/FileRd.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/FileRd.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> A <CODE>FileRd.T</CODE>, or file reader, is a reader on a <CODE>File.T</CODE>.
   \index{buffered file I/O}
   \index{file!buffered I/O}


<P><PRE>INTERFACE <interface><A HREF="FileRd.m3">FileRd</A></interface>;

IMPORT <A HREF="Rd.i3">Rd</A>, <A HREF="../../../os/src/Common/File.i3">File</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../os/src/Common/Pathname.i3">Pathname</A>;

TYPE
  <A HREF="FileRd.m3#T">T</A> &lt;: Public;
  Public = Rd.T OBJECT METHODS
    init(h: File.T): T RAISES {OSError.E}
  END;
</PRE><BLOCKQUOTE><EM> If <CODE>r</CODE> is a file reader and <CODE>h</CODE> is a file handle, the call
   <CODE>r.init(h)</CODE> initializes <CODE>r</CODE> so that reading <CODE>r</CODE> reads characters
   from <CODE>h</CODE>, and so that closing <CODE>r</CODE> closes <CODE>h</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>h</CODE> is a regular file handle, <CODE>r.init(h)</CODE> causes <CODE>r</CODE> to be a
   nonintermittent, seekable reader and initializes <CODE>cur(r)</CODE> to
   <CODE>cur(h)</CODE>.
<P>
   For any other file handle <CODE>h</CODE>, <CODE>r.init(h)</CODE> causes <CODE>r</CODE> to be an
   intermittent, nonseekable reader and initializes <CODE>cur(r)</CODE> to zero. 
<P>
   If a subsequent reader operation on <CODE>r</CODE> raises <CODE>Rd.Failure</CODE>, the
   associated exception argument is the <CODE>AtomList.T</CODE> argument
   accompanying an <CODE>OSError.E</CODE> exception from a file operation on <CODE>h</CODE>.
   

<P><PRE>PROCEDURE <A HREF="FileRd.m3#Open">Open</A>(p: Pathname.T): T RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Return a file reader whose source is the file named <CODE>p</CODE>.  If the file
   does not exist, <CODE>OSError.E</CODE> is raised with an implementation-defined
   code. </EM></BLOCKQUOTE><PRE>
</PRE> The call <CODE>Open(p)</CODE> is equivalent to
<P>
<PRE>
      RETURN NEW(T).init(FS.OpenFileReadonly(p))
</PRE>


<P><PRE>END FileRd.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
