<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/FileRd.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/FileRd.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="FileRd.i3">FileRd</A></implements></module>;

IMPORT <A HREF="../../../os/src/Common/File.i3">File</A>, <A HREF="../../../os/src/Common/FS.i3">FS</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="Rd.i3">Rd</A>, <A HREF="RdClass.i3">RdClass</A>, <A HREF="../../../os/src/Common/RegularFile.i3">RegularFile</A>;

PROCEDURE <A NAME="Open"><procedure>Open</procedure></A>(p: Pathname.T): T RAISES {OSError.E} =
  BEGIN
    RETURN NEW(T).init(FS.OpenFileReadonly(p))
  END Open;

TYPE CharBuffer = REF ARRAY OF CHAR;

CONST BufferSize = 4096;

CONST BIG = 16_1000000; (* 2^24 =&gt; 16M *)

TYPE ByteArrayPtr = UNTRACED REF ARRAY [0..BIG-1] OF File.Byte;

REVEAL <A NAME="T">T</A> = Public BRANDED &quot;FileRd.T&quot; OBJECT
    sourceH: File.T;
  OVERRIDES
    init := Init;
    seek := Seek;
    length := Length;
    close := Close;
    getSub := GetSub;
  END;
</PRE><BLOCKQUOTE><EM> Q1: If <CODE>rd.sourceH</CODE> is a <CODE>RegularFile.T</CODE> then the current position
       of <CODE>rd.sourceH</CODE> is equal to <CODE>rd.hi</CODE>. 
<P>
   Q2: If <CODE>rd.seekable</CODE>, then <CODE>rd.sourceH</CODE> is a <CODE>RegularFile.T</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(rd: T; h: File.T): T RAISES {OSError.E} =
  BEGIN
    rd.sourceH := h;
    IF (rd.buff = NIL) THEN
      rd.buff := NEW(CharBuffer, BufferSize);
    (*ELSE reuse the existing buffer*)
    END;
    rd.st := 0;
    rd.closed := FALSE;
    TYPECASE h OF
    | RegularFile.T(hRF) =&gt;
      rd.seekable := TRUE;
      rd.intermittent := FALSE;
      rd.cur := hRF.seek(RegularFile.Origin.Current, 0);
    ELSE
      rd.seekable := FALSE;
      rd.intermittent := TRUE;
      rd.cur := 0
    END;
    rd.lo := rd.cur;
    rd.hi := rd.cur;
    RETURN rd
  END Init;

EXCEPTION Error; &lt;*FATAL Error*&gt;

PROCEDURE <A NAME="Seek"><procedure>Seek</procedure></A> (rd: T; pos: CARDINAL; dontBlock: BOOLEAN): RdClass.SeekResult
  RAISES {Rd.Failure} =
  VAR n: INTEGER; BEGIN
    TRY
      IF pos # rd.hi THEN
        IF NOT rd.seekable THEN RAISE Error; END;
        IF pos &gt; rd.cur THEN pos := MIN(pos, rd.sourceH.status().size) END;
        EVAL NARROW(rd.sourceH, RegularFile.T).seek(
                            RegularFile.Origin.Beginning, pos);
        rd.cur := pos;
        rd.hi := pos
      ELSE
        rd.cur := pos;
      END;
      rd.lo := pos;
      (* Maintains Q1 if sourceH.read raises OS.Error or returns -1. *)
      n := rd.sourceH.read(
             SUBARRAY(LOOPHOLE(ADR(rd.buff[0]), ByteArrayPtr)^, 0,
                      MIN (NUMBER(rd.buff^), BIG)), mayBlock := NOT dontBlock)
    EXCEPT
    | OSError.E (code) =&gt; RAISE Rd.Failure(code)
    END;
    IF n &lt; 0 THEN RETURN RdClass.SeekResult.WouldBlock END;
    IF n = 0 THEN RETURN RdClass.SeekResult.Eof END;
    INC(rd.hi, n);
    RETURN RdClass.SeekResult.Ready
  END Seek;

PROCEDURE <A NAME="GetSub"><procedure>GetSub</procedure></A> (rd: T; VAR a: ARRAY OF CHAR): CARDINAL
  RAISES {Rd.Failure} =
  VAR toRead := NUMBER(a);
  BEGIN
    TRY
      WHILE toRead # 0 DO
        IF rd.cur # rd.hi THEN
          VAR n := MIN(toRead, rd.hi-rd.cur); BEGIN
            SUBARRAY(a, NUMBER(a) - toRead, n) :=
              SUBARRAY(rd.buff^, rd.cur-rd.lo, n);
            INC(rd.cur, n);
            DEC(toRead, n)
          END
        ELSE
          rd.lo := rd.cur;
          (* Maintains Q1 if sourceH.read raises OS.Error or returns -1. *)
          VAR n: INTEGER; BEGIN
            IF 2 * toRead &lt; NUMBER(rd.buff^) THEN
              n := rd.sourceH.read(
                    SUBARRAY(LOOPHOLE(ADR(rd.buff[0]), ByteArrayPtr)^,
                              0, MIN (NUMBER(rd.buff^), BIG)));
              INC(rd.hi, n)
            ELSE
              n := rd.sourceH.read(
                    SUBARRAY(LOOPHOLE(ADR(a[NUMBER(a)-toRead]), ByteArrayPtr)^,
                              0, MIN (toRead, BIG)));
              DEC(toRead, n);
              INC(rd.cur, n);
              rd.lo := rd.cur;
              rd.hi := rd.cur
            END;
            IF n = 0 THEN EXIT; END
          END
        END
      END
    EXCEPT
      OSError.E (code) =&gt; RAISE Rd.Failure(code)
    END;
    RETURN NUMBER(a) - toRead;
  END GetSub;

PROCEDURE <A NAME="Length"><procedure>Length</procedure></A>(rd: T): INTEGER RAISES {Rd.Failure} =
  BEGIN
    TRY
      IF rd.seekable THEN
        RETURN rd.sourceH.status().size;
      ELSE
        RETURN -1;
      END
    EXCEPT
    | OSError.E(code) =&gt;  RAISE Rd.Failure(code)
    END
  END Length;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A>(rd: T) RAISES {Rd.Failure} =
  BEGIN
    TRY
      rd.sourceH.close()
    EXCEPT OSError.E(code) =&gt; RAISE Rd.Failure(code)
    END
  END Close;

BEGIN
END FileRd.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
