<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/FileWr.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/FileWr.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> A <CODE>FileWr.T</CODE>, or file writer, is a writer on a <CODE>File.T</CODE>.
   \index{buffered file I/O}
   \index{file!buffered I/O}

     
<P><PRE>INTERFACE <interface><A HREF="FileWr.m3">FileWr</A></interface>;

IMPORT <A HREF="Wr.i3">Wr</A>, <A HREF="../../../os/src/Common/File.i3">File</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../os/src/Common/Pathname.i3">Pathname</A>;

TYPE
  <A HREF="FileWr.m3#T">T</A> &lt;: Public;
  Public = Wr.T OBJECT METHODS
    init(h: File.T; buffered: BOOLEAN := TRUE): T
      RAISES {OSError.E}
  END;
</PRE><BLOCKQUOTE><EM> If <CODE>w</CODE> is a file writer and <CODE>h</CODE> is a file handle, the call
   <CODE>w.init(h)</CODE> initializes <CODE>w</CODE> so that characters output to <CODE>w</CODE> are
   written to <CODE>h</CODE> and so that closing <CODE>w</CODE> closes <CODE>h</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>h</CODE> is a regular file handle and <CODE>b</CODE> is a Boolean, <CODE>w.init(h, b)</CODE>
   causes <CODE>w</CODE> to be a buffered seekable writer and initializes <CODE>cur(w)</CODE>
   to <CODE>cur(h)</CODE>.
<P>
   For any other file handle <CODE>h</CODE>, <CODE>w.init(h, b)</CODE> causes <CODE>w</CODE> to be
   a nonseekable writer, buffered if and only if <CODE>b</CODE> is <CODE>TRUE</CODE>, and
   initializes <CODE>cur(w)</CODE> to zero.
<P>
   If a subsequent writer operation on <CODE>w</CODE> raises <CODE>Wr.Failure</CODE>, the
   associated exception argument is the <CODE>AtomList.T</CODE> argument
   accompanying an <CODE>OSError.E</CODE> exception from a file operation on <CODE>h</CODE>.
   

<P><PRE>PROCEDURE <A HREF="FileWr.m3#Open">Open</A>(p: Pathname.T): T RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Return a file writer whose target is the file named <CODE>p</CODE>.  If the
   file does not exist, it is created.  If the file exists, it is
   truncated to a size of zero. </EM></BLOCKQUOTE><PRE>
</PRE> The call <CODE>Open(p)</CODE> is equivalent to the following:
<P>
<PRE>
      RETURN NEW(T).init(FS.OpenFile(p))
</PRE>


<P><PRE>PROCEDURE <A HREF="FileWr.m3#OpenAppend">OpenAppend</A>(p: Pathname.T): T RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Return a file writer whose target is the file named <CODE>p</CODE>.  If the
   file does not exist, it is created.  If the file exists, the writer is
   positioned to append to the existing contents of the file. </EM></BLOCKQUOTE><PRE>
</PRE> The call <CODE>OpenAppend(p)</CODE> is equivalent to the following:
<P>
<PRE>
      WITH h = FS.OpenFile(p, truncate := FALSE) DO
        EVAL h.seek(RegularFile.Origin.End, 0);
        RETURN NEW(T).init(h)
      END
</PRE>


<P><PRE>END FileWr.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
