<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/FileWr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/FileWr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="FileWr.i3">FileWr</A></implements></module>;

IMPORT <A HREF="../../../os/src/Common/File.i3">File</A>, <A HREF="../../../os/src/Common/FS.i3">FS</A>, <A HREF="../../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../os/src/Common/RegularFile.i3">RegularFile</A>, <A HREF="Wr.i3">Wr</A>, <A HREF="WrClass.i3">WrClass</A>;

PROCEDURE <A NAME="Open"><procedure>Open</procedure></A>(p: Pathname.T): T RAISES {OSError.E} =
  BEGIN
    RETURN NEW(T).init(FS.OpenFile(p))
  END Open;

PROCEDURE <A NAME="OpenAppend"><procedure>OpenAppend</procedure></A>(p: Pathname.T): T RAISES {OSError.E} =
  VAR h: RegularFile.T := FS.OpenFile(p, truncate := FALSE);
  BEGIN
    EVAL h.seek(RegularFile.Origin.End, 0);
    RETURN NEW(T).init(h)
  END OpenAppend;

REVEAL <A NAME="T">T</A> = Public BRANDED &quot;FileWr.T&quot; OBJECT
    targetH: File.T;
  OVERRIDES
    init := Init;
    seek := Seek;
    length := Length;
    flush := Flush;
    close := Close;
    putString := PutString;
  END;
</PRE><BLOCKQUOTE><EM> Q1: If <CODE>wr.targetH</CODE> is a <CODE>RegularFile.T</CODE> then the current position
       of <CODE>wr.targetH</CODE> is equal to <CODE>wr.lo</CODE>. 
<P>
   Q2: If <CODE>wr.seekable</CODE>, then <CODE>wr.targetH</CODE> is a <CODE>RegularFile.T</CODE>. </EM></BLOCKQUOTE><PRE>

TYPE CharBuffer = REF ARRAY OF CHAR;

CONST BufferSize = 4096;

CONST BIG = 16_1000000; (* 2^24 =&gt; 16M *)

TYPE ByteArrayPtr = UNTRACED REF ARRAY [0 .. BIG-1] OF File.Byte;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (wr: T; h: File.T; buffered: BOOLEAN := TRUE): T
  RAISES {OSError.E} =
  BEGIN
    wr.targetH := h;
    wr.st := 0;
    wr.closed := FALSE;
    IF (wr.buff = NIL) THEN
      wr.buff := NEW(CharBuffer, BufferSize);
    (*ELSE reuse the existing buffer *)
    END;
    TYPECASE h OF
    | RegularFile.T (hRF) =&gt;     (* seekable *)
      wr.seekable := TRUE;
      wr.cur := hRF.seek(RegularFile.Origin.Current, 0);
      wr.buffered := TRUE;
    ELSE
      wr.seekable := FALSE;
      wr.cur := 0;
      wr.buffered := buffered;
    END;
    wr.lo := wr.cur;
    wr.hi := wr.cur + NUMBER(wr.buff^);
    RETURN wr
  END Init;

EXCEPTION Error; &lt;*FATAL Error*&gt;

PROCEDURE <A NAME="Seek"><procedure>Seek</procedure></A>(wr: T; n: CARDINAL) RAISES {Wr.Failure} =
  BEGIN
    IF NOT wr.seekable AND n # wr.hi THEN RAISE Error END;
    TRY
      EmptyBuffer (wr);
      (* Maintains V4 -- we hope that on a seek failure the file
                         position is unchanged, ensuring Q1 *)
      IF n # wr.cur THEN
        IF n &gt; wr.cur THEN n := MIN(n, wr.targetH.status().size); END;
        EVAL NARROW(wr.targetH, RegularFile.T).seek(
                     RegularFile.Origin.Beginning, n);
        wr.cur := n;
        wr.lo := n;
        wr.hi := n + NUMBER(wr.buff^);
      END;
    EXCEPT
    | OSError.E(code) =&gt;  RAISE Wr.Failure(code)
    END
  END Seek;

PROCEDURE <A NAME="Length"><procedure>Length</procedure></A>(wr: T): CARDINAL RAISES {Wr.Failure} =
  BEGIN
    TRY
      IF wr.seekable THEN
        RETURN wr.targetH.status().size;
      ELSE
        RETURN wr.cur;
      END
    EXCEPT
    | OSError.E(code) =&gt;  RAISE Wr.Failure(code)
    END
  END Length;

PROCEDURE <A NAME="Flush"><procedure>Flush</procedure></A>(wr: T) RAISES {Wr.Failure} =
  BEGIN
    IF wr.cur &gt; wr.lo THEN
      TRY EmptyBuffer (wr);
      EXCEPT OSError.E(code) =&gt; RAISE Wr.Failure(code)
      END;
    END
  END Flush;

PROCEDURE <A NAME="EmptyBuffer"><procedure>EmptyBuffer</procedure></A>(wr: T) RAISES {OSError.E} =
  VAR buffered := wr.cur - wr.lo;  start := 0;  n: INTEGER;
  BEGIN
    WHILE (buffered &gt; 0) DO
      n := MIN (buffered, BIG);
      wr.targetH.write(
        SUBARRAY(LOOPHOLE(ADR(wr.buff[start]), ByteArrayPtr)^, 0, n));
      DEC (buffered, n);
      INC (start, n);
    END;
    (* the file position is now wr.cur *)
    wr.lo := wr.cur;
    wr.hi := wr.cur + NUMBER(wr.buff^);
  END EmptyBuffer;

PROCEDURE <A NAME="PutString"><procedure>PutString</procedure></A> (wr: T; READONLY buf: ARRAY OF CHAR)
  RAISES {Wr.Failure} =
  VAR toWrite, start, n: INTEGER;
  BEGIN
    IF NUMBER(buf) &lt;= wr.hi - wr.cur THEN
      SUBARRAY(wr.buff^, wr.cur - wr.lo, NUMBER(buf)) := buf;
      INC(wr.cur, NUMBER(buf));
    ELSE
      Flush(wr);
      IF 2 * NUMBER(buf) &lt; NUMBER(wr.buff^) THEN
        SUBARRAY(wr.buff^, 0, NUMBER(buf)) := buf;
        INC(wr.cur, NUMBER(buf));
      ELSE
        TRY
          toWrite := NUMBER (buf);
          start := 0;
          WHILE toWrite &gt; 0 DO
            n := MIN (toWrite, BIG);
            wr.targetH.write(
              SUBARRAY(LOOPHOLE(ADR(buf[start]), ByteArrayPtr)^, 0, n));
            DEC (toWrite, n);
            INC (start, n);
          END;
          INC(wr.cur, NUMBER(buf));
          wr.lo := wr.cur;
          wr.hi := wr.cur + NUMBER(wr.buff^);
        EXCEPT
        | OSError.E (code) =&gt; RAISE Wr.Failure(code);
        END
      END
    END
  END PutString;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A>(wr: T) RAISES {Wr.Failure} =
  BEGIN
    TRY
      wr.targetH.close()
    EXCEPT OSError.E(code) =&gt; RAISE Wr.Failure(code)
    END;
  END Close;

BEGIN
END FileWr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
