<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/IO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/IO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> The <CODE>IO</CODE> interface provides textual input and output for simple
   programs.  For more detailed control, use the interfaces <CODE>Rd</CODE>,
   <CODE>Wr</CODE>, <CODE>Stdio</CODE>, <CODE>FileRd</CODE>, <CODE>FileWr</CODE>, <CODE>Fmt</CODE>, and <CODE>Lex</CODE>.
<P>
   The input procedures take arguments of type <CODE>Rd.T</CODE> that specify
   which input stream to use.  If this argument is defaulted, standard
   input (<CODE>Stdio.stdin</CODE>) is used.  Similarly, if an argument of type
   <CODE>Wr.T</CODE> to an output procedure is defaulted, <CODE>Stdio.stdout</CODE> is used.
   

<P><PRE>INTERFACE <interface><A HREF="IO.m3">IO</A></interface>;

IMPORT <A HREF="Rd.i3">Rd</A>, <A HREF="Wr.i3">Wr</A>;

PROCEDURE <A HREF="IO.m3#Put">Put</A>(txt: TEXT; wr: Wr.T := NIL);
</PRE><BLOCKQUOTE><EM> Output <CODE>txt</CODE> to <CODE>wr</CODE> and flush <CODE>wr</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="IO.m3#PutInt">PutInt</A>(n: INTEGER; wr: Wr.T := NIL);
</PRE><BLOCKQUOTE><EM> Output <CODE>Fmt.Int(n)</CODE> to <CODE>wr</CODE> and flush <CODE>wr</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="IO.m3#PutReal">PutReal</A>(r: REAL; wr: Wr.T := NIL);
</PRE><BLOCKQUOTE><EM> Output <CODE>Fmt.Real(r)</CODE> to <CODE>wr</CODE> and flush <CODE>wr</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="IO.m3#EOF">EOF</A>(rd: Rd.T := NIL): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> iff <CODE>rd</CODE> is at end-of-file. </EM></BLOCKQUOTE><PRE>

EXCEPTION Error;
</PRE> The exception <CODE>Error</CODE> is raised whenever a <CODE>Get</CODE> procedure
   encounters syntactically invalid input, including unexpected
   end-of-file. 

<P><PRE>PROCEDURE <A HREF="IO.m3#GetLine">GetLine</A>(rd: Rd.T := NIL): TEXT RAISES {Error};
</PRE><BLOCKQUOTE><EM> Read a line of text from <CODE>rd</CODE> and return it. </EM></BLOCKQUOTE><PRE>
</PRE> A line of text is either zero or more characters terminated by a
   line break, or one or more characters terminated by an end-of-file.
   In the former case, <CODE>GetLine</CODE> consumes the line break but does not
   include it in the returned value.  A line break is either {\tt
   "\n"} or {\tt
   "\r\n"}. 

<P><PRE>PROCEDURE <A HREF="IO.m3#GetChar">GetChar</A>(rd: Rd.T := NIL): CHAR RAISES {Error};
</PRE><BLOCKQUOTE><EM> Read the next character from <CODE>rd</CODE> and return it. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="IO.m3#GetInt">GetInt</A>(rd: Rd.T := NIL): INTEGER RAISES {Error};
</PRE><BLOCKQUOTE><EM> Read a decimal numeral from <CODE>rd</CODE> using <CODE>Lex.Int</CODE> and return its
   value. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="IO.m3#GetReal">GetReal</A>(rd: Rd.T := NIL): REAL RAISES {Error};
</PRE><BLOCKQUOTE><EM> Read a real number from <CODE>rd</CODE> using <CODE>Lex.Real</CODE> and return its value.
   </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="IO.m3#OpenRead">OpenRead</A>(f: TEXT): Rd.T;
</PRE><BLOCKQUOTE><EM> Open the file name <CODE>f</CODE> for reading and return a reader on its
   contents. If the file doesn't exist or is not readable, return
   <CODE>NIL</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="IO.m3#OpenWrite">OpenWrite</A>(f: TEXT): Wr.T;
</PRE><BLOCKQUOTE><EM> Open the file named <CODE>f</CODE> for writing and return a writer on its
   contents.  If the file does not exist it will be created.  If the
   process does not have the authority to modify or create the file,
   return <CODE>NIL</CODE>. </EM></BLOCKQUOTE><PRE>

END IO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
