<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/MsgRd.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/MsgRd.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><P>
A <CODE>MsgRd.T</CODE> is a reader which presents the abstraction of a stream of
messages.  A message is a (possibly zero length) sequence of bytes
terminated by an end of message marker.  The reader is initially
positioned to the start of the first message.  When the end of message
marker is encountered, it is represented by <CODE>EndOfFile</CODE> on the reader.
The <CODE>nextMsg</CODE> method can be used to advance to the next message in the
stream. This method waits for the next message and returns <CODE>TRUE</CODE> when
it becomes available.  A return value of <CODE>FALSE</CODE> indicates that there
are (and will be) no further messages.  The reader's current position
is set to zero on return from <CODE>nextMsg</CODE>, and the reader no longer reports
<CODE>EndOfFile</CODE> (unless of course the next message is zero length).
<P>
If <CODE>nextMsg</CODE> is invoked when the reader is not at <CODE>EndOfFile</CODE>, the
remaining bytes in the current message will be skipped.
<P>
Calling <CODE>Rd.Close</CODE> on a <CODE>MsgRd.T</CODE> will release all associated resources,
and trigger checked runtime errors on further attempts to read from the
closed reader.


<P><PRE>INTERFACE <interface>MsgRd</interface>;

IMPORT <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="Rd.i3">Rd</A>;

TYPE
  T = Rd.T OBJECT METHODS
    nextMsg() : BOOLEAN RAISES {Rd.Failure, Thread.Alerted};
  END;
</PRE><BLOCKQUOTE><EM> The <CODE>nextMsg</CODE> method advances to the next message. A return value
   of <CODE>TRUE</CODE> indicates the presence of a new message. <CODE>FALSE</CODE> indicates
   that no next message is present, and that the end of the stream of
   messages has been reached. </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>nextMsg</CODE> methods affects the abstract reader state as follows:
    <P>
\begin{tabular}{ll}
        &amp; \\
        <CODE>len(rd)</CODE>          &amp;   is the length of the next message \\
        <CODE>src(rd)</CODE>          &amp;   is the contents of the next message \\
        <CODE>cur(rd)</CODE>          &amp;   is zero \\
        <CODE>avail(rd)</CODE>        &amp;   is unspecified \\
        <CODE>closed(rd)</CODE>       &amp;   is unchanged \\ 
        <CODE>seekable(rd)</CODE>     &amp;   is unchanged \\
        <CODE>intermittent(rd)</CODE> &amp;   is unchanged \\
        &amp; \\
\end{tabular}
<P>
   Message reader buffers must be word-aligned in memory. More
   precisely, if byte <CODE>i</CODE> in the data stream is stored in the
   buffer at memory address <CODE>j</CODE>, then <CODE>i</CODE> and <CODE>j</CODE> must be
   equal modulo the machine word size.


<P><PRE>END MsgRd.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
