<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/MsgWr.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/MsgWr.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><P>
A <CODE>MsgWr.T</CODE> is a writer which presents the abstraction of a stream of
messages.  A message is a (possibly zero length) sequence of bytes
terminated by an end of message marker.  The writer is initially
positioned to the start of the first message.  The <CODE>nextMsg</CODE> method
can be used to end the current message, and position the writer at
the start of the next message.  The writer's current position is
reset to zero on return from <CODE>nextMsg</CODE>. 
<P>
Invoking <CODE>Wr.Flush</CODE> on a <CODE>MsgWr.T</CODE> will flush the current buffer to the
abstract writer target, but will not end the current message.
<P>
Calling <CODE>Wr.Close</CODE> on a <CODE>MsgWr.T</CODE> will release all associated resources
and trigger checked runtime errors on further attempts to write to the
closed writer. It also flushes and terminates the current message.  This
means that a zero-length message will be sent at close time if no data 
has been written into the current message (e.g. directly after <CODE>nextMsg</CODE>
or object initialization).


<P><PRE>INTERFACE <interface>MsgWr</interface>;

IMPORT <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="Wr.i3">Wr</A>;

TYPE
  T = Wr.T OBJECT METHODS
    nextMsg() RAISES {Wr.Failure, Thread.Alerted};
  END;
</PRE><BLOCKQUOTE><EM> <CODE>nextMsg</CODE> ends the current message, and starts the next. </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>nextMsg</CODE> method affects the abstract writer state as follows:
      <P>
\begin{tabular}{ll}
        &amp; \\
          <CODE>len(wr)</CODE>      &amp;      is zero \\
          <CODE>c(wr)</CODE>        &amp;      is empty \\
          <CODE>cur(wr)</CODE>      &amp;      is zero \\
          <CODE>target(wr)</CODE>   &amp;      is empty \\
          <CODE>closed(wr)</CODE>   &amp;      is unchanged \\
          <CODE>seekable(wr)</CODE> &amp;      is unchanged \\
          <CODE>buffered(wr)</CODE> &amp;      is unchanged \\
        &amp; \\
\end{tabular}
<P>
   Message writer buffers must be word-aligned in memory. More
   precisely, if byte <CODE>i</CODE> in the data stream is stored in the
   buffer at memory address <CODE>j</CODE>, then <CODE>i</CODE> and <CODE>j</CODE> must be
   equal modulo the machine word size.


<P><PRE>END MsgWr.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
