<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/NullWr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/NullWr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="NullWr.i3">NullWr</A></implements></module>;

IMPORT <A HREF="WrClass.i3">WrClass</A>;

CONST
  BuffSize = 1024;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      OVERRIDES
        seek:= Seek;
        putString := PutString;
        init := Init;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (wr: T): T =
  BEGIN
    wr.st := 0;
    wr.lo := 0;
    wr.cur := 0;
    wr.hi := BuffSize;
    IF (wr.buff = NIL) THEN
      wr.buff := NEW(REF ARRAY OF CHAR, BuffSize);
    END;
    wr.closed := FALSE;
    wr.seekable := FALSE;
    wr.buffered := TRUE;
    RETURN wr;
  END Init;

PROCEDURE <A NAME="Seek"><procedure>Seek</procedure></A> (wr: T; n: CARDINAL) =
  BEGIN
    wr.lo := n;
    wr.cur := n;
    wr.hi := n + BuffSize;
  END Seek;

PROCEDURE <A NAME="PutString"><procedure>PutString</procedure></A> (wr: T; READONLY a: ARRAY OF CHAR) =
  BEGIN
    Seek(wr, wr.cur + NUMBER(a));
  END PutString;

BEGIN
END NullWr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
