<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/Rd.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/Rd.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> An <CODE>Rd.T</CODE> (or ``reader'') is a character input stream.  The basic
   operation on a reader is <CODE>GetChar</CODE>, which returns the source
   character at the ``current position'' and advances the current
   position by one.  Some readers are ``seekable'', which means that
   they also allow setting the current position anywhere in the
   source.  For example, readers from random access files are
   seekable; readers from terminals and sequential files are not.
   \index{character input stream}
   \index{input stream}
   \index{stream!input}
   \index{reader}
<P>
   Some readers are ``intermittent'', which means that the source of
   the reader trickles in rather than being available to the
   implementation all at once.  For example, the input stream from an
   interactive terminal is intermittent.  An intermittent reader is
   never seekable.
<P>
   Abstractly, a reader <CODE>rd</CODE> consists of
<P>
<PRE>
      len(rd)           <KBD>the number of source characters</KBD>
      src(rd)           <KBD>a sequence of length </KBD>len(rd)+1<KBD></KBD>
      cur(rd)           <KBD>an integer in the range </KBD>[0..len(rd)]<KBD></KBD>
      avail(rd)         <KBD>an integer in the range </KBD>[cur(rd)..len(rd)+1]<KBD></KBD>
      closed(rd)        <KBD>a boolean</KBD>
      seekable(rd)      <KBD>a boolean</KBD>
      intermittent(rd)  <KBD>a boolean</KBD>
</PRE>
   These values are not necessarily directly represented in the data
   fields of a reader object.  In particular, for an intermittent
   reader, <CODE>len(rd)</CODE> may be unknown to the implementation.  But in
   principle the values determine the state of the reader.
<P>
   The sequence <CODE>src(rd)</CODE> is zero-based: <CODE>src(rd)[i]</CODE> is valid for <CODE>i</CODE>
   from 0 to <CODE>len(rd</CODE>). The first <CODE>len(rd)</CODE> elements of <CODE>src</CODE> are the
   characters that are the source of the reader.  The final element is
   a special value <CODE>eof</CODE> used to represent end-of-file.  The value
   <CODE>eof</CODE> is not a character.
<P>
   The value of <CODE>cur(rd)</CODE> is the index in <CODE>src(rd)</CODE> of the next
   character to be returned by <CODE>GetChar</CODE>, unless <CODE>cur(rd) = len(rd)</CODE>,
   in which case a call to <CODE>GetChar</CODE> will raise the exception
   <CODE>EndOfFile</CODE>.
<P>
   The value of <CODE>avail(rd)</CODE> is important for intermittent readers: the
   elements whose indexes in <CODE>src(rd)</CODE> are in the range
   <CODE>[cur(rd)..avail(rd)-1]</CODE> are available to the implementation and
   can be read by clients without blocking.  If the client tries to
   read further, the implementation will block waiting for the other
   characters.  If <CODE>rd</CODE> is not intermittent, then <CODE>avail(rd)</CODE> is equal
   to <CODE>len(rd)+1</CODE>.  If <CODE>rd</CODE> is intermittent, then <CODE>avail(rd)</CODE> can
   increase asynchronously, although the procedures in this interface
   are atomic with respect to such increases.
<P>
   The definitions above encompass readers with infinite sources.  If
   <CODE>rd</CODE> is such a reader, then <CODE>len(rd)</CODE> and <CODE>len(rd)+1</CODE> are both
   infinity, and there is no final <CODE>eof</CODE> value.
<P>
   Every reader is a monitor; that is, it contains an internal lock
   that is acquired and held for each operation in this interface, so
   that concurrent operations will appear atomic.  For faster,
   unmonitored access, see the <CODE>UnsafeRd</CODE> interface.
<P>
   If you are implementing a long-lived reader class, such as a pipe 
   or TCP stream, the index of the reader may eventually overflow, 
   causing the program to crash with a bounds fault.  We recommend
   that you provide an operation to reset the reader index, which the
   client can call periodically. 

<P><PRE>INTERFACE <interface><A HREF="#x1">Rd</A></interface>;

IMPORT <A HREF="../../../libm3/derived/AtomList.i3">AtomList</A>;
FROM <A HREF="../../../thread/src/Common/Thread.i3">Thread</A> IMPORT Alerted;

TYPE T &lt;: ROOT;

EXCEPTION EndOfFile; Failure(AtomList.T);
</PRE> Since there are many classes of readers, there are many ways that a
   reader can break---for example, the connection to a terminal can be
   broken, the disk can signal a read error, etc.  All problems of
   this sort are reported by raising the exception <CODE>Failure</CODE>.  The
   documentation of a reader class should specify what failures the
   class can raise and how they are encoded in the argument to
   <CODE>Failure</CODE>.
<P>
   Illegal operations cause a checked runtime error. 

<P><PRE>PROCEDURE <A HREF="RdMove.m3#GetChar">GetChar</A>(rd: T): CHAR
  RAISES {EndOfFile, Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Return the next character from <CODE>rd</CODE>. More precisely, this is
   equivalent to the following, in which <CODE>res</CODE> is a local variable of
   type <CODE>CHAR</CODE>: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      IF closed(rd) THEN <KBD>Cause checked runtime error</KBD> END;
      <KBD>Block until </KBD>avail(rd) &gt; cur(rd)<KBD></KBD>;
      IF cur(rd) = len(rd) THEN
        RAISE EndOfFile
      ELSE
        res := src(rd)[cur(rd)]; INC(cur(rd)); RETURN res
      END


<P> </PRE>
Many operations on a reader can wait indefinitely.  For example,
   <CODE>GetChar</CODE> can wait if the user is not typing. In general these waits
   are alertable, so each procedure that might wait includes
   <CODE>Thread.Alerted</CODE> in its <CODE>RAISES</CODE> clause. 

<P><PRE>PROCEDURE <A HREF="RdMove.m3#EOF">EOF</A>(rd: T): BOOLEAN RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> iff <CODE>rd</CODE> is at end-of-file. More precisely, this is
   equivalent to: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      IF closed(rd) THEN <KBD>Cause checked runtime error</KBD> END;
      <KBD>Block until </KBD>avail(rd) &gt; cur(rd)<KBD></KBD>;
      RETURN cur(rd) = len(rd)


<P> </PRE>
Notice that on an intermittent reader, <CODE>EOF</CODE> can block. For example, if
   there are no characters buffered in a terminal reader, <CODE>EOF</CODE> must wait
   until the user types one before it can determine whether he typed the
   special key signalling end-of-file. If you are using <CODE>EOF</CODE> in an
   interactive input loop, the right sequence of operations is:
   \begin{enumerate}
   \item prompt the user;
   \item call <CODE>EOF</CODE>, which probably waits on user input;
   \item presuming that <CODE>EOF</CODE> returned <CODE>FALSE</CODE>, read the user's input.
   \end{enumerate} 

<P><PRE>PROCEDURE <A HREF="RdMove.m3#UnGetChar">UnGetChar</A>(rd: T) RAISES {};
</PRE><BLOCKQUOTE><EM> ``Push back'' the last character read from <CODE>rd</CODE>, so that the next
   call to <CODE>GetChar</CODE> will read it again. More precisely, this is
   equivalent to the following: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      IF closed(rd) THEN <KBD>Cause checked runtime error</KBD> END;
      IF cur(rd) &gt; 0 THEN DEC(cur(rd)) END
</PRE>
   except there is a special rule: <CODE>UnGetChar(rd)</CODE> is guaranteed to
   work only if <CODE>GetChar(rd)</CODE> was the last operation on <CODE>rd</CODE>.  Thus
   <CODE>UnGetChar</CODE> cannot be called twice in a row, or after <CODE>Seek</CODE> or
   <CODE>EOF</CODE>. If this rule is violated, the implementation is allowed (but
   not required) to cause a checked runtime error. 

<P><PRE>PROCEDURE <A HREF="RdMove.m3#CharsReady">CharsReady</A>(rd: T): CARDINAL RAISES {Failure};
</PRE><BLOCKQUOTE><EM> Return some number of characters that can be read without
   indefinite waiting. The ``end of file marker'' counts as one
   character for this purpose, so <CODE>CharsReady</CODE> will return 1, not 0,
   if <CODE>EOF(rd)</CODE> is true. More precisely, this is equivalent to the
   following: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      IF closed(rd) THEN <KBD>Cause checked runtime error</KBD> END;
      IF avail(rd) = cur(rd) THEN
        RETURN 0
      ELSE 
        RETURN <KBD>some number in the range </KBD>[1~..~avail(rd) - cur(rd)]<KBD></KBD>
      END;


<P> </PRE>
Warning: <CODE>CharsReady</CODE> can return a result less than <CODE>avail(rd) -
   cur(rd)</CODE>; also, more characters might trickle in just as
   <CODE>CharsReady</CODE> returns. So the code to flush buffered input without
   blocking requires a loop:
<P>
<PRE>
      LOOP
        n := Rd.CharsReady(rd);
        IF n = 0 THEN EXIT END;
        FOR i := 1 TO n DO EVAL Rd.GetChar(rd) END
      END;


<P><PRE>PROCEDURE <A HREF="RdMove.m3#GetSub">GetSub</A>(rd: T; VAR (*OUT*) str: ARRAY OF CHAR)
  : CARDINAL RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Read from <CODE>rd</CODE> into <CODE>str</CODE> until <CODE>rd</CODE> is exhausted or <CODE>str</CODE> is
   filled. More precisely, this is equivalent to the following, in
   which <CODE>i</CODE> is a local variable: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      i := 0;
      WHILE i # NUMBER(str) AND NOT EOF(rd) DO
        str[i] := GetChar(rd); INC(i)
      END;
      RETURN i


<P><PRE>PROCEDURE <A HREF="RdImpl.m3#GetSubLine">GetSubLine</A>(rd: T; VAR (*OUT*) str: ARRAY OF CHAR)
  : CARDINAL RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Read from <CODE>rd</CODE> into <CODE>str</CODE> until a newline is read, <CODE>rd</CODE> is
   exhausted, or <CODE>str</CODE> is filled. More precisely, this is equivalent
   to the following, in which <CODE>i</CODE> is a local variable: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      i := 0;
      WHILE
        i # NUMBER(str) AND
        (i = 0 OR str[i-1] # '\n') AND
        NOT EOF(rd) 
      DO
        str[i] := GetChar(rd); INC(i)
      END;
      RETURN i


<P> </PRE>
Note that <CODE>GetLine</CODE> strips the terminating line break, while
   <CODE>GetSubLine</CODE> does not. 

<P><PRE>PROCEDURE <A HREF="RdImpl.m3#GetText">GetText</A>(rd: T; len: CARDINAL): TEXT
  RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Read from <CODE>rd</CODE> until it is exhausted or <CODE>len</CODE> characters have been
   read, and return the result as a <CODE>TEXT</CODE>.  More precisely, this is
   equivalent to the following, in which <CODE>i</CODE> and <CODE>res</CODE> are local
   variables: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      res := &quot;&quot;; i := 0;
      WHILE i # len AND NOT EOF(rd) DO
        res := res &amp; Text.FromChar(GetChar(rd));
        INC(i)
      END;
      RETURN res


<P><PRE>PROCEDURE <A HREF="RdImpl.m3#GetLine">GetLine</A>(rd: T): TEXT
  RAISES {EndOfFile, Failure, Alerted};
</PRE><BLOCKQUOTE><EM> If <CODE>EOF(rd)</CODE> then raise <CODE>EndOfFile</CODE>.  Otherwise, read characters
   until a line break is read or <CODE>rd</CODE> is exhausted, and return the
   result as a <CODE>TEXT</CODE>---but discard the line break if it is present.
   A line break is either {\tt "\n"} or {\tt
   "\r\n"} More precisely, this is
   equivalent to the following, in which <CODE>ch</CODE> and <CODE>res</CODE> are local
   variables: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      IF EOF(rd) THEN RAISE EndOfFile END;
      res := &quot;&quot;; ch := '\000'; (* any char but newline 

<PRE>| WHILE ch # '\n' AND NOT EOF(rd) DO
|   ch := GetChar(rd);
|   IF ch = '\n' THEN
|     IF NOT Text.Empty(res) AND
|         Text.GetChar(res, Text.Length(res)-1) = '\r' THEN
|       res := Text.Sub(res, 0, Text.Length(res)-1)
|     END
|   ELSE
|     res := res &amp; Text.FromChar(ch)
|   END
| RETURN res
*)

PROCEDURE <A HREF="RdMove.m3#Seek">Seek</A>(rd: T; n: CARDINAL) RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> This is equivalent to: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      IF closed(rd) OR NOT seekable(rd) THEN
        <KBD>Cause checked runtime error</KBD>
      END;
      cur(rd) := MIN(n, len(rd))


<P><PRE>PROCEDURE <A HREF="RdMove.m3#Close">Close</A>(rd: T) RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Release any resources associated with <CODE>rd</CODE> and set <CODE>closed(rd) :=
   TRUE</CODE>.  The documentation of a procedure that creates a reader
   should specify what resources are released when the reader is
   closed.  This leaves <CODE>rd</CODE> closed even if it raises an exception,
   and is a no-op if <CODE>rd</CODE> is closed. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RdMove.m3#Index">Index</A>(rd: T): CARDINAL RAISES {};
</PRE><BLOCKQUOTE><EM> This is equivalent to: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      IF closed(rd) THEN <KBD>Cause checked runtime error</KBD> END;
      RETURN cur(rd)


<P><PRE>PROCEDURE <A HREF="RdMove.m3#Length">Length</A>(rd: T): INTEGER RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> This is equivalent to: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      IF closed(rd) THEN
        <KBD>Cause checked runtime error</KBD>
      END;
      RETURN len(rd)
</PRE>
   If <CODE>len(rd)</CODE> is unknown to the implementation of an intermittent
   reader, <CODE>Length(rd)</CODE> returns -1.  

<P><PRE>PROCEDURE <A HREF="RdImpl.m3#Intermittent">Intermittent</A>(rd: T): BOOLEAN RAISES {};
PROCEDURE <A HREF="RdImpl.m3#Seekable">Seekable</A>(rd: T): BOOLEAN RAISES {};
PROCEDURE <A HREF="RdImpl.m3#Closed">Closed</A>(rd: T): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Return <CODE>intermittent(rd)</CODE>, <CODE>seekable(rd)</CODE>, and <CODE>closed(rd)</CODE>,
   respectively. These can be applied to closed readers. </EM></BLOCKQUOTE><PRE>

END Rd.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Rd's implementation  is in:
</A><UL>
<LI><A HREF="RdImpl.m3#0TOP0">rw/src/Common/RdImpl.m3</A>
<LI><A HREF="RdMove.m3#0TOP0">rw/src/Common/RdMove.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
