<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/RdCopy.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/RdCopy.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>      created  on ???????????????????????????? by unknown                  

<P><PRE>INTERFACE <interface><A HREF="RdCopy.m3">RdCopy</A></interface>;

IMPORT <A HREF="Rd.i3">Rd</A>, <A HREF="Wr.i3">Wr</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;

PROCEDURE <A HREF="RdCopy.m3#ToWriter">ToWriter</A> (rd: Rd.T; wr: Wr.T; length: CARDINAL := LAST(CARDINAL)):
  CARDINAL RAISES {Rd.Failure, Wr.Failure, Thread.Alerted};
  (* Copies MIN(length, len(rd) - cur(rd)) bytes from rd to wr.  Returns
     the number of bytes copied.  Equivalent to:

     FOR i := 0 TO length - 1 DO
       IF Rd.EOF(rd) THEN RETURN i; END;
       Wr.PutChar(Rd.GetChar(rd));
     END;
     RETURN length;

     But faster.  This uses ToProc below to copy from rd's buffer
     into wr's putString method.
   *)

PROCEDURE <A HREF="RdCopy.m3#ToProc">ToProc</A> (rd  : Rd.T;
                  proc: PROCEDURE (READONLY a: ARRAY OF CHAR) RAISES ANY;
                  length: CARDINAL := LAST(CARDINAL)): CARDINAL
  RAISES ANY (* RAISES(proc) + {Rd.Failure, Thread.Alerted *);
  (* Passes MIN(length, len(rd) - cur(rd)) bytes from rd to proc.  Returns
     the number of bytes copied.  The length of the arrays passed to
     proc is not defined. *)

PROCEDURE <A HREF="RdCopy.m3#FromProc">FromProc</A> (wr: Wr.T;
                    proc: PROCEDURE (VAR a: ARRAY OF CHAR): CARDINAL
                            RAISES ANY;
                    length: CARDINAL := LAST(CARDINAL)): CARDINAL
  RAISES ANY (* RAISES(proc) + {Rd.Failure, Thread.Alerted *);
  (* Calls proc repeatedly to fill in up to length bytes in a buffer which are
     written to the writer.  If proc returns a value &lt; NUMBER(a) then
     the procedure is assumed to be finished producing characters.
     Returns the total number of characters gotten from proc. *)

END RdCopy.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
