<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/RdCopy.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/RdCopy.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>      created  on ???????????????????????????? by unknown                  

<P><PRE>MODULE <module><implements><A HREF="RdCopy.i3">RdCopy</A></implements></module>;

IMPORT <A HREF="RdClass.i3">RdClass</A>, <A HREF="WrClass.i3">WrClass</A>, <A HREF="Rd.i3">Rd</A>, <A HREF="Wr.i3">Wr</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;

PROCEDURE <A NAME="ToWriter"><procedure>ToWriter</procedure></A> (rd: Rd.T; wr: Wr.T; length: CARDINAL := LAST(CARDINAL)):
  CARDINAL RAISES {Rd.Failure, Wr.Failure, Thread.Alerted}&lt;*NOWARN*&gt; =
  (*
  PROCEDURE GetSub (VAR a: ARRAY OF CHAR): CARDINAL
    RAISES {Rd.Failure, Thread.Alerted} =
    BEGIN
      RETURN Rd.GetSub(rd, a);
    END GetSub;
  *)
  PROCEDURE PutString (READONLY a: ARRAY OF CHAR)
    RAISES {Wr.Failure, Thread.Alerted} =
    BEGIN
      Wr.PutString(wr, a);
    END PutString;
  &lt;*FATAL ANY*&gt;
  BEGIN
    RETURN ToProc(rd, PutString, length);
  END ToWriter;

PROCEDURE <A NAME="ToProc"><procedure>ToProc</procedure></A> (rd  : Rd.T;
                  proc: PROCEDURE (READONLY a: ARRAY OF CHAR) RAISES ANY;
                  length: CARDINAL := LAST(CARDINAL)): CARDINAL
  RAISES ANY (* RAISES(proc) + {Rd.Failure, Thread.Alerted *) =
  VAR i := 0;
  BEGIN
    RdClass.Lock(rd);
    TRY
      LOOP
        WITH len = MIN(length - i, rd.hi - rd.cur) DO
          IF len &gt; 0 THEN
            proc(SUBARRAY(rd.buff^, rd.st + rd.cur - rd.lo, len));
            INC(i, len);
            INC(rd.cur, len);
          END;
        END;
        IF i = length OR rd.seek(rd.cur, FALSE) = RdClass.SeekResult.Eof THEN
          EXIT;
        END;
      END;
    FINALLY
      RdClass.Unlock(rd);
    END;
    RETURN i;
  END ToProc;

PROCEDURE <A NAME="FromProc"><procedure>FromProc</procedure></A> (wr: Wr.T;
                    proc: PROCEDURE (VAR a: ARRAY OF CHAR): CARDINAL
                            RAISES ANY;
                    length: CARDINAL := LAST(CARDINAL)): CARDINAL
  RAISES ANY (* RAISES(proc) + {Rd.Failure, Thread.Alerted *) =
  VAR i := 0;
  BEGIN
    WrClass.Lock(wr);
    TRY
      LOOP
        WITH len = MIN(length - i, wr.hi - wr.cur) DO
          IF len &gt; 0 THEN
            WITH res = proc(
                         SUBARRAY(wr.buff^, wr.st + wr.cur - wr.lo, len)) DO
              INC(i, res);
              INC(wr.cur, res);
              IF res # len THEN EXIT; END;
            END;
          END;
        END;
        IF i = length THEN EXIT; END;
        wr.seek(wr.cur);
      END;
    FINALLY
      WrClass.Unlock(wr);
    END;
    RETURN i;
  END FromProc;

BEGIN
END RdCopy.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
