<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/RdMove.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/RdMove.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> This module is very similar to the WrMove module, so we will list
its code with only a few comments.  

<P><PRE>MODULE <module>RdMove</module> EXPORTS <A HREF="Rd.i3"><implements>Rd</A></implements>, <A HREF="RdClass.i3"><implements>RdClass</A></implements>, <A HREF="UnsafeRd.i3"><implements>UnsafeRd</A></implements>;
IMPORT <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
FROM <A HREF="../../../thread/src/Common/Thread.i3">Thread</A> IMPORT Alerted;

REVEAL
  <A NAME="Private">Private</A> = Thread.Mutex BRANDED OBJECT END;
</PRE> FastGetChar and GetChar are identical except that GetChar acquires
   and releases the lock while FastGetChar assumes it is already held. 

<P> It is invariant that for a closed reader <CODE>rd</CODE>, <CODE>rd.buff = NIL</CODE> and
   <CODE>rd.lo = rd.hi</CODE>.  Therefore the check that <CODE>rd</CODE> is ready need
   not inspect <CODE>rd.closed</CODE> on the fast path. 

<P><PRE>&lt;*INLINE*&gt;
PROCEDURE <A NAME="GetChar"><procedure>GetChar</procedure></A> (rd: T): CHAR RAISES {EndOfFile, Failure, Alerted} =
  VAR res: CHAR; BEGIN
    LOCK rd DO
      IF rd.cur = rd.hi THEN DoSeek(rd) END;
      res := rd.buff[rd.st + (rd.cur - rd.lo)];
      INC(rd.cur);
      RETURN res
    END
  END GetChar;

&lt;*INLINE*&gt;
PROCEDURE <A NAME="FastGetChar"><procedure>FastGetChar</procedure></A>(rd: T): CHAR
    RAISES {EndOfFile, Failure, Alerted} =
    (* rd is locked *)
  VAR res: CHAR; BEGIN
    IF rd.cur = rd.hi THEN DoSeek(rd) END;
    res := rd.buff[rd.st + (rd.cur - rd.lo)];
    INC(rd.cur);
    RETURN res
  END FastGetChar;

PROCEDURE <A NAME="DoSeek"><procedure>DoSeek</procedure></A>(rd: T) RAISES {EndOfFile, Failure, Alerted} =
  BEGIN
    (* rd.cur = rd.hi here *)
    IF rd.closed THEN Die() END;
    IF rd.seek(rd.cur, FALSE) = SeekResult.Eof THEN
      RAISE EndOfFile
    END
  END DoSeek;

PROCEDURE <A NAME="GetSub"><procedure>GetSub</procedure></A> (rd: T; VAR (*out*) str: ARRAY OF CHAR): CARDINAL
  RAISES {Failure, Alerted} =
  BEGIN
    LOCK rd DO
      IF rd.closed THEN Die() END;
      RETURN rd.getSub(str)
    END
  END GetSub;

PROCEDURE <A NAME="FastGetSub"><procedure>FastGetSub</procedure></A> (rd: T; VAR (*out*) str: ARRAY OF CHAR): CARDINAL
  RAISES {Failure, Alerted} =
  BEGIN
    IF rd.closed THEN Die() END;
    RETURN rd.getSub(str)
  END FastGetSub;

PROCEDURE <A NAME="GetSubDefault"><procedure>GetSubDefault</procedure></A> (rd: T; VAR (*out*) str: ARRAY OF CHAR): CARDINAL
  RAISES {Failure, Alerted} =
  VAR i := 0; BEGIN
    LOOP
      (* i chars have been read into str *)
      IF i = NUMBER(str) THEN EXIT END;
      IF rd.cur = rd.hi THEN
        IF rd.seek(rd.cur, FALSE) = SeekResult.Eof THEN EXIT END
      END;
      (* rd.lo &lt;= rd.cur &lt; rd.hi *)
      VAR n := MIN(rd.hi - rd.cur, NUMBER(str) - i); BEGIN
        SUBARRAY(str, i, n) :=
          SUBARRAY(rd.buff^, rd.cur - rd.lo + rd.st, n);
        INC(i, n);
        INC(rd.cur, n)
      END
    END;
    RETURN i
  END GetSubDefault;
</PRE> EOF and FastEOF are identical except that EOF acquires and releases
   the reader lock while FastEOF assumes it is already held. 

<P><PRE>&lt;*INLINE*&gt;
PROCEDURE <A NAME="EOF"><procedure>EOF</procedure></A> (rd: T): BOOLEAN RAISES {Failure, Alerted} =
  (* rd is unlocked *)
  BEGIN
    LOCK rd DO
      IF rd.cur # rd.hi THEN
        RETURN FALSE
      ELSE
        IF rd.closed THEN Die() END;
        RETURN rd.seek(rd.cur, FALSE) = SeekResult.Eof
      END
    END
  END EOF;

&lt;*INLINE*&gt;
PROCEDURE <A NAME="FastEOF"><procedure>FastEOF</procedure></A> (rd: T): BOOLEAN RAISES {Failure, Alerted} =
  BEGIN
    (* rd is locked *)
    IF rd.cur # rd.hi THEN
      RETURN FALSE
    ELSE
      IF rd.closed THEN Die() END;
      RETURN rd.seek(rd.cur, FALSE) = SeekResult.Eof
    END
  END FastEOF;

PROCEDURE <A NAME="UnGetChar"><procedure>UnGetChar</procedure></A>(rd: T) RAISES {} =
  BEGIN
    LOCK rd DO FastUnGetChar (rd) END;
  END UnGetChar;

PROCEDURE <A NAME="FastUnGetChar"><procedure>FastUnGetChar</procedure></A>(rd: T) RAISES {} =
  BEGIN
    IF rd.closed OR rd.cur = rd.lo THEN Die() END;
    DEC(rd.cur)
  END FastUnGetChar;

PROCEDURE <A NAME="CharsReady"><procedure>CharsReady</procedure></A>(rd: T): CARDINAL RAISES {Failure} =
  &lt;*FATAL Thread.Alerted*&gt;
  BEGIN
    LOCK rd DO
      IF rd.cur = rd.hi THEN
        IF rd.closed THEN Die() END;
        IF rd.seek(rd.cur, TRUE) = SeekResult.Eof THEN RETURN 1 END
      END;
      RETURN rd.hi - rd.cur;
    END
  END CharsReady;

PROCEDURE <A NAME="Index"><procedure>Index</procedure></A>(rd: T): CARDINAL RAISES {} =
  BEGIN
    LOCK rd DO
      IF rd.closed THEN Die() END;
      RETURN rd.cur
    END
  END Index;

PROCEDURE <A NAME="Length"><procedure>Length</procedure></A>(rd: T): INTEGER RAISES {Failure, Alerted} =
  BEGIN
    LOCK rd DO
      IF rd.closed THEN Die() END;
      RETURN rd.length()
    END
  END Length;

PROCEDURE <A NAME="Seek"><procedure>Seek</procedure></A>(rd: T; n: CARDINAL) RAISES {Failure, Alerted} =
  BEGIN
    LOCK rd DO
      IF rd.closed OR NOT rd.seekable THEN Die() END;
      IF n &lt; rd.lo OR n &gt; rd.hi THEN
        EVAL rd.seek(n, FALSE);
      ELSE
        rd.cur := n;
      END
    END
  END Seek;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A>(rd: T) RAISES {Failure, Alerted} =
  BEGIN
    LOCK rd DO FastClose (rd); END;
  END Close;

PROCEDURE <A NAME="FastClose"><procedure>FastClose</procedure></A>(rd: T) RAISES {Failure, Alerted} =
  BEGIN
    IF NOT rd.closed THEN
      TRY
        rd.close()
      FINALLY
        rd.closed := TRUE;
        rd.cur := rd.hi;
        rd.lo := rd.hi;
        rd.buff := NIL
      END
    END
  END FastClose;

PROCEDURE <A NAME="Lock"><procedure>Lock</procedure></A> (rd: T) RAISES {} =
  BEGIN
    Thread.Acquire (rd)
  END Lock;

PROCEDURE <A NAME="Unlock"><procedure>Unlock</procedure></A> (rd: T) RAISES {} =
  BEGIN
    Thread.Release (rd)
  END Unlock;

PROCEDURE <A NAME="LengthDefault"><procedure>LengthDefault</procedure></A> (&lt;*UNUSED*&gt; rd: T): INTEGER RAISES {} =
  BEGIN
    &lt;*NOWARN*&gt; Die()
  END LengthDefault;

PROCEDURE <A NAME="CloseDefault"><procedure>CloseDefault</procedure></A>(&lt;*UNUSED*&gt; rd: T) RAISES {} =
  BEGIN END CloseDefault;

EXCEPTION FatalError;

PROCEDURE <A NAME="Die"><procedure>Die</procedure></A>() =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError;
  END Die;

BEGIN
END RdMove.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
