<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/RdUtils.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/RdUtils.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="RdUtils.m3">RdUtils</A></interface>;

IMPORT <A HREF="Rd.i3">Rd</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../../libm3/derived/AtomList.i3">AtomList</A>;

PROCEDURE <A HREF="RdUtils.m3#Find">Find</A> (rd: Rd.T; pattern: TEXT; canonicalize: Canonicalize := NIL):
  [-1 .. LAST(CARDINAL)] RAISES {Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Finds the first occurrence of pattern, reading forward from the current
   position of rd. If no match is found, Find returns -1 and leaves rd
   positioned at the end. If Rd.Failure, or Thread.Alerted is raised
   while reading characters from rd, the exception propagates through to
   the caller of Find and the position of rd is undefined. If a match is
   found, Find returns the index of the first character of the match and
   leaves rd positioned to read the character following the match. A null
   pattern causes an instant match, with no advancement of rd. If
   canonicalize is set, Find uses canonicalize to map characters
   in both rd and pattern into a connonical form.  See IgnoreASCIICase
   below.
<P>
   This uses a pretty poor algorithm and demands that the reader be seekable.
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RdUtils.m3#FindString">FindString</A> (         rd          : Rd.T;
                      READONLY pattern     : ARRAY OF CHAR;
                               canonicalize: Canonicalize    := NIL):
  [-1 .. LAST(CARDINAL)] RAISES {Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> = Find(rd, Text.FromSub(pattern), canonicalize). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RdUtils.m3#FindChar">FindChar</A> (rd          : Rd.T;
                    pattern     : CHAR;
                    canonicalize: Canonicalize := NIL):
  [-1 .. LAST(CARDINAL)] RAISES {Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> = Find(rd, Text.FromChar(pattern), canonicalize). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="RdUtils.m3#FailureText">FailureText</A> (f: AtomList.T): TEXT;
</PRE><BLOCKQUOTE><EM> Rd.i3 says: <CODE>EXCEPTION Failure (AtomList.T)</CODE>.
<P>
   FailureText returns a text describing the failure <CODE>f</CODE>.
   Returns either <CODE>NIL</CODE> or the names of the Atom.ToText of each
   element of this list separated by colons.
   </EM></BLOCKQUOTE><PRE>

TYPE
  Canonicalize = PROCEDURE(ch: CHAR): CHAR;

PROCEDURE <A HREF="RdUtils.m3#ToUpperCaseASCII">ToUpperCaseASCII</A>(ch: CHAR): CHAR;
  (* Converts ASCII lower case characters to upper case, returns all
     other characters unchanged.  See ASCII.i3. *)

END RdUtils.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
