<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/Stdio.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/Stdio.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>Stdio</CODE> provides streams for standard input, standard output, and
   standard error. These streams correspond to file handles returned
   by the <CODE>GetStandardFileHandles</CODE> procedure in the <CODE>Process</CODE> interface.
   \index{standard I/O!streams}


<P><PRE>INTERFACE <interface><A HREF="Stdio.m3">Stdio</A></interface>;

IMPORT <A HREF="Rd.i3">Rd</A>, <A HREF="Wr.i3">Wr</A>;

VAR
  stdin: Rd.T;
  stdout: Wr.T;
  stderr: Wr.T;
  bufferedStderr: Wr.T;

END Stdio.
</PRE> The initialization of these streams depends on the underlying
   operating system.
<P>
   If the standard error stream is directed to a terminal, it will be
   unbuffered, so that explicit <CODE>Wr.Flush</CODE> calls are unnecessary for
   interactive programs.  A buffered version of the standard error
   stream is also provided, but programs should not use both <CODE>stderr</CODE>
   and <CODE>bufferedStderr</CODE>.
<P>
   If the streams are directed to or from random-access files, they
   will be seekable.
<P>
   It is possible that <CODE>stderr</CODE> is equal to <CODE>stdout</CODE>.  Therefore,
   programs that perform seek operations on <CODE>stdout</CODE> should take care
   not to destroy output data when writing error messages. 

<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
