<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/Stdio.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/Stdio.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Stdio.i3">Stdio</A></implements></module>;

IMPORT <A HREF="../../../os/src/Common/File.i3">File</A>, <A HREF="FileRd.i3">FileRd</A>, <A HREF="FileWr.i3">FileWr</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../os/src/Common/Process.i3">Process</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="Wr.i3">Wr</A>, <A HREF="WrClass.i3">WrClass</A>;
</PRE>****************************************************************
  The shutdown routine used to call Unsafe{Rd,Wr}.FastClose to
  flush and close the streams.  But, it's an error to close the
  file descriptors that we did't open.  So, we'll just flush.
PROCEDURE ShutDown () =
  &lt;* FATAL Thread.Alerted *&gt; 
  BEGIN
    IF stdin # NIL THEN
      TRY UnsafeRd.FastClose (stdin); EXCEPT Rd.Failure =&gt; END;
    END;
    IF stdout # NIL THEN
      TRY UnsafeWr.FastClose (stdout); EXCEPT Wr.Failure =&gt; END;
    END;
    IF stderr # NIL THEN
      TRY UnsafeWr.FastClose (stderr); EXCEPT Wr.Failure =&gt; END;
    END;
  END ShutDown;
*********************************************************************

<P><PRE>PROCEDURE <A NAME="ShutDown"><procedure>ShutDown</procedure></A> () =
  (* Note that this routine is unsafe.  It calls flush methods
     without acquiring the locks.  We don't acquire the locks
     because it can cause a deadlock when we're trying to
     crash the program from an arbitrary state. *)
  BEGIN
    TRY
      IF (stdout # NIL) AND (NOT stdout.closed) THEN stdout.flush (); END;
      IF (stderr # NIL) AND (NOT stderr.closed) THEN stderr.flush (); END;
    EXCEPT Thread.Alerted, Wr.Failure =&gt;
      (* oh well, we tried. *)
    END;
  END ShutDown;

BEGIN
  stdin  := NIL;
  stdout := NIL;
  stderr := NIL;
  bufferedStderr := NIL;

  &lt;*FATAL OSError.E*&gt;
  VAR hIn, hOut, hErr: File.T;
  BEGIN
    Process.GetStandardFileHandles(stdin:=hIn, stdout:=hOut, stderr:=hErr);
    IF hIn # NIL THEN
      stdin := NEW(FileRd.T).init(hIn);
    END;
    IF hOut # NIL THEN
      stdout := NEW(FileWr.T).init(hOut, buffered := TRUE);
    END;
    IF hErr # NIL THEN
      stderr := NEW(FileWr.T).init(hErr, buffered := FALSE);
      bufferedStderr := NEW(FileWr.T).init(hErr, buffered := TRUE);
    END;
  END;

  Process.RegisterExitor (ShutDown);
END Stdio.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
