<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/TextRd.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/TextRd.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="TextRd.i3">TextRd</A></implements></module>;

IMPORT <A HREF="RdClass.i3">RdClass</A>, <A HREF="../../../text/src/Text.i3">Text</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      OVERRIDES
        seek   := Seek;
        length := Length;
        init   := Init;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (rd: T; t: TEXT): T =
  VAR len := Text.Length (t);
  BEGIN
    IF (rd.buff = NIL) OR (len &gt; NUMBER (rd.buff^)) THEN
      rd.buff := NEW(REF ARRAY OF CHAR, len);
    END;
    Text.SetChars(rd.buff^, t);
    rd.st := 0;
    rd.lo := 0;
    rd.cur := 0;
    rd.hi := len;
    rd.closed := FALSE;
    rd.seekable := TRUE;
    rd.intermittent := FALSE;
    RETURN rd;
  END Init;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(t: TEXT): T = BEGIN RETURN NEW(T).init(t); END New;

PROCEDURE <A NAME="Seek"><procedure>Seek</procedure></A> (rd: T; pos: CARDINAL;
               &lt;*UNUSED*&gt; dontBlock: BOOLEAN): RdClass.SeekResult =
  BEGIN
    IF pos &gt;= rd.hi THEN
      rd.cur := rd.hi;
      RETURN RdClass.SeekResult.Eof;
    ELSE
      rd.cur := pos;
      RETURN RdClass.SeekResult.Ready; END;
  END Seek;

PROCEDURE <A NAME="Length"><procedure>Length</procedure></A> (rd: T): INTEGER =
  BEGIN
    RETURN rd.hi;
  END Length;

BEGIN
END TextRd.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
