<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/TextWr.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/TextWr.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> A <CODE>TextWr.T</CODE>, or text writer, is a writer the contents of whose
   internal buffer can be retrieved as a <CODE>TEXT</CODE>.  Retrieving the
   buffer resets the target to be empty.  Text writers are buffered,
   seekable, and never raise <CODE>Failure</CODE> or <CODE>Alerted</CODE>.  The fact that
   they are buffered is essentially unobservable, since there is no
   way for the client to access the target except through the text
   writer. 

<P><PRE>INTERFACE <interface><A HREF="TextWr.m3">TextWr</A></interface>;

IMPORT <A HREF="Wr.i3">Wr</A>;

TYPE
  <A HREF="TextWr.m3#T">T</A> &lt;: Public;
  Public = Wr.T OBJECT METHODS init(): T END;
</PRE> The call <CODE>wr.init()</CODE> initializes <CODE>wr</CODE> to be a seekable writer with
   <CODE>c(wr)</CODE> set to the empty sequence and <CODE>cur(wr)</CODE> to 0.  The
   writer has no upper bound on its length.

<P><PRE>PROCEDURE <A HREF="TextWr.m3#New">New</A>(): T;
</PRE><BLOCKQUOTE><EM> Equivalent to <CODE>NEW(T).init()</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextWr.m3#ToText">ToText</A>(wr: T): TEXT;
</PRE><BLOCKQUOTE><EM> Return <CODE>c(wr)</CODE>, resetting <CODE>c(wr)</CODE> to the empty sequence and
   <CODE>cur(wr)</CODE> to 0. </EM></BLOCKQUOTE><PRE>

END TextWr.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
