<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/UnsafeWr.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/UnsafeWr.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> The routines in the UnsafeWr and UnsafeRd interfaces are like the
corresponding routines in the Wr and Rd interfaces, but it is the
client's responsibility to lock the stream before calling them.  The
lock can be acquired once and held for several operations, which is
faster than acquiring the lock for each operation, and also makes the
whole group atomic.  Danger is the price of speed: it is an unchecked
runtime error to call one of these operations without locking the
stream.
<P>
The UnsafeWr interface also provides routines for formatted printing
of integers and reals.  Using them is more efficient but less
convenient than using the Fmt interface (described in the first
edition of the Modula-3 report.  For example, the statement
<P>
	Wr.PutText(wr, <CODE>Line </CODE> &amp; Fmt.Int(n) &amp; <CODE> of file </CODE> &amp; f)
<P>
could be replaced with the following faster code:
<P>
	LOCK wr DO
	  FastPutText(wr, <CODE>Line </CODE>);
	  FastPutInt (wr, n);
	  FastPutText(wr, <CODE> of file </CODE>);
	  FastPutText(wr, f)
  	END
<P>
If several threads are writing characters concurrently to the same
writer, treating each PutChar as an atomic action is likely to produce
inscrutable output---it is usually preferable if the units of
interleaving are whole lines, or even larger.  It is therefore
convenient as well as efficient to import UnsafeWr and use LOCK
clauses like the one above to make small groups of output atomic.  But
don't forget to acquire the lock! If you call one of the routines in
this interface without it, then the unsafe code in WrRep might crash
your program in a rubble of bits.  A historical note: the main public
interface to Modula-2+ writers used the unsafe, unmonitored routines.
Errors were fairly frequent, mostly because of concurrent calls to
Wr.Flush or Wr.Close, which often occur as implicit finalization
actions when the programmer doesn't expect them.  In the Modula-3
design we have therefore made the main interfaces safe.
<P>
Here is the interface: 

<P><PRE>INTERFACE <interface><A HREF="WrMove.m3">UnsafeWr</A></interface>;
IMPORT <A HREF="Wr.i3">Wr</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../../convert/src/Convert.i3">Convert</A>;
FROM <A HREF="../../../thread/src/Common/Thread.i3">Thread</A> IMPORT Alerted;
FROM <A HREF="Wr.i3">Wr</A> IMPORT Failure;

REVEAL
  Wr.T &lt;: Thread.Mutex;
</PRE> Thus an importer of UnsafeWr can write code like LOCK wr DO ... END.

<P>
<P><PRE>PROCEDURE <A HREF="WrMove.m3#FastPutChar">FastPutChar</A>(wr: Wr.T; ch: CHAR) RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Like Wr.PutChar, but wr must be locked (as in all routines in
the interface). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="WrMove.m3#FastPutText">FastPutText</A>(wr: Wr.T; t: TEXT) RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Like Wr.PutText. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="WrMove.m3#FastPutString">FastPutString</A>(wr: Wr.T; READONLY a: ARRAY OF CHAR)
  RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Like Wr.PutString. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="WrMove.m3#FastPutInt">FastPutInt</A>(wr: Wr.T; n: INTEGER; base: Convert.Base := 10)
  RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Like Wr.PutText(wr, Fmt.Int(n, base)). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="WrMove.m3#FastPutReal">FastPutReal</A>(
  wr: Wr.T;
  r: REAL;
  precision: CARDINAL := 6;
  style := Convert.Style.Mix)
  RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Like Wr.PutText(wr, Fmt.Real(wr, precision, style)). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="WrMove.m3#FastPutLongReal">FastPutLongReal</A>(
  wr: Wr.T;
  r: LONGREAL;
  precision: CARDINAL := 6;
  style := Convert.Style.Mix)
  RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Like Wr.PutText(wr, Fmt.LongReal(wr, precision, style)). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="WrMove.m3#FastClose">FastClose</A> (wr: Wr.T) RAISES {Failure, Alerted};

END UnsafeWr.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
