<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/Wr.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/Wr.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> A <CODE>Wr.T</CODE> (or ``writer'') is a character output stream.  The basic
   operation on a writer is <CODE>PutChar</CODE>, which extends a writer's
   character sequence by one character. Some writers (called
   ``seekable writers'') also allow overwriting in the middle of the
   sequence.  For example, writers to random access files are
   seekable, but writers to terminals and sequential files are not.
   \index{character output stream}
   \index{output stream}
   \index{stream!output}
   \index{writer}
<P>
   Writers can be (and usually are) buffered. This means that
   operations on the writer don't immediately affect the underlying
   target of the writer, but are saved up and performed later.  For
   example, a writer to a disk file is not likely to update the disk
   after each character.
<P>
   Abstractly, a writer <CODE>wr</CODE> consists of:
<P>
<PRE>
      len(wr)       <KBD>a non-negative integer</KBD>
      c(wr)         <KBD>a character sequence of length </KBD>len(wr)<KBD></KBD>
      cur(wr)       <KBD>an integer in the range </KBD>[0..len(wr)]<KBD></KBD>
      target(wr)    <KBD>a character sequence</KBD>
      closed(wr)    <KBD>a boolean</KBD>
      seekable(wr)  <KBD>a boolean</KBD>
      buffered(wr)  <KBD>a boolean</KBD>
</PRE>
   These values are generally not directly represented in the data
   fields of a writer object, but in principle they determine the
   state of the writer.
<P>
   The sequence <CODE>c(wr)</CODE> is zero-based: <CODE>c(wr)[i]</CODE> is valid for <CODE>i</CODE>
   from 0 through <CODE>len(wr)-1</CODE>.  The value of <CODE>cur(wr)</CODE> is the index of
   the character in <CODE>c(wr)</CODE> that will be replaced or appended by the
   next call to <CODE>PutChar</CODE>.  If <CODE>wr</CODE> is not seekable, then <CODE>cur(wr)</CODE> is
   always equal to <CODE>len(wr)</CODE>, since in this case all writing happens
   at the end.
<P>
   The difference between <CODE>c(wr)</CODE> and <CODE>target(wr)</CODE> reflects the
   buffering: if <CODE>wr</CODE> is not buffered, then <CODE>target(wr)</CODE> is updated to
   equal <CODE>c(wr)</CODE> after every operation; if <CODE>wr</CODE> is buffered, then
   updates to <CODE>target(wr)</CODE> can be delayed.  For example, in a writer
   to a file, <CODE>target(wr)</CODE> is the actual sequence of characters on the
   disk; in a writer to a terminal, <CODE>target(wr)</CODE> is the sequence of
   characters that have actually been transmitted.  (This sequence may
   not exist in any data structure, but it still exists abstractly.)
<P>
   If <CODE>wr</CODE> is buffered, then the assignment <CODE>target(wr) := c(wr)</CODE> can
   happen asynchronously at any time, although the procedures in this
   interface are atomic with respect to such assignments.
<P>
   Every writer is a monitor; that is, it contains an internal lock
   that is acquired and held for each operation in this interface, so
   that concurrent operations will appear atomic.  For faster,
   unmonitored access, see the <CODE>UnsafeWr</CODE> interface.
<P>
   If you are implementing a long-lived writer class, such as a pipe
   or TCP stream, the index of the writer may eventually overflow,
   causing the program to crash with a bounds fault.  We recommend
   that you provide an operation to reset the writer index, which the
   client can call periodically.
<P>
   It is useful to specify the effect of several of the procedures in
   this interface in terms of the action <CODE>PutC(wr, ch)</CODE>, which outputs
   the character <CODE>ch</CODE> to the writer <CODE>wr</CODE>:
<P>
<PRE>
      PutC(wr, ch) =
        IF closed(wr) THEN <KBD>Cause checked runtime error</KBD> END;
        IF cur(wr) = len(wr) THEN
          <KBD>Extend </KBD>c(wr)<KBD> by one character, incrementing </KBD>len(wr)<KBD></KBD>
        END;
        c(wr)[cur(wr)] := ch;
        INC(cur(wr));
</PRE>
   <CODE>PutC</CODE> is used only in specifying the interface; it is not a real
   procedure. 

<P><PRE>INTERFACE <interface><A HREF="#x1">Wr</A></interface>;

IMPORT <A HREF="../../../libm3/derived/AtomList.i3">AtomList</A>;
FROM <A HREF="../../../thread/src/Common/Thread.i3">Thread</A> IMPORT Alerted;

TYPE T &lt;: ROOT;

EXCEPTION Failure(AtomList.T);
</PRE> Since there are many classes of writers, there are many ways that a
   writer can break---for example, the network can go down, the disk
   can fill up, etc.  All problems of this sort are reported by
   raising the exception <CODE>Failure</CODE>.  The documentation of each writer
   class should specify what failures the class can raise and how they
   are encoded in the argument to <CODE>Failure</CODE>.
<P>
   Illegal operations (for example, writing to a closed writer) cause
   checked runtime errors. 

<P><PRE>VAR (*CONST*) EOL: TEXT;
</PRE><BLOCKQUOTE><EM> End of line. </EM></BLOCKQUOTE><PRE>
</PRE> On POSIX, <CODE>EOL</CODE> is {\tt "\n"}; on Win32,
   <CODE>EOL</CODE> is {\tt "\r\n"}. 

<P><PRE>PROCEDURE <A HREF="WrMove.m3#PutChar">PutChar</A>(wr: T; ch: CHAR) RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Output <CODE>ch</CODE> to <CODE>wr</CODE>.  More precisely, this is equivalent to: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      PutC(wr, ch); IF NOT buffered(wr) THEN Flush(wr) END

 </PRE>
Many operations on a writer can wait indefinitely.  For example,
   <CODE>PutChar</CODE> can wait if the user has suspended output to his
   terminal.  These waits can be alertable, so each procedure that
   might wait includes <CODE>Thread.Alerted</CODE> in its raises clause. 

<P><PRE>PROCEDURE <A HREF="WrMove.m3#PutText">PutText</A>(wr: T; t: TEXT) RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Output <CODE>t</CODE> to <CODE>wr</CODE>.  More precisely, this is equivalent to: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      FOR i := 0 TO Text.Length(t) - 1 DO
        PutC(wr, Text.GetChar(t, i))
      END;
      IF NOT buffered(wr) THEN Flush(wr) END
</PRE>
   except that, like all operations in this interface, it is atomic
   with respect to other operations in the interface. (It would be
   wrong to write <CODE>PutChar</CODE> instead of <CODE>PutC</CODE>, since <CODE>PutChar</CODE> always
   flushes if the writer is unbuffered.)


<P><PRE>PROCEDURE <A HREF="WrMove.m3#PutString">PutString</A>(wr: T; READONLY a: ARRAY OF CHAR)
  RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Output <CODE>a</CODE> to <CODE>wr</CODE>.  More precisely, other than the fact that this
   is atomic, it is equivalent to: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      FOR i := FIRST(a) TO LAST(a) DO PutC(wr, a[i]) END;
      IF NOT buffered(wr) THEN Flush(wr) END


<P><PRE>PROCEDURE <A HREF="WrMove.m3#Seek">Seek</A>(wr: T; n: CARDINAL) RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Set the current position of <CODE>wr</CODE> to <CODE>n</CODE>.  This is an error if <CODE>wr</CODE>
   is closed. More precisely, this is equivalent to: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      IF wr.closed OR NOT seekable(wr) THEN
        <KBD>Cause checked runtime error</KBD>
      END;
      cur(wr) := MIN(n, len(wr))


<P><PRE>PROCEDURE <A HREF="WrMove.m3#Flush">Flush</A>(wr: T) RAISES {Failure, Alerted};
</PRE><BLOCKQUOTE><EM> Perform all buffered operations.  That is, set <CODE>target(wr) :=
   c(wr)</CODE>.  It is a checked runtime error if <CODE>wr</CODE> is closed. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="WrMove.m3#Close">Close</A>(wr: T) RAISES {Failure, Alerted};
</PRE> Flush <CODE>wr</CODE>, release any resources associated with <CODE>wr</CODE>, and set
   <CODE>closed(wr) := TRUE</CODE>.  The documentation for a procedure that
   creates a writer should specify what resources are released when
   the writer is closed.  This leaves <CODE>closed(wr)</CODE> equal to <CODE>TRUE</CODE>
   even if it raises an exception, and is a no-op if <CODE>wr</CODE> is closed.
   

<P><PRE>PROCEDURE <A HREF="WrMove.m3#Length">Length</A>(wr: T): CARDINAL RAISES {Failure, Alerted};
PROCEDURE <A HREF="WrMove.m3#Index">Index</A>(wr: T): CARDINAL RAISES {};
PROCEDURE <A HREF="WrMove.m3#Seekable">Seekable</A>(wr: T): BOOLEAN RAISES {};
PROCEDURE <A HREF="WrMove.m3#Closed">Closed</A>(wr: T): BOOLEAN RAISES {};
PROCEDURE <A HREF="WrMove.m3#Buffered">Buffered</A>(wr: T): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> These procedures return <CODE>len(wr)</CODE>, <CODE>cur(wr)</CODE>, <CODE>seekable(wr)</CODE>,
   <CODE>closed(wr)</CODE>, and <CODE>buffered(wr)</CODE>, respectively. <CODE>Length</CODE> and
   <CODE>Index</CODE> cause a checked runtime error if <CODE>wr</CODE> is closed; the other
   three procedures do not. </EM></BLOCKQUOTE><PRE>

END Wr.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Wr's implementation  is in:
</A><UL>
<LI><A HREF="WrMove.m3#0TOP0">rw/src/Common/WrMove.m3</A>
<LI><A HREF="../POSIX/WrPosix.m3#0TOP0">rw/src/POSIX/WrPosix.m3</A>
<LI><A HREF="../WIN32/WrWin32.m3#0TOP0">rw/src/WIN32/WrWin32.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
