<HTML>
<HEAD>
<TITLE>SRC Modula-3: rw/src/Common/WrMove.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>rw/src/Common/WrMove.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>WrMove</module> EXPORTS <A HREF="Wr.i3"><implements>Wr</A></implements>, <A HREF="WrClass.i3"><implements>WrClass</A></implements>, <A HREF="UnsafeWr.i3"><implements>UnsafeWr</A></implements>;
IMPORT <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../../convert/src/Convert.i3">Convert</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../text/src/TextF.i3">TextF</A>;
FROM <A HREF="../../../thread/src/Common/Thread.i3">Thread</A> IMPORT Alerted;

REVEAL
  <A NAME="Private">Private</A> = Thread.Mutex BRANDED OBJECT END;
</PRE> FastPutChar and PutChar are identical except that PutChar acquires
   and releases the lock while FastPutChar assumes it is already held. 

<P> It is invariant that for a closed writer <CODE>wr</CODE>, <CODE>wr.buff = NIL</CODE> and
   <CODE>wr.lo = wr.hi</CODE>.  Therefore the check that <CODE>wr</CODE> is ready need
   not inspect <CODE>wr.closed</CODE> on the fast path. 

<P><PRE>PROCEDURE <A NAME="Lock"><procedure>Lock</procedure></A>(wr: T) RAISES {} =
  BEGIN
    Thread.Acquire(wr);
  END Lock;

PROCEDURE <A NAME="Unlock"><procedure>Unlock</procedure></A>(wr: T) =
  BEGIN
    Thread.Release(wr)
  END Unlock;

&lt;*INLINE*&gt;
PROCEDURE <A NAME="PutChar"><procedure>PutChar</procedure></A> (wr: T; ch: CHAR) RAISES {Failure, Alerted} =
  BEGIN
    LOCK wr DO
      IF wr.cur = wr.hi THEN DoSeek(wr) END;
      wr.buff[wr.st + wr.cur - wr.lo] := ch;
      INC(wr.cur);
      IF NOT wr.buffered THEN wr.flush(); END;
    END;
  END PutChar;

&lt;*INLINE*&gt;
PROCEDURE <A NAME="FastPutChar"><procedure>FastPutChar</procedure></A> (wr: T; ch: CHAR) RAISES {Failure, Alerted} =
  BEGIN
    IF wr.cur = wr.hi THEN DoSeek(wr) END;
    wr.buff[wr.st + wr.cur - wr.lo] := ch;
    INC(wr.cur);
    IF NOT wr.buffered THEN wr.flush(); END;
  END FastPutChar;

PROCEDURE <A NAME="DoSeek"><procedure>DoSeek</procedure></A> (wr: T) RAISES {Failure, Alerted} =
  BEGIN
    (* wr.cur = wr.hi here *)
    IF wr.closed THEN Die() END;
    wr.seek(wr.cur);
  END DoSeek;

PROCEDURE <A NAME="PutText"><procedure>PutText</procedure></A> (wr: T; t: TEXT) RAISES {Failure, Alerted} =
  BEGIN
    PutString (wr, SUBARRAY (t^, 0, Text.Length (t)));
  END PutText;

PROCEDURE <A NAME="FastPutText"><procedure>FastPutText</procedure></A> (wr:T; t: TEXT) RAISES {Failure, Alerted} =
  BEGIN
    FastPutString (wr, SUBARRAY (t^, 0, Text.Length (t)));
  END FastPutText;
</PRE> PutString and FastPutString are identical except that PutString acquires
   and releases the lock while FastPutString assumes it is already held. 

<P><PRE>&lt;*INLINE*&gt;
PROCEDURE <A NAME="PutString"><procedure>PutString</procedure></A> (wr: T; READONLY a: ARRAY OF CHAR)
  RAISES {Failure, Alerted} =
  BEGIN
    LOCK wr DO
      IF wr.closed THEN Die() END;
      wr.putString(a);
      IF NOT wr.buffered THEN wr.flush(); END;
    END;
  END PutString;

&lt;*INLINE*&gt;
PROCEDURE <A NAME="FastPutString"><procedure>FastPutString</procedure></A> (wr: T; READONLY a: ARRAY OF CHAR)
  RAISES {Failure, Alerted} =
  BEGIN
    IF wr.closed THEN Die() END;
    wr.putString(a);
    IF NOT wr.buffered THEN wr.flush(); END;
  END FastPutString;

PROCEDURE <A NAME="PutStringDefault"><procedure>PutStringDefault</procedure></A>(wr: T; READONLY a: ARRAY OF CHAR)
    RAISES {Failure, Alerted} =
  VAR
    start: CARDINAL := 0;
    l               := NUMBER(a);
  BEGIN
    WHILE (l &gt; 0) DO
      VAR n := MIN(wr.hi - wr.cur, l);
      BEGIN
        IF n &gt; 0 THEN
          SUBARRAY(wr.buff^, wr.st + wr.cur - wr.lo, n) :=
                     SUBARRAY(a, start, n);
          INC(start, n);
          DEC(l, n);
          INC(wr.cur, n);
        END;
      END;
      IF l &gt; 0 THEN wr.seek(wr.cur) END;
    END;
  END PutStringDefault;

PROCEDURE <A NAME="FastPutInt"><procedure>FastPutInt</procedure></A> (wr: T; n: INTEGER; base: Convert.Base := 10)
  RAISES {Failure, Alerted} =
  &lt;*FATAL Convert.Failed*&gt;
  VAR
    chars: ARRAY [0..BITSIZE(INTEGER) + 3] OF CHAR;
    size:  INTEGER;
  BEGIN
    size := Convert.FromInt (chars, n, base);
    FastPutString (wr, SUBARRAY (chars, 0, size));
  END FastPutInt;

PROCEDURE <A NAME="FastPutReal"><procedure>FastPutReal</procedure></A> (wr: T; r: REAL; p: CARDINAL := 6;
                       s := Convert.Style.Mix)
  RAISES {Failure, Alerted} =
  &lt;*FATAL Convert.Failed*&gt;
  VAR
    chars: ARRAY [0..100] OF CHAR;
    size:  INTEGER;
  BEGIN
    size := Convert.FromFloat (chars, r, p, s);
    FastPutString (wr, SUBARRAY (chars, 0, size));
  END FastPutReal;

PROCEDURE <A NAME="FastPutLongReal"><procedure>FastPutLongReal</procedure></A> (wr: T; r: LONGREAL; p: CARDINAL := 6;
                           s := Convert.Style.Mix)
  RAISES {Failure, Alerted} =
  &lt;*FATAL Convert.Failed*&gt;
  VAR
    chars: ARRAY [0..100] OF CHAR;
    size:  INTEGER;
  BEGIN
    size := Convert.FromLongFloat (chars, r, p, s);
    FastPutString (wr, SUBARRAY (chars, 0, size));
  END FastPutLongReal;

PROCEDURE <A NAME="Seek"><procedure>Seek</procedure></A>(wr: T; n: CARDINAL) RAISES {Failure, Alerted} =
  BEGIN
    LOCK wr DO
      IF wr.closed OR NOT wr.seekable THEN Die() END;
      wr.seek(n);
    END
  END Seek;

PROCEDURE <A NAME="Flush"><procedure>Flush</procedure></A> (wr: T) RAISES {Failure, Alerted} =
  BEGIN
    LOCK wr DO
      IF wr.closed THEN Die() END;
      wr.flush();
    END;
  END Flush;

PROCEDURE <A NAME="Index"><procedure>Index</procedure></A>(wr: T): CARDINAL RAISES {} =
  BEGIN
    LOCK wr DO
      IF wr.closed THEN Die() END;
      RETURN wr.cur;
    END
  END Index;

PROCEDURE <A NAME="Length"><procedure>Length</procedure></A> (wr: T): CARDINAL RAISES {Failure, Alerted} =
  BEGIN
    LOCK wr DO
      IF wr.closed THEN Die() END;
      RETURN wr.length ();
    END
  END Length;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A> (wr: T) RAISES {Failure, Alerted} =
  BEGIN
    LOCK wr DO FastClose (wr); END;
  END Close;

PROCEDURE <A NAME="FastClose"><procedure>FastClose</procedure></A> (wr: T) RAISES {Failure, Alerted} =
  BEGIN
    IF NOT wr.closed THEN
      TRY
        wr.flush();
        wr.close();
      FINALLY
        wr.closed := TRUE;
        wr.cur := wr.hi;
        wr.lo := wr.hi;
        wr.buff := NIL
      END
    END
  END FastClose;

PROCEDURE <A NAME="Seekable"><procedure>Seekable</procedure></A> (wr: T): BOOLEAN RAISES {} =
  BEGIN
    LOCK wr DO
      RETURN wr.seekable
    END
  END Seekable;

PROCEDURE <A NAME="Closed"><procedure>Closed</procedure></A>(wr: T): BOOLEAN RAISES {} =
  BEGIN
    LOCK wr DO
      RETURN wr.closed;
    END
  END Closed;

PROCEDURE <A NAME="Buffered"><procedure>Buffered</procedure></A>(wr: T): BOOLEAN RAISES {} =
  BEGIN
    LOCK wr DO
      RETURN wr.buffered;
    END
  END Buffered;

PROCEDURE <A NAME="CloseDefault"><procedure>CloseDefault</procedure></A>(&lt;*UNUSED*&gt; wr: T) RAISES {} =
  BEGIN
  END CloseDefault;

PROCEDURE <A NAME="FlushDefault"><procedure>FlushDefault</procedure></A> (&lt;*UNUSED*&gt; wr: T) RAISES {} =
  BEGIN
  END FlushDefault;

PROCEDURE <A NAME="LengthDefault"><procedure>LengthDefault</procedure></A>(wr: T): CARDINAL RAISES {} =
  BEGIN
    RETURN wr.cur;
  END LengthDefault;

EXCEPTION FatalError;

PROCEDURE <A NAME="Die"><procedure>Die</procedure></A>() =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError;
  END Die;

BEGIN
END WrMove.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
