<HTML>
<HEAD>
<TITLE>SRC Modula-3: sequence/src/Sequence.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>sequence/src/Sequence.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA SPEC*&gt;
</PRE> <CODE>Sequence</CODE> is a generic interface defining extensible sequences.
   Elements can be added or removed at either end of a sequence; they
   can also be accessed or updated at specified indexes.  The expected
   cost of every method of a sequence is constant.
   \index{stack: {\tt Sequence} generic interface}
   \index{queue: {\tt Sequence} generic interface}
   \index{deque: {\tt Sequence} generic interface}


<P><PRE>GENERIC INTERFACE <genericInterface><A HREF="Sequence.mg">Sequence</A></genericInterface>(Elem);
</PRE><BLOCKQUOTE><EM> Where <CODE>Elem.T</CODE> is a type that is not an open array type and <CODE>Elem</CODE>
   contains
<P>
<PRE>
      CONST Brand = &lt;text-constant&gt;;
</PRE>
   <CODE>Brand</CODE> must be a text constant. It will be used to construct a brand for
   the opaque type <CODE>Sequence.T</CODE> and any generic types instantiated with the
   <CODE>Sequence</CODE> interface. For a non-generic interface, we recommend choosing
   the name of the interface.
</EM></BLOCKQUOTE><PRE>

CONST
  Brand = &quot;(Sequence &quot; &amp; Elem.Brand &amp; &quot;)&quot;;

TYPE
  <A HREF="Sequence.mg#T">T</A> &lt;: Public;
  Public = OBJECT METHODS
    init(sizeHint: CARDINAL := 5): T;
    fromArray(READONLY a: ARRAY OF Elem.T): T;
    addhi(READONLY x: Elem.T);
    addlo(READONLY x: Elem.T);
    remhi(): Elem.T;
    remlo(): Elem.T;
    put(i: CARDINAL; READONLY x: Elem.T);
    size(): CARDINAL;
    gethi(): Elem.T;
    getlo(): Elem.T;
    get(i: CARDINAL): Elem.T
  END;
</PRE> A <CODE>Sequence(Elem).T</CODE> (or just a {\it sequence}) represents an
   extensible sequence of <CODE>Elem.T</CODE>s.  
     <P>
   The first group of methods have side effects on the sequence.  The
   call
<P>
<PRE>
      s.init(sizeHint)
</PRE>
   initializes <CODE>s</CODE> to be the empty sequence.  Furthermore <CODE>init</CODE>
   assumes that at least <CODE>sizeHint</CODE> elements will be added to the
   sequence; these operations may be executed more efficiently than if
   <CODE>sizeHint</CODE> was defaulted.  The call
<P>
<PRE>
      s.fromArray(a)
</PRE>
   initializes <CODE>s</CODE> to be the sequence with elements
   <CODE>a[0],~...,~a[LAST(a)]</CODE>.  The call
<P>
<PRE>
      s.addhi(x)
</PRE>
   appends <CODE>x</CODE> to the end of <CODE>s</CODE>.  Thus it does not change the index
   of any existing element.  The call
<P>
<PRE>
      s.addlo(x)
</PRE>
   appends <CODE>x</CODE> to the front of <CODE>s</CODE>.  Thus it increases the index of
   all existing elements by one. The call
  <P>
<PRE>
      s.remhi()
</PRE>
   removes and returns the last element of <CODE>s</CODE>.  Thus it does not
   change the index of any of <CODE>s</CODE>'s other elements.  If <CODE>s</CODE> is empty,
   <CODE>s.remhi()</CODE> causes a checked runtime error.  The call
<P>
<PRE>
      s.remlo()
</PRE>
   removes and returns the first element of <CODE>s</CODE>.  Thus it decreases
   the index of all other elements of <CODE>s</CODE> by one. If <CODE>s</CODE> is empty,
   <CODE>s.remlo()</CODE> causes a checked runtime error.  The call
<P>
<PRE>
      s.put(i, x)
</PRE>
   replaces element <CODE>i</CODE> of <CODE>s</CODE> with <CODE>x</CODE>.  Element <CODE>0</CODE> is the first
   element. It is a checked runtime error unless <CODE>i</CODE> is less than
   <CODE>s.size()</CODE>.
<P>
   The second group of methods have no side effect on the sequence.
   The call
<P>
<PRE>
      s.size()
</PRE>
   returns the number of elements in <CODE>s</CODE>.  The call
<P>
<PRE>
      s.get(i)
</PRE>
   returns element <CODE>i</CODE> of <CODE>s</CODE>. It is a checked runtime error unless
   <CODE>i</CODE> is less than <CODE>s.size()</CODE>.  The call
<P>
<PRE>
      s.gethi()
</PRE>
   returns the last element of <CODE>s</CODE>; that is, it is equivalent to
   <CODE>s.get(s.size()-1)</CODE>.  The call
<P>
<PRE>
      s.getlo()
</PRE>
   returns the first element of <CODE>s</CODE>; that is, it is equivalent to
   <CODE>s.get(0)</CODE>. 

<P><PRE>PROCEDURE <A HREF="Sequence.mg#Cat">Cat</A>(s, t: T): T;
</PRE><BLOCKQUOTE><EM> Return a sequence whose elements are the concatenation of <CODE>s</CODE>
   and <CODE>t</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Sequence.mg#Sub">Sub</A>(s: T; start: CARDINAL;
    length: CARDINAL := LAST(CARDINAL)): T;
</PRE><BLOCKQUOTE><EM> Return a sub-sequence of <CODE>s</CODE>: empty if <CODE>start &gt;= t.size()</CODE> or
   <CODE>length = 0</CODE>; otherwise the subsequence ranging from <CODE>start</CODE> to the
   minimum of <CODE>start+length-1</CODE> and <CODE>s.size()-1</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Cat</CODE> and <CODE>Sub</CODE> create new sequences; they have no side-effects.
<P>
\smallskip
   Sequences are unmonitored: a client accessing a sequence from
   multiple threads must ensure that if two operations are active
   concurrently, then neither of them has side effects on the
   sequence.  

<P> ESC Specifications. 

<P><PRE>&lt;*SPEC VAR Valid: MAP T TO BOOLEAN *&gt;
&lt;*SPEC VAR Data: MAP T TO SEQ[Elem.T]*&gt;

&lt;*SPEC T.init(t, sizeHint)
       MODIFIES Valid[t], Data[t]
       ENSURES RES = t AND Valid'[t] AND NUMBER(Data'[t]) = 0 *&gt;

&lt;*SPEC T.fromArray(t, a)
       MODIFIES Valid[t], Data[t]
       ENSURES RES = t AND Valid'[t] AND NUMBER(Data'[t]) = NUMBER(a)
           AND (ALL [i: INTEGER] (0 &lt;= i AND i &lt; NUMBER(a)) IMPLIES
                                 Data'[t][i] = a[i]) *&gt;

&lt;*SPEC T.addhi(t, x)
       MODIFIES Data[t]
       REQUIRES Valid[t]
       ENSURES NUMBER(Data'[t]) = NUMBER(Data[t])+1
           AND (ALL [i: INTEGER] 0 &lt;= i AND i &lt; NUMBER(Data[t]) IMPLIES
                  Data'[t][i] = Data[t][i])
           AND Data'[t][NUMBER(Data[t])] = x *&gt;

&lt;*SPEC T.addlo(t, x)
       MODIFIES Data[t]
       REQUIRES Valid[t]
       ENSURES NUMBER(Data'[t]) = NUMBER(Data[t])+1
           AND Data'[t][0] = x
           AND (ALL [i: CARDINAL] (0 &lt;= i AND i &lt; NUMBER(Data[t])) IMPLIES
                  Data'[t][i+1] = Data[t][i]) *&gt;

&lt;*SPEC T.remhi(t)
       MODIFIES Data[t]
       REQUIRES Valid[t] AND NUMBER(Data[t]) &gt; 0
       ENSURES NUMBER(Data'[t]) = NUMBER(Data[t])-1
           AND (ALL [i: INTEGER] (0 &lt;= i AND i &lt; NUMBER(Data'[t])) IMPLIES
                  Data'[t][i] = Data[t][i]) *&gt;

&lt;*SPEC T.remlo(t)
       MODIFIES Data[t]
       REQUIRES Valid[t] AND NUMBER(Data[t]) &gt; 0
       ENSURES NUMBER(Data'[t]) = NUMBER(Data[t])-1
           AND (ALL [i: INTEGER] (0 &lt;= i AND i &lt; NUMBER(Data'[t])) IMPLIES
                  Data'[t][i] = Data[t][i+1]) *&gt;

&lt;*SPEC T.put(t, i, x)
       MODIFIES Data[t][i]
       REQUIRES Valid[t] AND i &lt; NUMBER(Data[t])
       ENSURES Data'[t][i] = x
*&gt;
</PRE><BLOCKQUOTE><EM><P>
       ENSURES Data'[t][i] = x AND NUMBER(Data'[t]) = NUMBER(Data[t]) *&gt;
</EM></BLOCKQUOTE><PRE>

&lt;*SPEC T.size(t)
       REQUIRES Valid[t]
       ENSURES RES = NUMBER(Data[t]) *&gt;

&lt;*SPEC T.gethi(t)
       REQUIRES Valid[t] AND NUMBER(Data[t]) &gt; 0
       ENSURES RES = Data[t][NUMBER(Data[t])-1] *&gt;

&lt;*SPEC T.getlo(t)
       REQUIRES Valid[t] AND NUMBER(Data[t]) &gt; 0
       ENSURES RES = Data[t][0] *&gt;

&lt;*SPEC T.get(t, i)
       REQUIRES Valid[t] AND i &lt; NUMBER(Data[t])
       ENSURES RES = Data[t][i] *&gt;

&lt;*SPEC Cat(s, t)
       MODIFIES Data[RES], Valid[RES]
       REQUIRES Valid[s] AND Valid[t]
       ENSURES FRESH(RES) AND Valid'[RES]
           AND (ALL [i: INTEGER]
                 (0 &lt;= i AND i &lt; NUMBER(Data'[RES])) IMPLIES
                    Data'[RES][i] = CONCAT(Data[s], Data[t])[i])
*&gt;

&lt;*SPEC Sub(s, start, length)
       MODIFIES Data[RES], Valid[RES]
       REQUIRES Valid[s]
       ENSURES Valid'[RES] AND FRESH(RES) AND
               (ALL [i: INTEGER]
                 (0 &lt;= i AND i &lt; MIN(length, NUMBER(Data[s]) - start)) IMPLIES
                    Data'[RES][i] = SUBARRAY(Data[s],
                                             MAX(0, MIN(start,
                                                        NUMBER(Data[s])-1)),
                                             MIN(length, NUMBER(Data[s])
                                                         -start))[i])
*&gt;

END Sequence.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
