<HTML>
<HEAD>
<TITLE>SRC Modula-3: sequence/src/Sequence.mg</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>sequence/src/Sequence.mg</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA SPEC, LOOPINV*&gt;

GENERIC MODULE <genericModule><A HREF="Sequence.ig">Sequence</A></genericModule>(Elem, Seq, Rep);
</PRE><BLOCKQUOTE><EM> Where <CODE>Seq = Sequence(Elem)</CODE> and <CODE>Rep = SequenceRep(Elem, Seq)</CODE>. </EM></BLOCKQUOTE><PRE>

REVEAL Seq.<A NAME="T">T</A> = Rep.Public BRANDED Seq.Brand OBJECT
  OVERRIDES
    init := Init;
    fromArray := FromArray;
    addhi := Addhi;
    addlo := Addlo;
    remhi := Remhi;
    remlo := Remlo;
    put := Put;
    size := Size;
    gethi := Gethi;
    getlo := Getlo;
    get := Get
  END;

VAR zero: Elem.T;
</PRE><BLOCKQUOTE><EM> Modula-3 requires <CODE>zero</CODE> to be initialized to a value of type <CODE>Elem.T</CODE>.
   With high probability the references within that value will be NIL.
   Hence, setting elements of the sequence to <CODE>zero</CODE> should avoid
   storage leaks. </EM></BLOCKQUOTE><PRE>

&lt;*SPEC INVARIANT (ALL [t1: Seq.T, t2: Seq.T]
                    t1 # t2 IMPLIES t1.elem # t2.elem) *&gt;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(s: Seq.T; sizeHint: CARDINAL): Seq.T =
  BEGIN
    IF s.elem = NIL OR NUMBER(s.elem^) = 0 THEN
      s.elem := NEW(Rep.RefArray, MAX(sizeHint, 1))
    END (* IF *);
    s.sz := 0; s.st := 0;
    RETURN s
  END Init;

PROCEDURE <A NAME="FromArray"><procedure>FromArray</procedure></A>(s: Seq.T; READONLY a: ARRAY OF Elem.T): Seq.T =
  &lt;*SPEC LET numA := NUMBER(a)*&gt;
  &lt;*SPEC LET raPre := Rep.RefArray *&gt;
  BEGIN
    s.sz := NUMBER(a);
    s.st := 0;
    s.elem := NEW(Rep.RefArray, MAX(s.sz, 1));
    FOR i := 0 TO s.sz-1 DO
      &lt;*LOOPINV (ALL [j: INTEGER]
                   (0 &lt;= j AND j &lt; i) IMPLIES s.elem^[j] = a[j])
                AND NUMBER(s.elem^) = numA
                AND (ALL [r: Rep.RefArray]
                        Rep.RefArray[r] = raPre[r] OR r = s.elem) *&gt;
      s.elem[i] := a[i]
    END;
    RETURN s
  END FromArray;

PROCEDURE <A NAME="Addhi"><procedure>Addhi</procedure></A>(s: Seq.T; READONLY x: Elem.T) =
  BEGIN
    IF s.sz = NUMBER(s.elem^) THEN Expand(s) END;
    VAR i := s.st + s.sz; BEGIN
      IF i &gt;= NUMBER(s.elem^) THEN i := i - NUMBER(s.elem^) END;
      s.elem[i] := x
    END;
    INC(s.sz)
  END Addhi;

PROCEDURE <A NAME="Addlo"><procedure>Addlo</procedure></A>(s: Seq.T; READONLY x: Elem.T) =
  BEGIN
    IF s.sz = NUMBER(s.elem^) THEN Expand(s) END;
    VAR i := s.st; BEGIN
      IF i = 0 THEN i := LAST(s.elem^) ELSE i := i - 1 END;
      s.elem[i] := x;
      s.st := i
    END;
    INC(s.sz)
  END Addlo;

PROCEDURE <A NAME="Expand"><procedure>Expand</procedure></A>(s: Seq.T) =
  VAR
    n := NUMBER(s.elem^);
    new := NEW(Rep.RefArray, 2 * n);
    m := n - s.st;
  BEGIN
    SUBARRAY(new^, 0, m) := SUBARRAY(s.elem^, s.st, m);
    SUBARRAY(new^, m, s.st) :=
      SUBARRAY(s.elem^, 0, s.st);
    s.st := 0;
    s.elem := new
   END Expand;

PROCEDURE <A NAME="Remhi"><procedure>Remhi</procedure></A>(s: Seq.T): Elem.T =
  VAR
    j := s.st + s.sz - 1;
    res: Elem.T;
  BEGIN
    IF j &gt;= NUMBER(s.elem^) THEN j := j - NUMBER(s.elem^) END;
    DEC(s.sz);
    WITH z = s.elem[j] DO  res := z;  z := zero;  END;
    RETURN res;
  END Remhi;

PROCEDURE <A NAME="Remlo"><procedure>Remlo</procedure></A>(s: Seq.T): Elem.T =
  VAR res: Elem.T;
  BEGIN
    WITH z = s.elem[s.st] DO  res := z;  z := zero;  END;
    DEC(s.sz);
    INC(s.st);
    IF s.st = NUMBER(s.elem^) THEN s.st := 0 END;
    RETURN res
  END Remlo;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A>(s: Seq.T; i: CARDINAL; READONLY x: Elem.T) =
  VAR j := s.st + i; BEGIN
    &lt;* ASSERT i &lt; s.sz *&gt;
    IF j &gt;= NUMBER(s.elem^) THEN j := j - NUMBER(s.elem^) END;
    s.elem[j] := x
  END Put;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(s: Seq.T; i: CARDINAL): Elem.T =
  VAR j := s.st + i; BEGIN
    &lt;* ASSERT i &lt; s.sz *&gt;
    IF j &gt;= NUMBER(s.elem^) THEN j := j - NUMBER(s.elem^) END;
    RETURN s.elem[j]
  END Get;

PROCEDURE <A NAME="Size"><procedure>Size</procedure></A>(s: Seq.T): CARDINAL =
  BEGIN
    RETURN s.sz
  END Size;

PROCEDURE <A NAME="Gethi"><procedure>Gethi</procedure></A>(s: Seq.T): Elem.T =
  VAR j := s.st + s.sz - 1; BEGIN
    &lt;* ASSERT s.sz &gt; 0 *&gt;
    IF j &gt;= NUMBER(s.elem^) THEN
      j := j - NUMBER(s.elem^)
    END;
    RETURN s.elem[j]
  END Gethi;

PROCEDURE <A NAME="Getlo"><procedure>Getlo</procedure></A>(s: Seq.T): Elem.T =
  BEGIN
    &lt;* ASSERT s.sz &gt; 0 *&gt;
    RETURN s.elem[s.st]
  END Getlo;

PROCEDURE <A NAME="Cat"><procedure>Cat</procedure></A>(s, t: T): T =
  VAR u := NEW(Seq.T);
      &lt;*SPEC LET raPre := Rep.RefArray *&gt;
      &lt;*SPEC LET dPreS := Data[s] *&gt;
      &lt;*SPEC LET dPreT := Data[t] *&gt;
  BEGIN
    u.sz := s.sz + t.sz;
    u.elem := NEW(Rep.RefArray, MAX(u.sz, 1));
    FOR i := 0 TO s.sz-1 DO
      &lt;*LOOPINV NUMBER(u.elem^) = MAX(u.sz, 1)
            AND (ALL [x: Rep.RefArray]
                     Rep.RefArray[x] = raPre[x] OR x = u.elem)
            AND (ALL [j: INTEGER] (0 &lt;= j AND j &lt; i) IMPLIES
                   u.elem^[j] = Rep.Abs(raPre[s.elem], s.st, s.sz)[j]) *&gt;
      u.elem[i] := s.get(i)
    END;
    FOR i := 0 TO t.sz-1 DO
      &lt;*LOOPINV NUMBER(u.elem^) = MAX(u.sz, 1)
            AND (ALL [x: Rep.RefArray]
                     Rep.RefArray[x] = raPre[x] OR x = u.elem)
            AND (ALL [j: INTEGER] (0 &lt;= j AND j &lt; s.sz) IMPLIES
                   u.elem^[j] = dPreS[j])
                AND
                (ALL [j: INTEGER] (0 &lt;= j AND j &lt; i) IMPLIES
                   u.elem^[j + s.sz] = dPreT[j]) *&gt;
      u.elem[i + s.sz] := t.get(i)
    END;
    RETURN u
  END Cat;

PROCEDURE <A NAME="Sub"><procedure>Sub</procedure></A>(s: T; start: CARDINAL;
    length: CARDINAL := LAST(CARDINAL)): T =
  VAR u := NEW(Seq.T);
      &lt;*SPEC LET raPre := Rep.RefArray *&gt;
      &lt;*SPEC LET dPreS := Data[s] *&gt;
  BEGIN
    IF start &gt;= s.sz OR length = 0 THEN
      u.sz := 0
    ELSE
      u.sz := MIN(length, s.sz - start)
    END;
    u.elem := NEW(Rep.RefArray, MAX(u.sz, 1));
    FOR i := 0 TO u.sz-1 DO
      &lt;*LOOPINV NUMBER(u.elem^) = MAX(u.sz, 1)
            AND (ALL [x: Rep.RefArray]
                     Rep.RefArray[x] = raPre[x] OR x = u.elem)
            AND (ALL [j: INTEGER] (0 &lt;= j AND j &lt; i) IMPLIES
                   u.elem^[j] = dPreS[start + j]) *&gt;
      u.elem[i] := s.get(start + i)
    END;
    RETURN u
  END Sub;
</PRE> ESC specs... 
<PRE>&lt;*SPEC Init(s, sizeHint)
       MODIFIES Valid[s], Data[s]
       REQUIRES s # NIL
       ENSURES RES = s AND Valid'[s] AND NUMBER(Data'[s]) = 0
*&gt;

&lt;*SPEC FromArray(s, a)
       MODIFIES Valid[s], Data[s]
       REQUIRES s # NIL
       ENSURES RES = s AND Valid'[s] AND NUMBER(Data'[s]) = NUMBER(a)
           AND (ALL [i: INTEGER] (0 &lt;= i AND i &lt; NUMBER(a)) IMPLIES
                                 Data'[s][i] = a[i])
*&gt;

&lt;*SPEC Addhi(s, x)
       MODIFIES Valid[s], Data[s]
       REQUIRES Valid[s] AND s # NIL
       ENSURES Valid'[s]
           AND NUMBER(Data'[s]) = NUMBER(Data[s])+1
           AND (ALL [i: INTEGER] 0 &lt;= i AND i &lt; NUMBER(Data[s]) IMPLIES
                  Data'[s][i] = Data[s][i])
           AND Data'[s][NUMBER(Data[s])] = x
*&gt;

&lt;*SPEC Addlo(s, x)
       MODIFIES Valid[s], Data[s]
       REQUIRES Valid[s] AND s # NIL
       ENSURES Valid'[s]
           AND NUMBER(Data'[s]) = NUMBER(Data[s])+1
           AND Data'[s][0] = x
           AND (ALL [i: CARDINAL]
                 (0 &lt;= i AND i &lt; NUMBER(Data[s])) IMPLIES
                    Data'[s][i+1] = Data[s][i])
*&gt;

&lt;*SPEC Expand(s)
       MODIFIES Valid[s], Data[s]
       REQUIRES Valid[s]
       ENSURES Valid'[s]
           AND s.st' = 0 AND s.sz' = s.sz
           AND NUMBER(s.elem'^') &gt; NUMBER(s.elem^)
           AND (ALL [i: INTEGER] (0 &lt;= i AND i &lt; NUMBER(Data[s])) IMPLIES
                  Data'[s][i] = Data[s][i])
           AND FRESH(s.elem')
*&gt;

&lt;*SPEC Remhi(s)
       MODIFIES Valid[s], Data[s]
       REQUIRES s # NIL AND Valid[s] AND NUMBER(Data[s]) &gt; 0
       ENSURES Valid'[s] AND NUMBER(Data'[s]) = NUMBER(Data[s])-1
           AND (ALL [i: INTEGER] (0 &lt;= i AND i &lt; NUMBER(Data'[s])) IMPLIES
                  Data'[s][i] = Data[s][i])
*&gt;

&lt;*SPEC Remlo(s)
       MODIFIES Valid[s], Data[s]
       REQUIRES s # NIL AND Valid[s] AND NUMBER(Data[s]) &gt; 0
       ENSURES Valid'[s] AND NUMBER(Data'[s]) = NUMBER(Data[s])-1
           AND (ALL [i: INTEGER] (0 &lt;= i AND i &lt; NUMBER(Data'[s])) IMPLIES
                  Data'[s][i] = Data[s][i+1])
*&gt;

&lt;*SPEC Put(s, i, x)
       MODIFIES Valid[s], Data[s][i]
       REQUIRES s # NIL AND Valid[s] AND i &lt; NUMBER(Data[s])
       ENSURES Valid'[s] AND Data'[s][i] = x
           AND NUMBER(Data'[s]) = NUMBER(Data[s])
*&gt;

&lt;*SPEC Size(s)
       REQUIRES s # NIL AND Valid[s]
       ENSURES RES = NUMBER(Data[s])
*&gt;

&lt;*SPEC Gethi(s)
       REQUIRES s # NIL AND Valid[s] AND NUMBER(Data[s]) &gt; 0
       ENSURES RES = Data[s][NUMBER(Data[s])-1]
*&gt;

&lt;*SPEC Getlo(s)
       REQUIRES s # NIL AND Valid[s] AND NUMBER(Data[s]) &gt; 0
       ENSURES RES = Data[s][0]
*&gt;

&lt;*SPEC Get(s, i)
       REQUIRES s # NIL AND Valid[s] AND i &lt; NUMBER(Data[s])
       ENSURES RES = Data[s][i]
*&gt;

BEGIN
END Sequence.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
