<HTML>
<HEAD>
<TITLE>SRC Modula-3: sequence/src/SequenceRep.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>sequence/src/SequenceRep.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA SPEC*&gt;
</PRE> This interface defines the representation of generic
   sequences. 

<P><PRE>GENERIC INTERFACE <genericInterface>SequenceRep</genericInterface>(Elem, Seq);
</PRE><BLOCKQUOTE><EM> Where <CODE>Seq = Sequence(Elem)</CODE>. </EM></BLOCKQUOTE><PRE>

REVEAL Seq.T &lt;: Public;

TYPE
  RefArray = REF ARRAY OF Elem.T;
  Public = Seq.Public OBJECT
    elem: RefArray;
    st: CARDINAL := 0;
    sz: CARDINAL := 0
  END;
</PRE> Element <CODE>i</CODE> of <CODE>s</CODE> is stored in
<P>
<PRE>
      s.elem[(s.st + i) MOD NUMBER(s.elem^)].
</PRE>
A sequence <CODE>s</CODE> satisfies the invariant that
<P>
<PRE>
      (s.elem # NIL) AND (s.sz &lt;= NUMBER(s.elem^))
      AND (s.size() = s.sz) AND (NUMBER(s.elem^) &gt; 0)
      AND (s.st &lt; NUMBER(s.elem^))
</PRE>


<P><PRE>&lt;*SPEC ABSTRACT Seq.Valid[t: Seq.T]:
                Seq.Valid[t] IFF
                      t # NIL
                  AND t.elem # NIL
                  AND NUMBER(t.elem^) &gt; 0
                  AND t.st &lt; NUMBER(t.elem^)
                  AND t.sz &lt;= NUMBER(t.elem^)
*&gt;
&lt;*SPEC DEPEND Seq.Valid[t: Seq.T]: t.st, t.sz, t.elem, RefArray *&gt;

TYPE EArr = ARRAY OF Elem.T;

&lt;*SPEC FUNC m(i: INTEGER, n: INTEGER): INTEGER*&gt;
&lt;*SPEC AXIOM (ALL [i: INTEGER, n: INTEGER] i &gt;= n IMPLIES m(i, n) = i - n) *&gt;
&lt;*SPEC AXIOM (ALL [i: INTEGER, n: INTEGER] i &lt; n IMPLIES m(i, n) = i) *&gt;

&lt;*SPEC FUNC Abs(elems: EArr, st: INTEGER, sz: INTEGER): SEQ[Elem.T] *&gt;
&lt;*SPEC AXIOM (ALL [elems: EArr, st: INTEGER, sz: INTEGER, i: INTEGER]
               Abs(elems, st, sz)[i] = elems[m((st + i), NUMBER(elems))]) *&gt;
&lt;*SPEC AXIOM (ALL [elems: EArr, st: INTEGER, sz: INTEGER]
               NUMBER(Abs(elems, st, sz)) = sz) *&gt;

&lt;*SPEC ABSTRACT Seq.Data[t: Seq.T]: Seq.Data[t] = Abs(t.elem^, t.st, t.sz) *&gt;
&lt;*SPEC DEPEND Seq.Data[t: Seq.T]: t.st, t.sz, t.elem, RefArray *&gt;

END SequenceRep.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
