<HTML>
<HEAD>
<TITLE>SRC Modula-3: set/src/Set.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>set/src/Set.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>Set</CODE> is a generic interface defining sets of <CODE>Elem.T</CODE>'s. 

<P><PRE>GENERIC INTERFACE <genericInterface><A HREF="Set.mg">Set</A></genericInterface>(Elem);
</PRE><BLOCKQUOTE><EM> Where <CODE>Elem.T</CODE> is a type that is not an open array type and <CODE>Elem</CODE> contains
<P>
<PRE>
      PROCEDURE Equal(e1, e2: Elem.T): BOOLEAN;
</PRE>
   <CODE>Equal</CODE> must be an equivalence relation.
<P>
   <CODE>Equal</CODE> may be declared with a parameter mode of either <CODE>VALUE</CODE> or
   <CODE>READONLY</CODE>, but not <CODE>VAR</CODE>.
</EM></BLOCKQUOTE><PRE>

TYPE
  Public = OBJECT METHODS
    fromArray(READONLY a: ARRAY OF Elem.T): T;
    copy(): T;
    member(e: Elem.T): BOOLEAN;
    insert(e: Elem.T): BOOLEAN;
    delete(e: Elem.T): BOOLEAN;
    size(): CARDINAL;
    isEmpty(): BOOLEAN;
    subset(s2: T): BOOLEAN;
    equal(s2: T): BOOLEAN;
    union(s2: T): T;
    intersection(s2: T): T;
    diff(s2: T): T;
    unionD(s2: T): T;
    intersectionD(s2: T): T;
    diffD(s2: T): T;
    iterate(): Iterator;
  END;
  <A HREF="Set.mg#T">T</A> &lt;: Public;
  Iterator = OBJECT METHODS
    next(VAR e: Elem.T): BOOLEAN
  END;
</PRE> A <CODE>Set(Elem)</CODE> is a set of <CODE>Elem.T</CODE>'s.  <CODE>Elem.T</CODE>'s that are equivalent
   under <CODE>Elem.Equal</CODE> are treated as equivalent by <CODE>Set</CODE>;
   for example, if you are creating a set with an <CODE>Elem.T</CODE> of <CODE>TEXT</CODE>,
   you are likely to want <CODE>Text.Equal</CODE> as the equivalence relation.
   The equivalence relation must be time-invariant.  For example,
   it can't depend on the values of particular references since some
   garbage collectors may move <CODE>REF</CODE> values.
<P>
   Formally, a set <CODE>s</CODE> has the component
<P>
<PRE>
      set(s) <KBD>a set of equivalence classes of </KBD>Elem.T<KBD>'s</KBD>.
</PRE>
   We will use <CODE>equiv(e)</CODE> to denote the equivelance class containing
   an <CODE>Elem.T</CODE> <CODE>e</CODE>.
<P>
   For efficiency, a set is not monitored: it is up to the clients
   to avoid illegal concurrent accesses on the methods of a set.  A
   set's <CODE>insert</CODE> and <CODE>delete</CODE> methods have side-effects on the set,
   so can't be performed concurrently with any other method of that
   set or of an iterator on that set.  An iterator's <CODE>next</CODE> method
   has side-effects on the iterator, and is also considered to be a
   side-effect free operation on the parent set.
<P>
   The methods of an object <CODE>s</CODE> of type <CODE>Set.T</CODE> have the following
   specifications:
<P>
   The call <CODE>s.fromArray(a)</CODE> causes <CODE>set(s)</CODE> to contain exactly
   the equivalence classes containing all the elements of the array <CODE>a</CODE>.
<P>
   The call <CODE>s.copy()</CODE> returns a set <CODE>s2</CODE> whose abstract state <CODE>set(s2)</CODE> 
   is the same as <CODE>set(s)</CODE>.
<P>
   The call <CODE>s.member(e)</CODE> returns <CODE>TRUE</CODE> iff <CODE>e</CODE> is in an equivalence
   class in <CODE>set(s)</CODE>.
<P>
   The call <CODE>s.insert(e)</CODE> returns <CODE>TRUE</CODE> and does not modify <CODE>s</CODE> if
   <CODE>equiv(e)</CODE> is in <CODE>set(s)</CODE>; otherwise it adds <CODE>equiv(e)</CODE> to <CODE>set(s)</CODE>
   and returns <CODE>FALSE</CODE>.
<P>
   The call <CODE>s.delete(e)</CODE> ensures that <CODE>set(s)</CODE> does not contain
   <CODE>equiv(e)</CODE>, returning <CODE>TRUE</CODE> iff <CODE>set(s)</CODE> contained <CODE>equiv(e)</CODE>
   before the call.
<P>
   The call <CODE>s.isEmpty()</CODE> returns <CODE>TRUE</CODE> iff <CODE>set(s)</CODE> is the empty set. 
<P>
   The call <CODE>s.size()</CODE> returns the cardinality of <CODE>set(s)</CODE>.
<P>
   The call <CODE>s.subset(s2)</CODE> returns <CODE>TRUE</CODE> iff <CODE>set(s)</CODE> is a subset of
   <CODE>set(s2)</CODE>.
<P>
   The call <CODE>s.equal(s2)</CODE> returns <CODE>TRUE</CODE> iff <CODE>set(s)</CODE> and <CODE>set(s2)</CODE> are the
   same set.
<P>
   The call <CODE>s.union(s2)</CODE> returns a new set <CODE>s3</CODE> such that <CODE>set(s3)</CODE> is
   the union of <CODE>set(s)</CODE> and <CODE>set(s2)</CODE>.
<P>
   The call <CODE>s.intersection(s2)</CODE> returns a new set <CODE>s3</CODE> such that
   <CODE>set(s3)</CODE> is the intersection of <CODE>set(s)</CODE> and <CODE>set(s2)</CODE>.
<P>
   The call <CODE>s.diff(s2)</CODE> returns a set <CODE>s3</CODE> such that <CODE>set(s3)</CODE>
   contains all equivalence classes in <CODE>set(s)</CODE> but not in <CODE>set(s2)</CODE>.
<P>
   The call <CODE>s.unionD(s2)</CODE> modifies <CODE>s</CODE> so that <CODE>set(s)</CODE> contains the
   union of <CODE>set(s`)</CODE> and <CODE>set(s2)</CODE>, where <CODE>s`</CODE> is the state of <CODE>s</CODE>
   immediately before the call, and returns the modified set.
<P>
   The call <CODE>s.intersectionD(s2)</CODE> modifies <CODE>s</CODE> so that <CODE>set(s)</CODE>
   contains the intersection of <CODE>set(s`)</CODE> and <CODE>set(s2)</CODE>, where <CODE>s`</CODE> is
   the state of <CODE>s</CODE> immediately before the call, and returns the
   modified set.
<P>
   The call <CODE>s.diffD(s2)</CODE> modifies <CODE>s</CODE> so that <CODE>set(s)</CODE> contains no
   equivalence classes that are in <CODE>set(s2)</CODE>, and returns the modified
   set.
<P>
   The call <CODE>s.iterate()</CODE> returns an iterator, which is an object
   that can be used to iterate over the elements in <CODE>s</CODE>.  See below
   for the specification of the <CODE>Iterator</CODE> type.
<P>
   If <CODE>it</CODE> is the result of the call <CODE>s.iterate()</CODE>, then the call
   <CODE>it.next(e)</CODE> selects an element from <CODE>s</CODE> that has not already been
   returned by <CODE>it</CODE>, sets <CODE>e</CODE> to that element, and returns
   <CODE>TRUE</CODE>.  If no entries remain, the call returns <CODE>FALSE</CODE> without
   setting <CODE>e</CODE>.  It is a checked runtime error to call <CODE>next</CODE>
   after it has returned <CODE>FALSE</CODE>.


<P><PRE>PROCEDURE <A HREF="Set.mg#Equal">Equal</A>(s1, s2: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Equivalent to <CODE>s1.equal(s2)</CODE>.  Exported so that <CODE>Set</CODE>'s may be used as
   arguments to generic interfaces. </EM></BLOCKQUOTE><PRE>

END Set.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
