<HTML>
<HEAD>
<TITLE>SRC Modula-3: set/src/Set.mg</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>set/src/Set.mg</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>Set</CODE> is a generic interface defining sets of <CODE>Elem.T</CODE>'s. 

<P><PRE>GENERIC MODULE <genericModule><A HREF="Set.ig">Set</A></genericModule>(Elem);
</PRE> Set is an abstract type, but many of it's operations can be implemented
   reasonably efficiently independently of any specific representation
   decisison.  Those are defined here.  Of course, subtypes may choose
   representations that offer the possibility of more efficient
   implementations, and would therefore override these methods.


<P><PRE>REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
   OVERRIDES
    isEmpty := IsEmpty;
    subset := Subset;
    equal := Equal;
    union := Union;
    intersection := Intersection;
    diff := Diff;
    unionD := UnionD;
    intersectionD := IntersectionD;
    diffD := DiffD;
  END;

PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A>(s: T): BOOLEAN =
  BEGIN RETURN s.size() = 0 END IsEmpty;

PROCEDURE <A NAME="Subset"><procedure>Subset</procedure></A>(s: T; s2: T): BOOLEAN =
  BEGIN
    IF s.size() &gt; s2.size() THEN
      RETURN FALSE
    ELSE
      VAR iter := s.iterate();
          e: Elem.T;
      BEGIN
        WHILE iter.next(e) DO
          IF NOT s2.member(e) THEN RETURN FALSE END (* IF *)
        END (* WHILE *)
      END (* BEGIN *);
      RETURN TRUE
    END (* IF *)
  END Subset;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A>(s1, s2: T): BOOLEAN =
  BEGIN
    RETURN s1.size() = s2.size() AND s1.subset(s2) AND s2.subset(s1)
  END Equal;

PROCEDURE <A NAME="Union"><procedure>Union</procedure></A>(s1: T; s2: T): T =
  VAR s3 := s1.copy(); BEGIN
    RETURN s3.unionD(s2)
  END Union;

PROCEDURE <A NAME="Intersection"><procedure>Intersection</procedure></A>(s1: T; s2: T): T =
  VAR s3 := s1.copy(); BEGIN
    RETURN s3.intersectionD(s2)
  END Intersection;

PROCEDURE <A NAME="Diff"><procedure>Diff</procedure></A>(s1: T; s2: T): T =
  VAR s3 := s1.copy(); BEGIN
    RETURN s3.diffD(s2)
  END Diff;

PROCEDURE <A NAME="UnionD"><procedure>UnionD</procedure></A>(s1: T; s2: T): T =
  VAR iter := s2.iterate(); e: Elem.T; BEGIN
    WHILE iter.next(e) DO EVAL s1.insert(e) END (* WHILE *);
    RETURN s1
  END UnionD;

PROCEDURE <A NAME="IntersectionD"><procedure>IntersectionD</procedure></A>(s1: T; s2: T): T =
  VAR iter := s1.iterate(); e: Elem.T; BEGIN
    WHILE iter.next(e) DO
      IF NOT s2.member(e) THEN EVAL s1.delete(e) END (* IF *)
    END (* WHILE *);
    RETURN s1
  END IntersectionD;

PROCEDURE <A NAME="DiffD"><procedure>DiffD</procedure></A>(s1: T; s2: T): T =
  VAR iter := s1.iterate(); e: Elem.T; BEGIN
    WHILE iter.next(e) DO
      IF s2.member(e) THEN EVAL s1.delete(e) END (* IF *)
    END (* WHILE *);
    RETURN s1
  END DiffD;

BEGIN
END Set.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
