<HTML>
<HEAD>
<TITLE>SRC Modula-3: set/src/SetDef.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>set/src/SetDef.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>SetDef</CODE> is a generic interface defining sets of <CODE>Elem.T</CODE>'s,
   implemented via hash tables.


<P><PRE>GENERIC INTERFACE <genericInterface><A HREF="SetDef.mg">SetDef</A></genericInterface>(ElemSet);
</PRE><BLOCKQUOTE><EM> WHERE    <CODE>ElemSet = Set(Elem)</CODE>, and <CODE>Elem.T</CODE> is a type that is not an
   open array type and <CODE>Elem</CODE> contains 
<P>
<PRE>
      PROCEDURE Equal(e1, e2: Elem.T): BOOLEAN;
      PROCEDURE Hash(k: Key.T): Word.T;
</PRE>
   <CODE>Equal</CODE> must be an equivalence relation and <CODE>Hash</CODE> must respect
   that equivalence relation, i.e., if <CODE>Equal(k1, k2)</CODE>, then
   <CODE>Hash(k1)=Hash(k2)</CODE>.
<P>
   <CODE>Hash</CODE> and <CODE>Equal</CODE> may be declared with a parameter mode of either
   <CODE>VALUE</CODE> or <CODE>READONLY</CODE>, but not <CODE>VAR</CODE>.
</EM></BLOCKQUOTE><PRE>

TYPE
  Public = ElemSet.T OBJECT METHODS
    init(sizeHint: CARDINAL := 0): T
  END;
  <A HREF="SetDef.mg#T">T</A> &lt;: Public;
  <A HREF="SetDef.mg#Iterator">Iterator</A> &lt;: ElemSet.Iterator;
</PRE> The expression
<P>
<PRE>
      NEW(SetDef.T).init(sz)
</PRE>
   creates a new, empty set.  The argument <CODE>sz</CODE> is a hint; the set may
   be more efficient if <CODE>sz</CODE> accurately predicts the maximum number of
   elements it will ever contain.
<P>


<P><PRE>END SetDef.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
