<HTML>
<HEAD>
<TITLE>SRC Modula-3: set/src/SetDef.mg</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>set/src/SetDef.mg</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

GENERIC MODULE <genericModule><A HREF="SetDef.ig">SetDef</A></genericModule>(Elem, ElemSet, ElemRefTable);
</PRE><BLOCKQUOTE><EM> WHERE <CODE>ElemSet = Set(Elem)</CODE> and <CODE>ElemRefTable = Table(Elem, Refany)</CODE>. </EM></BLOCKQUOTE><PRE>

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    t: ElemRefTable.Default;
   OVERRIDES
    init := Init;
    fromArray := FromArray;
    copy := Copy;
    member := Member;
    insert := Insert;
    delete := Delete;
    size := Size;
    intersection := Intersection;
    diff := Diff;
    intersectionD := IntersectionD;
    iterate := Iterate;
  END (* OBJECT *);

  <A NAME="Iterator">Iterator</A> = ElemSet.Iterator BRANDED OBJECT
    tIter: ElemRefTable.Iterator;
   OVERRIDES
    next := Next;
  END (* OBJECT *);

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(s: T; sizeHint: CARDINAL): T =
  BEGIN
    s.t := NEW(ElemRefTable.Default).init(sizeHint);
    RETURN s
  END Init;

PROCEDURE <A NAME="FromArray"><procedure>FromArray</procedure></A>(s: T; READONLY a: ARRAY OF Elem.T): ElemSet.T =
  BEGIN
    s.t := NEW(ElemRefTable.Default).init(NUMBER(a));
    FOR i := 0 TO LAST(a) DO EVAL s.insert(a[i]) END (* FOR *);
    RETURN s
  END FromArray;

PROCEDURE <A NAME="Copy"><procedure>Copy</procedure></A>(s: T): ElemSet.T =
  VAR res := NEW(T).init(s.size());
      iter := s.iterate();
      e: Elem.T;
  BEGIN
    WHILE iter.next(e) DO EVAL res.insert(e) END (* WHILE *);
    RETURN res
  END Copy;

PROCEDURE <A NAME="Member"><procedure>Member</procedure></A>(s: T; e: Elem.T): BOOLEAN =
  VAR dummy: REFANY; BEGIN
    RETURN s.t.get(e, dummy)
  END Member;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A>(s: T; e: Elem.T): BOOLEAN =
  BEGIN RETURN s.t.put(e, NIL) END Insert;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A>(s: T; e: Elem.T): BOOLEAN =
  VAR dummy: REFANY; BEGIN
    RETURN s.t.delete(e, dummy)
  END Delete;

PROCEDURE <A NAME="Size"><procedure>Size</procedure></A>(s: T): CARDINAL =
  BEGIN RETURN s.t.size() END Size;

PROCEDURE <A NAME="Intersection"><procedure>Intersection</procedure></A>(s1: T; s2: ElemSet.T): ElemSet.T =
  VAR s3: T;
      larger: ElemSet.T;
      smallerIter: ElemSet.Iterator;
      e: Elem.T;
  BEGIN
    IF s1.size() &gt;= s2.size() THEN
      larger := s1; smallerIter := s2.iterate()
    ELSE
      larger := s2; smallerIter := s1.iterate()
    END;
    s3 := NEW(T).init(larger.size());
    WHILE smallerIter.next(e) DO
      IF larger.member(e) THEN EVAL s3.insert(e) END (* IF *)
    END (* WHILE *);
    RETURN s3
  END Intersection;

PROCEDURE <A NAME="Diff"><procedure>Diff</procedure></A>(s1: T; s2: ElemSet.T): ElemSet.T =
  VAR s3 := NEW(T).init(s1.size());
      iter := s1.iterate();
      e: Elem.T;
  BEGIN
    WHILE iter.next(e) DO
      IF NOT s2.member(e) THEN EVAL s3.insert(e) END (* IF *)
    END (* WHILE *);
    RETURN s3
  END Diff;

CONST SizeFactor = 3;
</PRE> This is overridden because there is a more efficient implementation than
   the default when <CODE>s2</CODE> is significantly smaller than <CODE>s1</CODE>. 
<PRE>PROCEDURE <A NAME="IntersectionD"><procedure>IntersectionD</procedure></A>(s1: T; s2: ElemSet.T): ElemSet.T =
  BEGIN
    IF s2.size() * SizeFactor &lt; s1.size() THEN
      VAR tOld := s1.t;
          tNew := NEW(ElemRefTable.Default).init(s2.size());
          iter := s2.iterate();
          e: Elem.T;
          dummy: REFANY;
      BEGIN
        WHILE iter.next(e) DO
          IF tOld.get(e, dummy) THEN EVAL tNew.put(e, NIL) END (* IF *)
        END (* WHILE *);
        s1.t := tNew;
      END (* BEGIN *);
      RETURN s1
    ELSE
      RETURN ElemSet.T.intersectionD(s1, s2)
    END (* IF *)
  END IntersectionD;

PROCEDURE <A NAME="Iterate"><procedure>Iterate</procedure></A>(s: T): ElemSet.Iterator =
  VAR res := NEW(Iterator, tIter := s.t.iterate()); BEGIN
    RETURN res;
  END Iterate;

PROCEDURE <A NAME="Next"><procedure>Next</procedure></A>(iter: Iterator; VAR e: Elem.T): BOOLEAN =
  VAR dummy: REFANY; BEGIN
    RETURN iter.tIter.next(e, dummy)
  END Next;

BEGIN
END SetDef.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
