<HTML>
<HEAD>
<TITLE>SRC Modula-3: set/src/SetList.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>set/src/SetList.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>SetList</CODE> is a generic interface defining sets of <CODE>Elem.T</CODE>'s,
   implemented as linked lists.  This implementations is appropriate
   only for small sets.


<P><PRE>GENERIC INTERFACE <genericInterface><A HREF="SetList.mg">SetList</A></genericInterface>(ElemSet);
</PRE><BLOCKQUOTE><EM> WHERE <CODE>Elem.T</CODE> is a REF type and contains 
<P>
<PRE>
      PROCEDURE Equal(e1, e2: Elem.T): BOOLEAN;
</PRE>
   <CODE>ElemSet = Set(Elem)</CODE>.
<P>
   <CODE>Equal</CODE> must be an equivalence relation.
<P>
   <CODE>Equal</CODE> may be declared with a parameter mode of either <CODE>VALUE</CODE> or
   <CODE>READONLY</CODE>, but not <CODE>VAR</CODE>.
</EM></BLOCKQUOTE><PRE>

TYPE
  Public = ElemSet.T OBJECT METHODS
    init(): T;
  END;
  <A HREF="SetList.mg#T">T</A> &lt;: Public;
  <A HREF="SetList.mg#Iterator">Iterator</A> &lt;: ElemSet.Iterator;
</PRE> If <CODE>s</CODE> is an object of type <CODE>SetDefault.T</CODE>, the expression
<P>
<PRE>
      NEW(SetDef.T).init()
</PRE>
   creates a new, empty set.
<P>
   The call <CODE>s.toRefList()</CODE> returns a <CODE>RefList.T</CODE> whose elements
   include an element from each of the equivalence classes in
   <CODE>set(s)</CODE>, and no other elements. 


<P><PRE>END SetList.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
