<HTML>
<HEAD>
<TITLE>SRC Modula-3: slisp/src/SLisp.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>slisp/src/SLisp.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="#x1">SLisp</A></interface>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

EXCEPTION Error;
</PRE> Builtin values in SLisp 
<P>
nil                     FALSE (empty list - <CODE>()</CODE>)
t                       TRUE (any non-<CODE>nil</CODE> value is TRUE)
stdout                  a Writer for output
<P>
  Builtin operators in SLisp
<P>
(abort)                 raises SLisp.Error.
<P>
(and exps...)           Returns <CODE>t</CODE> if every <CODE>exp</CODE> evaluates to non-<CODE>nil</CODE> and
                        <CODE>nil</CODE> if any <CODE>exp</CODE> evaluates to <CODE>nil</CODE>.  Only evaluates
                        <CODE>exps</CODE> until the first <CODE>exp</CODE> evaluates to <CODE>nil</CODE>.
<P>
(append lists...)       Returns the list containing the elements of the list
                        resulting from evaluating <CODE>list1</CODE> followed
                        by the elements of <CODE>list2</CODE>, <CODE>list3</CODE>, ...
<P>
(apply symbol list)     Returns the list containing the elements resulting from
                        applying the function named <CODE>symbol</CODE> to each element in
                        the list resulting from evaluating <CODE>list</CODE>.
                        Equivalent to:
                          (list (symbol (car list)) (symbol (cadr list)) ... )
<P>
(backtrace)             prints a stack dump to <CODE>stdout</CODE>.
<P>
(cond ((e1 forms...)    Returns the result of evaluating the last form for the
       (e2 forms...)    first <CODE>ei</CODE> which evaluates to non-<CODE>nil</CODE> or <CODE>nil</CODE> if
       ...              every <CODE>ei</CODE> evaluates to <CODE>nil</CODE>.
       (en forms...))   Evaluates the <CODE>ei</CODE> until one evaluates to non-<CODE>nil</CODE>
                        and then evaluates the forms associated with that <CODE>ei</CODE>.
                        <P>
(car list)              Returns the first element in the list which results
                        from evaluating <CODE>list</CODE>.
<P>
(cdr list)              Returns the tail of the list which results
                        from evaluating <CODE>list</CODE>.
<P>
(caar list)             <CODE>caar</CODE>, <CODE>cadr</CODE>, <CODE>cdar</CODE>, <CODE>cddr</CODE> are shorthands for combinations
(cadr list)             of <CODE>car</CODE> and <CODE>cdr</CODE> where an <CODE>a</CODE> represents a <CODE>car</CODE> and <CODE>d</CODE>
(cdar list)             represents a <CODE>cdr</CODE>.  i.e. (caar list) is equivalent to
(cddr list)             (car (car list)).
<P>
(concat str1 str2)      Returns the textual concatenation of the strings resulting from 
                        evaluating <CODE>str1</CODE> and <CODE>str2</CODE>.
<P>
(cons exp list)         Returns the list whose first element is the result
                        of evaluating <CODE>exp</CODE> and whose tail is the result of
                        evaluating <CODE>list</CODE>.
<P>
(cos exp)               Returns the cosine of the float value resulting from 
                        evaluating <CODE>exp</CODE>.
<P>
(defun name             adds a function named <CODE>name</CODE> to the SLisp environment
       (formals .. )    which takes 0 or more arguments. 
       forms)
<P>
                        When the function is called SLisp creates a name scope with
                        each variable in <CODE>formals</CODE> bound to the value resulting from
                        evaluating the corresponding actual argument.  SLisp
                        then evaluates <CODE>forms</CODE>.  The function returns
                        the value of the last form evaluated.
<P>
                        THE_REST - the last formal in the function definition may be
                                preceded by <CODE>THE_REST</CODE>.  This causes any remaining 
                                actuals to be combined in a list and 
                                bound to the last formal.
<P>
                        NO_EVAL, _EVAL - a sequence of formals may be between a 
                                NO_EVAL/_EVAL pair.  When the function is 
                                called, the corresponding actuals for the formals
                                are NOT evaluated before being bound.
<P>
(defmacro name          adds a macro named <CODE>name</CODE> to the SLisp environment
          (formals ...) which takes 0 or more arguments.  
          forms)
                        <P>
                        When the macro is invoked it does NOT evaluate its actuals 
                        before binding them to the formals.  The macro <CODE>forms</CODE> are then 
                        evaluated to produce a new form which is evaluated in turn 
                        and its result is returned.
<P>
(eq exp1 exp2)          Returns <CODE>t</CODE> if the values resulting from evaluating
                        <CODE>exp1</CODE> and <CODE>exp2</CODE> are equal and <CODE>nil</CODE> otherwise.
                        Equality of strings is done textually.  Equality of
                        lists is not supported and equality of everything else
                        is by value.
<P>
(eval exp)              Evaluates <CODE>exp</CODE> and then returns the result of evaluating
                        the previous result.
<P>
(float exp)             Returns the result of evaluating <CODE>exp</CODE> and converting
                        it to a float.
<P>
(floatp exp)            Returns <CODE>t</CODE> if the result of evaluating <CODE>exp</CODE> is a 
                        float and returns <CODE>nil</CODE> otherwise.
<P>
(ge exp1 exp2)          Returns <CODE>t</CODE> if the value resulting from evaluating
                        <CODE>exp1</CODE> is greater than or equal to the value from <CODE>exp2</CODE>
                        and <CODE>nil</CODE> otherwise.
                        Comparison of strings is done textually.  Comparison of
                        lists is not supported and comparison of everything else
                        is by value.
<P>
(get_prop exp)          Returns any property set with <CODE>setprop</CODE> on the value
                        resulting from evaluating <CODE>exp</CODE>.
        <P>
(gt exp1 exp2)          Returns <CODE>t</CODE> if the value resulting from evaluating
                        <CODE>exp1</CODE> is greater than the value from <CODE>exp2</CODE>
                        and <CODE>nil</CODE> otherwise.
                        Comparison of strings is done textually.  Comparison of
                        lists is not supported and comparison of everything else
                        is by value.
        <P>
(if exp then-form       Returns the result of evaluating <CODE>then-form</CODE> if
        else-forms...)  <CODE>exp</CODE> is non-<CODE>nil</CODE> and returns the result of evaluating
                        <CODE>else-forms...</CODE> otherwise.
<P>
(integerp exp)          Returns <CODE>t</CODE> if the result of evaluating <CODE>exp</CODE> is a 
                        integer and returns <CODE>nil</CODE> otherwise.
                        <P>
(intern string)         Returns a symbol with name <CODE>string</CODE>. 
                        Evaluates <CODE>string</CODE> and creates a global variable with
                        that name and a value of <CODE>nil</CODE>.
<P>
(le exp1 exp2)          Returns <CODE>t</CODE> if the value resulting from evaluating
                        <CODE>exp1</CODE> is less than or equal to the value from <CODE>exp2</CODE>
                        and <CODE>nil</CODE> otherwise.
                        Comparison of strings is done textually.  Comparison of
                        lists is not supported and comparison of everything else
                        is by value.
<P>
(length exp)            Returns the length of the value resulting from evaluating
                        <CODE>exp</CODE>.  If the value is a list, its length is then
                        number of elements in the list.  If it is a string, its
                        length is the number of characters.  Otherwise, its 
                        length is 1.
        <P>
(let ((sym1 exp1)       Creates a new name scope, with names <CODE>sym1</CODE>, <CODE>sym2</CODE>, ...
      (sym2 exp2)       bound to the value of evaluating <CODE>exp1</CODE>, <CODE>exp2</CODE>, ...
      ...)              <CODE>forms</CODE> are evaluated and the result is the value
  forms...)             of the last form.  Note: the names <CODE>sym1</CODE> .. <CODE>sym(i-1)</CODE>
                        are NOT available when evaluating <CODE>exp(i)</CODE>.
<P>
(letstar ((sym1 exp1)   Creates a new name scope as in <CODE>let</CODE>, except that the
         (sym2 exp2)    values of <CODE>sym1</CODE>, <CODE>sym2</CODE>, ... <CODE>sym(i-1)</CODE> are available
          ...)          when evaluating <CODE>exp(i)</CODE>.
  forms...)      
<P>
(list exps...)          Returns the list whose elements are the values resulting from
                        evaluating <CODE>exps</CODE>.
<P>
(listp exp)             Returns <CODE>t</CODE> if the result of evaluating <CODE>exp</CODE> is a 
                        integer and returns <CODE>nil</CODE> otherwise.
<P>
(load filename)         Evaluates <CODE>filename</CODE> to a string.  The string is used
                        as the name of a file which is opened and read.
                        The SLisp code in the file is evaluated.  The result
                        is equivalent to textually inserting the contents of the
                        file at this point.
<P>
(lt exp1 exp2)          Returns <CODE>t</CODE> if the value resulting from evaluating
                        <CODE>exp1</CODE> is less than or equal to the value from <CODE>exp2</CODE>
                        and <CODE>nil</CODE> otherwise.
                        Comparison of strings is done textually.  Comparison of
                        lists is not supported and comparison of everything else
                        is by value.
<P>
        <P>
(ne exp1 exp2)          Returns <CODE>nil</CODE> if the values resulting from evaluating
                        <CODE>exp1</CODE> and <CODE>exp2</CODE> are equal and <CODE>t</CODE> otherwise.
                        Equality of strings is done textually.  Equality of
                        lists is not supported and equality of everything else
                        is by value.
<P>
(not exp)               Returns <CODE>t</CODE> if the value of <CODE>exp</CODE> is <CODE>nil</CODE>, otherwise
                        returns <CODE>nil</CODE>.
<P>
(or exps...)            Returns <CODE>nil</CODE> if every <CODE>exp</CODE> evaluates to <CODE>nil</CODE> and
                        <CODE>t</CODE> if any <CODE>exp</CODE> evaluates to non-<CODE>nil</CODE>.  Only evaluates
                        <CODE>exps</CODE> until the first <CODE>exp</CODE> evaluates to non-<CODE>nil</CODE>.
<P>
(print exps...)         Prints the values from evaluating <CODE>exps</CODE> to <CODE>stdout</CODE>.  The result
                        is the value of the last expression.
<P>
(printname symbol)      Returns the string name of <CODE>symbol</CODE>.
<P>
(progn forms...)        Evaluates <CODE>forms</CODE>, and returns the result of evaluating the
                        last form.
<P>
(quote exp)             Returns <CODE>exp</CODE> un-evaluated.
<P>
(random)                Returns a pseudo-random float between 0.0 and 1.0 (inclusive).
<P>
(randomgen exp)         Returns a pseudo-random number generator produced by
                        NEW(Random.Default).init(exp # NIL)
<P>
(randomnext exp)        Returns a pseudo-random float between 0.0 and 1.0 (inclusive).
                        <CODE>exp</CODE> must evaluate to a random number generator returned
                        by a call on <CODE>randomgen</CODE>.
<P>
(round exp)             result is the value of evaluating <CODE>exp</CODE> and rounding
                        it to an integer.
<P>
(set_prop exp value)    Evaluates <CODE>value</CODE> and sets it as the property on the value
                        resulting from evaluating <CODE>exp</CODE>.  <CODE>value</CODE> can be retrieved
                        from <CODE>exp</CODE> by <CODE>getprop</CODE>.
        <P>
(setq symbol exp)       Evaluates <CODE>exp</CODE> and binds the result to <CODE>symbol</CODE>, 
                        returns the result.  If <CODE>symbol</CODE> is not defined, it 
                        is created as a global.
<P>
(sqrt exp)              Returns the aquare root of the float value resulting from 
                        evaluating <CODE>exp</CODE>.
<P>
(sin exp)               Returns the sine of the float value resulting from 
                        evaluating <CODE>exp</CODE>.
<P>
(stringp exp)           Returns <CODE>t</CODE> if the result of evaluating <CODE>exp</CODE> is a 
                        string and returns <CODE>nil</CODE> otherwise.
<P>
(symbolp exp)           Returns <CODE>t</CODE> if the result of evaluating <CODE>exp</CODE> is a 
                        string and returns <CODE>nil</CODE> otherwise.
<P>
(truncate exp)          Returns the result of evaluating <CODE>exp</CODE> and truncating
                        it to an integer.
<P>
(while exp forms...)    Evaluates <CODE>exp</CODE> and if it is true
                        evaluates <CODE>forms</CODE>.  Result is the value of the last
                        evaluated form.
<P>
(+ exps...)             Returns the result of adding together the result 
                        of evalating each <CODE>exp</CODE>.  The values of <CODE>exps</CODE> should
                        be integers or floats.  If any <CODE>exp</CODE> is a float, the
                        result is a float, otherwise an integer.
<P>
(- exp1 exps...)        Returns the result of subtracting the result 
                        of evalating each <CODE>exp(i)</CODE> from <CODE>exp1</CODE>.  If there
                        is only one <CODE>exp</CODE> then the result is equivalent to
                        <CODE>(- 0 exp1)</CODE>.  The values of  <CODE>exps</CODE> should
                        be integers or floats.  If any <CODE>exp</CODE> is a float, the
                        result is a float, otherwise an integer.
<P>
( * exps...)            Returns the result of multiplying together the result 
                        of evalating each <CODE>exp</CODE>.  The values of <CODE>exps</CODE> should
                        be integers or floats.  If any <CODE>exp</CODE> is a float, the
                        result is a float, otherwise an integer.
<P>
(- exp1 exps...)        Returns the result of succesively dividing the result 
                        of evalating each <CODE>exp(i)</CODE> into <CODE>exp1</CODE>.  If there
                        is only one <CODE>exp</CODE> then the result is equivalent to
                        <CODE>(/ 1 exp1)</CODE>.  The values of  <CODE>exps</CODE> should
                        be integers or floats.  If any <CODE>exp</CODE> is a float, the
                        result is a float, otherwise an integer.


<P>
<P><PRE>TYPE
  Sexp = REFANY;
    (* it is really on of the following: *)
    Symbol  = Atom.T;
    List    = RefList.T;
    Integer = REF INTEGER;
    Float   = REF REAL;
    String  = Text.T;
    Reader  = Rd.T;
    Writer  = Wr.T;

  Builtin = OBJECT
              name: Text.T;
              minArgs := 0;
              maxArgs := LAST (INTEGER);
            METHODS
              apply (interp: T; args: List): Sexp RAISES {Error}; END;

  <A HREF="SLisp.m3#T">T</A> &lt;: PublicT;
  PublicT = OBJECT METHODS
         new (): T RAISES {Error};
         init(): T;
         (* initializess the interpreter to the initial state.
            can also be called to reset an existing interpreter. *)
         error (msg: Text.T := &quot;&quot;): Sexp RAISES {Error};

         load (name: Text.T): Sexp RAISES {Error};

         defineVar (name: Text.T; val: Sexp);
         defineFun (cl: Builtin);

         checkSymbol (e: Sexp): Symbol RAISES {Error};
         checkList (e: Sexp): List RAISES {Error};
         checkInt (e: Sexp): INTEGER RAISES {Error};
         checkFloat (e: Sexp): REAL RAISES {Error};
         checkString (e: Sexp): String RAISES {Error};

         eval (e: Sexp): Sexp RAISES {Error};
           evalSymbol (e: Sexp): Symbol RAISES {Error};
           evalList (e: Sexp): List RAISES {Error};
           evalInt (e: Sexp): INTEGER RAISES {Error};
           evalFloat (e: Sexp): REAL RAISES {Error};
           evalString (e: Sexp): String RAISES {Error};

         sEval (t: Text.T): Text.T RAISES {Error};
         varEval (name: Text.T): Sexp RAISES {Error};  END;

PROCEDURE <A HREF="SLisp.m3#Read">Read</A> (rd: Reader): Sexp
  RAISES {Sx.ReadError, Rd.EndOfFile};
PROCEDURE <A HREF="SLisp.m3#Write">Write</A> (wr: Writer; s: Sexp);

END SLisp.
</PRE>
</inInterface>
<HR>
<A NAME="x1">SLisp's implementation  is in:
</A><UL>
<LI><A HREF="SLisp.m3#0TOP0">slisp/src/SLisp.m3</A>
<LI><A HREF="SLispMath.m3#0TOP0">slisp/src/SLispMath.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
