<HTML>
<HEAD>
<TITLE>SRC Modula-3: slisp/src/SLispClass.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>slisp/src/SLispClass.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="SLisp.m3">SLispClass</A></interface>;

IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>, <A HREF="SLisp.i3">SLisp</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;
</PRE> for suppliers of SLisp builtin functions 

<P><PRE>TYPE
  Atom = REF RECORD
               val                : SLisp.Sexp    := NIL;
               funDefined                         := FALSE;
               macro              : BOOLEAN       := FALSE;
               funFormals, funBody: SLisp.List    := NIL;
               builtin            : SLisp.Builtin := NIL;
             END;

  Binding = REF RECORD
                  symbol: SLisp.Symbol;
                  atom  : Atom;
                END;

  Frame = REF RECORD
                next    : Frame                := NIL;
                size    : INTEGER              := 0;
                table   : REF ARRAY OF Binding := NIL;
                procName: TEXT                 := &quot;&quot;;
                endScope                       := FALSE;
              END;

TYPE
  LookupMode = {CreateLocal, CreateGlobal, LookupOnly};

  TPublic =
    SLisp.PublicT OBJECT
      topFrame : Frame;
      frame    : Frame;
      depth                   := 0;
      underEval: SLisp.List;
      evalStack: SLisp.List;
    METHODS
      lookup (s: SLisp.Symbol; create := LookupMode.CreateGlobal): Atom;
      lookupAtom (at: Atom): SLisp.Symbol;
      pushScope  ();
      popScope   ();
    END;

REVEAL
  SLisp.T &lt;: TPublic;

TYPE
  Range = REF RECORD start, end: INTEGER; form: SLisp.Sexp END;

PROCEDURE <A HREF="SLisp.m3#ReadToTable">ReadToTable</A> (rd: SLisp.Reader; table: IntRefTbl.T): SLisp.Sexp
  RAISES {Rd.EndOfFile, Sx.ReadError};
</PRE><BLOCKQUOTE><EM> Read the SLisp program from <CODE>rd</CODE> as in SLisp.Read except also enter
   each list s-expression into <CODE>table</CODE> with a <CODE>Range</CODE> record for
   its position </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SLisp.m3#SxToText">SxToText</A>(sx: REFANY): TEXT RAISES {Sx.PrintError};
PROCEDURE <A HREF="SLisp.m3#SxPrint">SxPrint</A> (wr       : Wr.T;
                   sx       : REFANY;
                   maxDepth : CARDINAL := LAST(CARDINAL);
                   maxLength: CARDINAL := LAST(CARDINAL)  )
  RAISES {Sx.PrintError};
  (* Sx.Print extended to handle all types of REFs *)
END SLispClass.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
