<HTML>
<HEAD>
<TITLE>SRC Modula-3: slisp/src/SLispMath.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>slisp/src/SLispMath.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module>SLispMath</module> EXPORTS <A HREF="SLisp.i3"><implements>SLisp</A></implements>, <A HREF="SLispMath.i3"><implements>SLispMath</A></implements>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="../../random/src/Common/Random.i3">Random</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="SLispClass.i3">SLispClass</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../text/src/Text.i3">Text</A>;

VAR
  true: Atom.T;

&lt;* FATAL Sx.PrintError *&gt;

PROCEDURE <A NAME="Register"><procedure>Register</procedure></A> (self: T) =
  &lt;* FATAL Error *&gt;
  BEGIN
    true := self.varEval(&quot;t&quot;);

    FOR i := FIRST(Comparisons) TO LAST(Comparisons) DO
      self.defineFun(
        NEW(BuiltinComp, name := CompNames[i], apply := Comparison,
            minArgs := 2, maxArgs := 2, comp := i));
    END;
    self.defineFun(NEW(Builtin, name := &quot;or&quot;, apply := Or, minArgs := 1,
                       maxArgs := LAST(INTEGER)));
    self.defineFun(NEW(Builtin, name := &quot;and&quot;, apply := And, minArgs := 1,
                       maxArgs := LAST(INTEGER)));
    self.defineFun(NEW(Builtin, name := &quot;not&quot;, apply := Not, minArgs := 1,
                       maxArgs := 1));
    self.defineFun(NEW(Builtin, name := &quot;+&quot;, apply := Plus, minArgs := 0,
                       maxArgs := LAST(INTEGER)));
    self.defineFun(NEW(Builtin, name := &quot;*&quot;, apply := Times, minArgs := 0,
                       maxArgs := LAST(INTEGER)));
    self.defineFun(NEW(Builtin, name := &quot;-&quot;, apply := Sub, minArgs := 0,
                       maxArgs := LAST(INTEGER)));
    self.defineFun(NEW(Builtin, name := &quot;/&quot;, apply := Div, minArgs := 0,
                       maxArgs := LAST(INTEGER)));
    self.defineFun(NEW(Builtin, name := &quot;float&quot;, apply := FloatFun,
                       minArgs := 1, maxArgs := 1));
    self.defineFun(NEW(Builtin, name := &quot;round&quot;, apply := Round,
                       minArgs := 1, maxArgs := 1));
    self.defineFun(NEW(Builtin, name := &quot;truncate&quot;, apply := Truncate,
                       minArgs := 1, maxArgs := 1));
    self.defineFun(NEW(Builtin, name := &quot;sqrt&quot;, apply := Sqrt,
                       minArgs := 1, maxArgs := 1));
    self.defineFun(NEW(Builtin, name := &quot;sin&quot;, apply := Sin,
                       minArgs := 1, maxArgs := 1));
    self.defineFun(NEW(Builtin, name := &quot;cos&quot;, apply := Cos,
                       minArgs := 1, maxArgs := 1));
    self.defineFun(NEW(Builtin, name := &quot;random&quot;, apply := RandomFun,
                       minArgs := 0, maxArgs := 0));
    self.defineFun(NEW(Builtin, name := &quot;randomgen&quot;, apply := RandomGen,
                       minArgs := 1, maxArgs := 1));
    self.defineFun(NEW(Builtin, name := &quot;randomnext&quot;, apply := RandomNext,
                       minArgs := 1, maxArgs := 1));
  END Register;
</PRE> NumVal does 3 things:
<P>
   1) It converts its arg to a numeric value
   2) It returns whether the value is an integer or real
   3) It makes sure a related value has the same type
<P>
   So for the old value and new value, the resulting type is:
   integer and integer =&gt; integer
   real and real =&gt; real
   real and integer =&gt; real (convert new integer to real)
   integer and real =&gt; real (convert old integer to real)

<PRE>PROCEDURE <A NAME="NumVal"><procedure>NumVal</procedure></A> (                 interp : T;
                                   arg    : Sexp;
                  VAR (* in/out *) real   : BOOLEAN;
                  VAR (* out *)    oldi, i: INTEGER;
                  VAR (* out *)    oldr, r: REAL ) RAISES {Error} =
  BEGIN
    TYPECASE arg OF
    | NULL =&gt;
        EVAL
          interp.error(Fmt.F(&quot;NIL valued argument to a numeric operator&quot;));
    | Integer (int) =&gt;
        IF real THEN r := FLOAT(int^, REAL) ELSE i := int^ END;
    | Float (flt) =&gt;
        r := flt^;
        IF NOT real THEN real := TRUE; oldr := FLOAT(oldi, REAL) END;
    ELSE
      EVAL interp.error(
             Fmt.F(&quot;\&quot;%s\&quot;: non-numeric argument to a numeric operator&quot;,
                   SLispClass.SxToText(arg)));
    END;
  END NumVal;

TYPE
  BuiltinComp = Builtin OBJECT
    comp: Comparisons;
  END;

TYPE
  Comparisons = {Eq, Ne, Gt, Lt, Ge, Le};

CONST
  CompNames = ARRAY Comparisons OF TEXT{&quot;eq&quot;, &quot;ne&quot;, &quot;gt&quot;, &quot;lt&quot;, &quot;ge&quot;, &quot;le&quot;};

CONST
  Less = SET OF Comparisons{Comparisons.Ne, Comparisons.Le, Comparisons.Lt};
  Equal = SET OF Comparisons{Comparisons.Eq, Comparisons.Le, Comparisons.Ge};
  More = SET OF Comparisons{Comparisons.Ne, Comparisons.Ge, Comparisons.Gt};

PROCEDURE <A NAME="CompMismatch"><procedure>CompMismatch</procedure></A> (interp: T; comp: Comparisons; s1, s2: Sexp): Sexp
  RAISES {Error} =
  BEGIN
    CASE comp OF
    | Comparisons.Eq =&gt; RETURN NIL
    | Comparisons.Ne =&gt; RETURN true
    ELSE
      RETURN
        interp.error(
          Fmt.F(&quot;Cannot compare: %s, %s&quot;, SLispClass.SxToText(s1), SLispClass.SxToText(s2)));
    END;
  END CompMismatch;

PROCEDURE <A NAME="Comparison"><procedure>Comparison</procedure></A> (self: BuiltinComp; interp: T; args: List): Sexp
  RAISES {Error} =
  VAR
    i1, i2: INTEGER;
    r1, r2: REAL;
    res   : BOOLEAN;
    real            := FALSE;
    comp            := self.comp;
    a1              := interp.eval(args.head);
    a2              := interp.eval(args.tail.head);
  BEGIN
    TYPECASE a1 OF
    | NULL =&gt;
        TYPECASE a2  OF
        | NULL =&gt;
           CASE comp OF
           | Comparisons.Eq, Comparisons.Le, Comparisons.Ge =&gt; RETURN true
           | Comparisons.Ne =&gt; RETURN NIL
           ELSE
             RETURN CompMismatch(interp, comp, a1, a2);
           END;
        ELSE
           CASE comp OF
           | Comparisons.Eq =&gt; RETURN NIL
           | Comparisons.Ne =&gt; RETURN true
           ELSE
             RETURN CompMismatch(interp, comp, a1, a2);
           END;
        END;
    | Symbol (s1) =&gt;
        TYPECASE a2 OF
        | Symbol (s2) =&gt;
            CASE Text.Compare(Atom.ToText(s1), Atom.ToText(s2)) OF
            | -1 =&gt; res := comp IN Less;
            | 0 =&gt; res := comp IN Equal;
            | 1 =&gt; res := comp IN More;
            END;
        ELSE
          RETURN CompMismatch(interp, comp, a1, a2);
        END;
    | String (s1) =&gt;
        TYPECASE a2 OF
        | String (s2) =&gt;
            CASE Text.Compare(s1, s2) OF
            | -1 =&gt; res := comp IN Less;
            | 0 =&gt; res := comp IN Equal;
            | 1 =&gt; res := comp IN More;
            END;
        ELSE
          RETURN CompMismatch(interp, comp, a1, a2);
        END;
    | List =&gt;
        TYPECASE a2 OF
        | List =&gt;
            EVAL interp.error(Fmt.F(&quot;Cannot compare lists: %s, %s&quot;,
                                    SLispClass.SxToText(a1), SLispClass.SxToText(a2)));
        ELSE
          CASE comp OF
          | Comparisons.Eq =&gt; RETURN NIL
          | Comparisons.Ne =&gt; RETURN true
          ELSE
            EVAL interp.error(Fmt.F(&quot;Cannot compare lists: %s, %s&quot;,
                                    SLispClass.SxToText(a1), SLispClass.SxToText(a2)));
          END;
        END;
    | Integer, Float =&gt;
        TYPECASE a2 OF
        | Integer, Float =&gt;
            NumVal(interp, a1, real, i2, i1, r2, r1);
            NumVal(interp, a2, real, i1, i2, r1, r2);
            IF real THEN
              CASE comp OF
              | Comparisons.Eq =&gt; res := r1 = r2;
              | Comparisons.Ne =&gt; res := r1 # r2;
              | Comparisons.Gt =&gt; res := r1 &gt; r2;
              | Comparisons.Lt =&gt; res := r1 &lt; r2;
              | Comparisons.Ge =&gt; res := r1 &gt;= r2;
              | Comparisons.Le =&gt; res := r1 &lt;= r2;
              END;
            ELSE
              CASE comp OF
              | Comparisons.Eq =&gt; res := i1 = i2;
              | Comparisons.Ne =&gt; res := i1 # i2;
              | Comparisons.Gt =&gt; res := i1 &gt; i2;
              | Comparisons.Lt =&gt; res := i1 &lt; i2;
              | Comparisons.Ge =&gt; res := i1 &gt;= i2;
              | Comparisons.Le =&gt; res := i1 &lt;= i2;
              END;
            END;
        ELSE
          RETURN CompMismatch(interp, comp, a1, a2);
        END;
    ELSE
      CASE comp OF
      | Comparisons.Eq =&gt; res := a1 = a2;
      | Comparisons.Ne =&gt; res := a1 # a2;
      ELSE
        RETURN CompMismatch(interp, comp, a1, a2);
      END;
    END;
    IF res THEN RETURN true ELSE RETURN NIL END;
  END Comparison;

PROCEDURE <A NAME="Or"><procedure>Or</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp RAISES {Error} =
  VAR res: Sexp;
  BEGIN
    WHILE args # NIL DO
      res := interp.eval (args.head);
      IF res # NIL THEN
        RETURN res; END;
      args := args.tail; END;
    RETURN res;
  END Or;

PROCEDURE <A NAME="And"><procedure>And</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp RAISES {Error} =
  VAR res: Sexp;
  BEGIN
    WHILE args # NIL DO
      res := interp.eval (args.head);
      IF res = NIL THEN
        RETURN NIL; END;
      args := args.tail; END;
    RETURN res;
  END And;

PROCEDURE <A NAME="Not"><procedure>Not</procedure></A>(&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp RAISES {Error} =
  VAR res: Sexp;
  BEGIN
    res := interp.eval (args.head);
    IF res = NIL THEN
      RETURN true;
    ELSE
      RETURN NIL
    END;
  END Not;

PROCEDURE <A NAME="Plus"><procedure>Plus</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp
  RAISES {Error} =
  VAR
    real            := FALSE;
    i1, i2: INTEGER;
    r1, r2: REAL;
    ires  : Integer;
    fres  : Float;
  BEGIN
    i1 := 0;
    WHILE args # NIL DO
      NumVal(interp, interp.eval(args.head), real, i1, i2, r1, r2);
      IF real THEN r1 := r1 + r2 ELSE i1 := i1 + i2; END;
      args := args.tail;
    END;
    IF real THEN
      fres := NEW(Float);
      fres^ := r1;
      RETURN fres;
    ELSE
      ires := NEW(Integer);
      ires^ := i1;
      RETURN ires;
    END;
  END Plus;

PROCEDURE <A NAME="Sub"><procedure>Sub</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp
  RAISES {Error} =
  VAR
    real            := FALSE;
    i1, i2: INTEGER;
    r1, r2: REAL;
    ires  : Integer;
    fres  : Float;
  BEGIN
    IF args = NIL THEN
      i1 := 0;
    ELSE
      NumVal(interp, interp.eval(args.head), real, i2, i1, r2, r1);
      args := args.tail;
      IF args = NIL THEN (* unary minus *)
        IF real THEN r1 := -r1 ELSE i1 := -i1 END;
      ELSE
        WHILE args # NIL DO
          NumVal(interp, interp.eval(args.head), real, i1, i2, r1, r2);
          IF real THEN r1 := r1 - r2 ELSE i1 := i1 - i2; END;
          args := args.tail;
        END;
      END;
    END;
    IF real THEN
      fres := NEW(Float);
      fres^ := r1;
      RETURN fres;
    ELSE
      ires := NEW(Integer);
      ires^ := i1;
      RETURN ires;
    END;
  END Sub;

PROCEDURE <A NAME="Times"><procedure>Times</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp RAISES {Error} =
  VAR
    real            := FALSE;
    i1, i2: INTEGER;
    r1, r2: REAL;
    ires  : Integer;
    fres  : Float;
  BEGIN
    i1 := 1;
    WHILE args # NIL DO
      NumVal(interp, interp.eval(args.head), real, i1, i2, r1, r2);
      IF real THEN r1 := r1 * r2 ELSE i1 := i1 * i2; END;
      args := args.tail;
    END;
    IF real THEN
      fres := NEW(Float);
      fres^ := r1;
      RETURN fres;
    ELSE
      ires := NEW(Integer);
      ires^ := i1;
      RETURN ires;
    END;
  END Times;

PROCEDURE <A NAME="Div"><procedure>Div</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp
  RAISES {Error} =
  VAR
    real            := FALSE;
    i1, i2: INTEGER;
    r1, r2: REAL;
    ires  : Integer;
    fres  : Float;
  BEGIN
    IF args = NIL THEN
      i1 := 1;
    ELSE
      NumVal(interp, interp.eval(args.head), real, i2, i1, r2, r1);
      args := args.tail;
      IF args = NIL THEN         (* unary divide? *)
        IF real THEN
          IF r1 = 0.0 THEN EVAL interp.error(&quot;divide by 0.0&quot;); END;
          r1 := 1.0 / r1
        ELSE
          IF i1 = 0 THEN EVAL interp.error(&quot;divide by 0&quot;); END;
          i1 := 1 DIV i1
        END;
      ELSE
        WHILE args # NIL DO
          NumVal(interp, interp.eval(args.head), real, i1, i2, r1, r2);
          IF real THEN
            IF r2 = 0.0 THEN EVAL interp.error(&quot;divide by 0.0&quot;); END;
            r1 := r1 / r2
          ELSE
            IF i2 = 0 THEN EVAL interp.error(&quot;divide by 0&quot;); END;
            i1 := i1 DIV i2;
          END;
          args := args.tail;
        END;
      END;
    END;
    IF real THEN
      fres := NEW(Float);
      fres^ := r1;
      RETURN fres;
    ELSE
      ires := NEW(Integer);
      ires^ := i1;
      RETURN ires;
    END;
  END Div;

PROCEDURE <A NAME="FloatFun"><procedure>FloatFun</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp
  RAISES {Error} =
  VAR i := interp.eval(args.head);
  BEGIN
    TYPECASE i OF
    | NULL =&gt; RETURN interp.error(&quot;Can't \&quot;float\&quot; nil&quot;);
    | Integer (ri) =&gt; WITH f = NEW(Float) DO f^ := FLOAT(ri^); RETURN f END;
    | Float =&gt; RETURN i
    ELSE
      RETURN
        interp.error(Fmt.F(&quot;\&quot;%s\&quot; should be an integer&quot;, SLispClass.SxToText(i)));
    END;
  END FloatFun;

PROCEDURE <A NAME="Truncate"><procedure>Truncate</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp
  RAISES {Error} =
  VAR r := interp.eval(args.head);
  BEGIN
    TYPECASE r OF
    | NULL =&gt; RETURN interp.error(&quot;Can't \&quot;truncate\&quot; nil&quot;);
    | Integer (ri) =&gt; RETURN ri
    | Float (f) =&gt; WITH i = NEW(Integer) DO i^ := TRUNC(f^); RETURN i END;
    ELSE
      RETURN
        interp.error(Fmt.F(&quot;\&quot;%s\&quot; should be a real&quot;, SLispClass.SxToText(r)));
    END;
  END Truncate;

PROCEDURE <A NAME="Round"><procedure>Round</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp
  RAISES {Error} =
  VAR r := interp.eval(args.head);
  BEGIN
    TYPECASE r OF
    | NULL =&gt; RETURN interp.error(&quot;Can't \&quot;round\&quot; nil&quot;);
    | Integer (ri) =&gt; RETURN ri
    | Float (f) =&gt; WITH i = NEW(Integer) DO i^ := ROUND(f^); RETURN i END;
    ELSE
      RETURN
        interp.error(Fmt.F(&quot;\&quot;%s\&quot; should be a real&quot;, SLispClass.SxToText(r)));
    END;
  END Round;

PROCEDURE <A NAME="Sqrt"><procedure>Sqrt</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp
  RAISES {Error} =
  VAR
    r   := interp.eval(args.head);
    res := NEW(Float);
  BEGIN
    TYPECASE r OF
    | NULL =&gt; RETURN interp.error(&quot;Can't \&quot;sqrt\&quot; nil&quot;);
    | Integer (ri) =&gt; res^ := FLOAT(Math.sqrt(FLOAT(ri^, LONGREAL)));
    | Float (f) =&gt; res^ := FLOAT(Math.sqrt(FLOAT(f^, LONGREAL)));
    ELSE
      RETURN interp.error(Fmt.F(&quot;\&quot;%s\&quot; should be a real&quot;, SLispClass.SxToText(r)));
    END;
    RETURN res;
  END Sqrt;

PROCEDURE <A NAME="Sin"><procedure>Sin</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp
  RAISES {Error} =
  VAR
    r   := interp.eval(args.head);
    res := NEW(Float);
  BEGIN
    TYPECASE r OF
    | NULL =&gt; RETURN interp.error(&quot;Can't \&quot;sin\&quot; nil&quot;);
    | Integer (ri) =&gt; res^ := FLOAT(Math.sin(FLOAT(ri^, LONGREAL)));
    | Float (f) =&gt; res^ := FLOAT(Math.sin(FLOAT(f^, LONGREAL)));
    ELSE
      RETURN interp.error(Fmt.F(&quot;\&quot;%s\&quot; should be a real&quot;, SLispClass.SxToText(r)));
    END;
    RETURN res;
  END Sin;

PROCEDURE <A NAME="Cos"><procedure>Cos</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List): Sexp
  RAISES {Error} =
  VAR
    r   := interp.eval(args.head);
    res := NEW(Float);
  BEGIN
    TYPECASE r OF
    | NULL =&gt; RETURN interp.error(&quot;Can't \&quot;cos\&quot; nil&quot;);
    | Integer (ri) =&gt; res^ := FLOAT(Math.cos(FLOAT(ri^, LONGREAL)));
    | Float (f) =&gt; res^ := FLOAT(Math.cos(FLOAT(f^, LONGREAL)));
    ELSE
      RETURN interp.error(
               Fmt.F(&quot;\&quot;%s\&quot; should be a real&quot;, SLispClass.SxToText(r)));
    END;
    RETURN res;
  END Cos;

PROCEDURE <A NAME="RandomFun"><procedure>RandomFun</procedure></A> (&lt;*UNUSED*&gt;   self  : Builtin;
                     &lt;* UNUSED *&gt; interp: T;
                     &lt;* UNUSED *&gt; args  : List     ): Sexp =
  BEGIN
    WITH f = NEW(Float) DO
      f^ := NEW(Random.Default).init().real();
      RETURN f
    END;
  END RandomFun;

PROCEDURE <A NAME="RandomGen"><procedure>RandomGen</procedure></A> (&lt;*UNUSED*&gt;   self  : Builtin;
                     &lt;* UNUSED *&gt; interp: T;
                                  args  : List     ): Sexp =
  VAR fixed := (RefList.Length(args) = 0) OR (args.head # NIL);
  BEGIN
    RETURN NEW(Random.Default).init(fixed);
  END RandomGen;

PROCEDURE <A NAME="RandomNext"><procedure>RandomNext</procedure></A> (&lt;*UNUSED*&gt; self: Builtin; interp: T; args: List):
  Sexp RAISES {Error} =
  VAR r := interp.eval(args.head);
  BEGIN
    IF NOT ISTYPE(r, Random.Default) THEN
      RETURN interp.error(Fmt.F(&quot;\&quot;%s\&quot; should be a Random.T&quot;,
                                SLispClass.SxToText(r)));
    END;
    VAR rg := NARROW(r, Random.T);
    BEGIN
      RETURN Sx.FromReal(rg.real())
    END
  END RandomNext;

BEGIN
END SLispMath.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
