<HTML>
<HEAD>
<TITLE>SRC Modula-3: smalldb/src/SmallDB.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>smalldb/src/SmallDB.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="SmallDB.m3">SmallDB</A></interface>;

IMPORT <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;
</PRE> This package will maintain a copy of a data structure on secondary storage,
   and will update the secondary storage as updates are made to the data
   structure. A client can use this package to ensure that the current value
   of the data structure can be recovered after any crash. This package is
   efficient: the cost of recording an update is about one disk write.
<P>
   The secondary storage strategy is to record values in files using a
   representation of the caller's choosing. Two sorts of files are kept:
   snapshots and a log. At any instant, one snapshot is <CODE>current</CODE>. The log
   consists of a sequence of updates that have occurred since the current
   snapshot was taken. The current stable state is the value of the
   snapshot, as modified by the sequence of updates in the log. From time to
   time the client of this package instructs the package to make a new
   snapshot and clear the log. This package arranges disk writes such that
   updates are stable and atomic: no update is lost, and each update either is
   recorded completely in the log or not at all. Making a new snapshot is also
   atomic.
<P>
   Normal use for maintaing a database is as follows. The client maintains his
   data structure in virtual memory. As updates happen to the structure, the
   client informs this package by calling <CODE>t.update</CODE>. Periodically, the client
   calls <CODE>t.snapshot</CODE>. On a restart, the client calls <CODE>t.recover</CODE> to obtain
   the latest snapshot and the following sequence of updates; the client
   applies the updates to the snapshot to obtain the state that existed
   before the crash.


<P><PRE>TYPE
  <A HREF="SmallDB.m3#T">T</A> &lt;: Public;
  Public = OBJECT METHODS
    recover(): REFANY RAISES {OSError.E, Failed};
    update(value: REFANY; forceToDisk: BOOLEAN := TRUE) RAISES {OSError.E};
    snapshot(value: REFANY) RAISES {OSError.E};
    close() RAISES {OSError.E};
    snapshotBytes() : CARDINAL;
    logBytes() : CARDINAL;
    status() : TEXT;
  END;

EXCEPTION Failed(AtomList.T);

  (* A &quot;T&quot; is a handle on an open stable storage directory.

     Methods are as follows:

     recover:
         Returns the REFANY recorded in the current snapshot,
         as recovered by calling &quot;closure.recover&quot; and then
         subsequently invoking &quot;closure.readUpdate&quot; to apply any
         logged updates to the state.

     update:
         Records this update in the log file for &quot;t&quot;, by calling
         &quot;closure.logUpdate&quot;.  This method must not be called until
         after &quot;recover&quot; has been invoked.  If NOT forceToDisk,
         the update is buffered until the buffer is full.

     snapshot:
         Records this value as the current snapshot, by invoking
         &quot;closure.snapshot&quot;, and then empties the log.

     close:
         Close a stable storage directory in an orderly manner

     snapshotBytes:
         Returns the size of the snapshot file.

     logBytes:
         Returns the size of the log file.

     status:
         Returns human readable status information.
*)

TYPE
  Closure = OBJECT METHODS
    new(): REFANY RAISES {Failed};
    recover(rd: Rd.T): REFANY RAISES {Failed, Rd.Failure};
    snapshot(wr: Wr.T; r: REFANY) RAISES {Wr.Failure};
    readUpdate(rd: Rd.T; state: REFANY): REFANY RAISES {Failed, Rd.Failure};
    logUpdate(wr: Wr.T; r: REFANY) RAISES {Wr.Failure};
  END;
</PRE> Each client must implement a closure object.  The readers and writers
   passed to the closure object methods will not raise <CODE>Thread.Alerted</CODE>.
   The methods are to be implemented as follows:
<P>
     new        -- no database exists: create and return a new instance of
                   the desired in-core data structure, or raise Failed.
<P>
     recover    -- read from <CODE>rd</CODE> the client-specific representation
                   of a database snapshot.  Decode this representation
                   and return the resulting <CODE>REFANY</CODE>. 
 <P>
     snapshot   -- write a client-specific representation for <CODE>r</CODE> to <CODE>wr</CODE>.
<P>
     readUpdate -- read an stably logged update from <CODE>rd</CODE> and apply it
                   to the current snapshot value in <CODE>state</CODE>, and returns
                   an updated value of <CODE>state</CODE>.
<P>
     logUpdate  -- write a update to <CODE>wr</CODE> to be recorded in stable storage.


<P>
<P><PRE>PROCEDURE <A HREF="SmallDB.m3#New">New</A>(dir: TEXT; cl: Closure; pad: BOOLEAN := TRUE): T
     RAISES {OSError.E, Failed};
</PRE><BLOCKQUOTE><EM> Returns a <CODE>T</CODE> for the data that is maintained in files in the directory
   <CODE>dir</CODE>. Raises <CODE>OSError.E</CODE> if the directory doesn't exist or is
   inaccessible. If the directory exists but contains no backing files,
   creates files corresponding to a new object with no updates.
<P>
   If 'pad' then pad out updates to a disk page boundary. </EM></BLOCKQUOTE><PRE>

END SmallDB.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
