<HTML>
<HEAD>
<TITLE>SRC Modula-3: sort/src/ArraySort.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>sort/src/ArraySort.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> \index{sorting!arrays} 

<P><PRE>GENERIC INTERFACE <genericInterface><A HREF="ArraySort.mg">ArraySort</A></genericInterface>(Elem);
</PRE><BLOCKQUOTE><EM> Where <CODE>Elem.T</CODE> is a type that is not an open array type and <CODE>Elem</CODE>
   contains
<P>
<PRE>
      PROCEDURE Compare(a, b: Elem.T): [-1 .. 1];
</PRE>
   <CODE>Compare</CODE> must define a total order.  Any parameter mode may be
   used. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ArraySort.mg#Sort">Sort</A>(VAR a: ARRAY OF Elem.T; cmp := Elem.Compare);
</PRE><BLOCKQUOTE><EM> Sort the elements of <CODE>a</CODE> using the order defined by <CODE>cmp</CODE>. </EM></BLOCKQUOTE><PRE>

END ArraySort.
</PRE> <CODE>Sort(a, cmp)</CODE> permutes the elements of <CODE>a</CODE> such that:
<P>
<PRE>
      FIRST(a) &lt;= i &lt; j &lt;= LAST(a)
</PRE>
   implies
<P>
<PRE>
      cmp(a[i], a[j]) &lt;= 0.
   </PRE>
   The algorithm used is QuickSort:
   \begin{itemize}
   \item It is not stable.
   \item On average, it requires <CODE>O(N ln N)</CODE> comparison and assignment
         operations.  In the worst case it may require <CODE>O(N*N)</CODE> operations.
   \end{itemize}
<P>
   For an expanded description of QuickSort, see \cite{Sedgewick:Alg}.


<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
