<HTML>
<HEAD>
<TITLE>SRC Modula-3: sort/src/ArraySort.mg</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>sort/src/ArraySort.mg</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

GENERIC MODULE <genericModule><A HREF="ArraySort.ig">ArraySort</A></genericModule> (Elem);

PROCEDURE <A NAME="Sort"><procedure>Sort</procedure></A> (VAR a: ARRAY OF Elem.T;  cmp := Elem.Compare) =
  BEGIN
    QuickSort (a, 0, NUMBER (a), cmp);
    InsertionSort (a, 0, NUMBER (a), cmp);
  END Sort;

PROCEDURE <A NAME="QuickSort"><procedure>QuickSort</procedure></A> (VAR a: ARRAY OF Elem.T;  lo, hi: INTEGER;
                     cmp := Elem.Compare) =
  CONST CutOff = 9;
  VAR i, j: INTEGER;  key, tmp: Elem.T;
  BEGIN
    WHILE (hi - lo &gt; CutOff) DO (* sort a[lo..hi) *)

      (* use median-of-3 to select a key *)
      i := (hi + lo) DIV 2;
      IF cmp (a[lo], a[i]) &lt; 0 THEN
        IF cmp (a[i], a[hi-1]) &lt; 0 THEN
          key := a[i];
        ELSIF cmp (a[lo], a[hi-1]) &lt; 0 THEN
          key := a[hi-1];  a[hi-1] := a[i];  a[i] := key;
        ELSE
          key := a[lo];  a[lo] := a[hi-1];  a[hi-1] := a[i];  a[i] := key;
        END;
      ELSE (* a[lo] &gt;= a[i] *)
        IF cmp (a[hi-1], a[i]) &lt; 0 THEN
          key := a[i];  tmp := a[hi-1];  a[hi-1] := a[lo];  a[lo] := tmp;
        ELSIF cmp (a[lo], a[hi-1]) &lt; 0 THEN
          key := a[lo];  a[lo] := a[i];  a[i] := key;
        ELSE
          key := a[hi-1];  a[hi-1] := a[lo];  a[lo] := a[i];  a[i] := key;
        END;
      END;

      (* partition the array *)
      i := lo+1;  j := hi-2;

      (* find the first hole *)
      WHILE cmp (a[j], key) &gt; 0 DO DEC (j) END;
      tmp := a[j];
      DEC (j);

      LOOP
        IF (i &gt; j) THEN EXIT END;

        WHILE cmp (a[i], key) &lt; 0 DO INC (i) END;
        IF (i &gt; j) THEN EXIT END;
        a[j+1] := a[i];
        INC (i);

        WHILE cmp (a[j], key) &gt; 0 DO DEC (j) END;
        IF (i &gt; j) THEN  IF (j = i-1) THEN  DEC (j)  END;  EXIT  END;
        a[i-1] := a[j];
        DEC (j);
      END;

      (* fill in the last hole *)
      a[j+1] := tmp;
      i := j+2;

      (* then, recursively sort the smaller subfile *)
      IF (i - lo &lt; hi - i)
        THEN  QuickSort (a, lo, i-1, cmp);   lo := i;
        ELSE  QuickSort (a, i, hi, cmp);     hi := i-1;
      END;

    END; (* WHILE (hi-lo &gt; CutOff) *)
  END QuickSort;

PROCEDURE <A NAME="InsertionSort"><procedure>InsertionSort</procedure></A> (VAR a: ARRAY OF Elem.T;  lo, hi: INTEGER;
                         cmp := Elem.Compare) =
  VAR j: INTEGER;  key: Elem.T;
  BEGIN
    FOR i := lo+1 TO hi-1 DO
      key := a[i];
      j := i-1;
      WHILE (j &gt;= lo) AND cmp (key, a[j]) &lt; 0 DO
        a[j+1] := a[j];
        DEC (j);
      END;
      a[j+1] := key;
    END;
  END InsertionSort;

BEGIN
END ArraySort.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
